/*
 * Decompiled with CFR 0.152.
 */
package thut.lib;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CompatWrapper {
    public static final ItemStack nullStack = ItemStack.field_190927_a;
    private static final Map<String, BiomeDictionary.Type> byName = (Map)ReflectionHelper.getPrivateValue(BiomeDictionary.Type.class, null, (String[])new String[]{"byName"});

    public static void registerModEntity(Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        ResourceLocation regisrtyName = entityName.contains(":") ? new ResourceLocation(entityName) : new ResourceLocation(mc.getModId(), entityName);
        EntityRegistry.registerModEntity((ResourceLocation)regisrtyName, entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public static boolean isValid(ItemStack stack) {
        if (stack == null) {
            System.err.println("Stacks should not be null!");
            Thread.dumpStack();
            return false;
        }
        return !stack.func_190926_b();
    }

    public static NBTTagCompound getTag(ItemStack stack, String name, boolean create) {
        NBTTagCompound ret = stack.func_179543_a(name);
        if (ret == null) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            ret = new NBTTagCompound();
            stack.func_77978_p().func_74782_a(name, (NBTBase)ret);
        }
        return ret;
    }

    public static boolean interactWithBlock(Block block, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return block.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public static EntityList.EntityEggInfo getEggInfo(String name, int colour1, int colour2) {
        return new EntityList.EntityEggInfo(new ResourceLocation(name), colour1, colour2);
    }

    public static IBlockState getBlockStateFromMeta(Block block, int meta) {
        return block.func_176203_a(meta);
    }

    public static BiomeDictionary.Type getBiomeType(String name) {
        return byName.get(name.toUpperCase(Locale.ENGLISH));
    }

    public static boolean isOfType(Biome biome, BiomeDictionary.Type type) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type);
    }

    public static Set<BiomeDictionary.Type> getTypes(Biome biome) {
        return BiomeDictionary.getTypes((Biome)biome);
    }

    public static Set<Biome> getBiomes(BiomeDictionary.Type type) {
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
    }
}

