/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sonar.core.SonarRegister;
import sonar.flux.FluxConfig;
import sonar.flux.FluxCrafting;
import sonar.flux.api.FluxAPI;
import sonar.flux.common.block.FluxController;
import sonar.flux.common.block.FluxPlug;
import sonar.flux.common.block.FluxPoint;
import sonar.flux.common.block.FluxStorage;
import sonar.flux.common.entity.EntityFireItem;
import sonar.flux.common.item.ItemAdminConfigurator;
import sonar.flux.common.item.ItemConfigurator;
import sonar.flux.common.item.ItemFlux;
import sonar.flux.common.item.ItemNetworkConnector;
import sonar.flux.common.tileentity.TileController;
import sonar.flux.common.tileentity.TileFluxPlug;
import sonar.flux.common.tileentity.TileFluxPoint;
import sonar.flux.common.tileentity.TileStorage;
import sonar.flux.connection.FNEnergyTransferHandler;
import sonar.flux.connection.FNEnergyTransferProxy;
import sonar.flux.network.ClientNetworkCache;
import sonar.flux.network.FluxCommon;
import sonar.flux.network.FluxNetworkCache;

@Mod(modid="fluxnetworks", name="FluxNetworks", acceptedMinecraftVersions="[1.12,1.12.2]", version="3.0.19", dependencies="required-after:sonarcore@[5.0.19,);")
public class FluxNetworks {
    @SidedProxy(clientSide="sonar.flux.network.FluxClient", serverSide="sonar.flux.network.FluxCommon")
    public static FluxCommon proxy;
    @Mod.Instance(value="fluxnetworks")
    public static FluxNetworks instance;
    public static List<Block> block_connection_blacklist;
    public static List<Item> item_connection_blacklist;
    public static final FNEnergyTransferHandler TRANSFER_HANDLER;
    public static SimpleNetworkWrapper network;
    public static Logger logger;
    public static Item flux;
    public static Item fluxCore;
    public static Item fluxConfigurator;
    public static Item adminConfigurator;
    public static Block fluxBlock;
    public static Block fluxPlug;
    public static Block fluxPoint;
    public static Block fluxCable;
    public static Block fluxStorage;
    public static Block largeFluxStorage;
    public static Block massiveFluxStorage;
    public static Block fluxController;
    public static CreativeTabs tab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("Initialising API");
        FluxAPI.init();
        logger.info("Loading Config");
        FluxConfig.startLoading();
        logger.info("Loading Network");
        network = NetworkRegistry.INSTANCE.newSimpleChannel("Flux-Networks");
        logger.info("Loading Blocks/Items");
        fluxBlock = SonarRegister.addBlock((String)"fluxnetworks", (CreativeTabs)tab, (String)"FluxBlock", (Block)new Block(Material.field_151576_e));
        flux = SonarRegister.addItem((String)"fluxnetworks", (CreativeTabs)tab, (String)"Flux", (Item)new ItemFlux());
        fluxCore = SonarRegister.addItem((String)"fluxnetworks", (CreativeTabs)tab, (String)"FluxCore", (Item)new Item());
        fluxConfigurator = SonarRegister.addItem((String)"fluxnetworks", (CreativeTabs)tab, (String)"FluxConfigurator", (Item)new ItemConfigurator());
        adminConfigurator = SonarRegister.addItem((String)"fluxnetworks", (CreativeTabs)tab, (String)"AdminConfigurator", (Item)new ItemAdminConfigurator());
        fluxPlug = SonarRegister.addBlock((String)"fluxnetworks", (CreativeTabs)tab, new ItemNetworkConnector.FluxConnectorRegistry<Block>(new FluxPlug().func_149711_c(0.4f).func_149752_b(20.0f), "FluxPlug", TileFluxPlug.class));
        fluxPoint = SonarRegister.addBlock((String)"fluxnetworks", (CreativeTabs)tab, new ItemNetworkConnector.FluxConnectorRegistry<Block>(new FluxPoint().func_149711_c(0.4f).func_149752_b(20.0f), "FluxPoint", TileFluxPoint.class));
        fluxController = SonarRegister.addBlock((String)"fluxnetworks", (CreativeTabs)tab, new ItemNetworkConnector.FluxConnectorRegistry<Block>(new FluxController().func_149711_c(0.4f).func_149752_b(20.0f), "FluxController", TileController.class));
        fluxStorage = SonarRegister.addBlock((String)"fluxnetworks", (CreativeTabs)tab, new ItemNetworkConnector.FluxConnectorRegistry<Block>(new FluxStorage().func_149711_c(0.4f).func_149752_b(20.0f), "FluxStorage", TileStorage.Basic.class));
        largeFluxStorage = SonarRegister.addBlock((String)"fluxnetworks", (CreativeTabs)tab, new ItemNetworkConnector.FluxConnectorRegistry<Block>(new FluxStorage.Herculean().func_149711_c(0.4f).func_149752_b(20.0f), "HerculeanFluxStorage", TileStorage.Herculean.class));
        massiveFluxStorage = SonarRegister.addBlock((String)"fluxnetworks", (CreativeTabs)tab, new ItemNetworkConnector.FluxConnectorRegistry<Block>(new FluxStorage.Gargantuan().func_149711_c(0.4f).func_149752_b(20.0f), "GargantuanFluxStorage", TileStorage.Gargantuan.class));
        logger.info("Loading Entities");
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("fluxnetworks", "Flux"), EntityFireItem.class, (String)"Flux", (int)0, (Object)instance, (int)64, (int)10, (boolean)true);
        logger.info("Loading Recipes");
        FluxCrafting.addRecipes();
        logger.info("Loading Packets");
        FluxCommon.registerPackets();
        logger.info("Loading Renderers");
        proxy.registerRenderThings();
        proxy.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        logger.info("Finished Pre-Initialization");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        logger.info("Finished Initialization");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        FluxConfig.finishLoading();
        block_connection_blacklist = FNEnergyTransferProxy.getBlackListedValues(ForgeRegistries.BLOCKS, FluxConfig.block_connection_blacklist_strings);
        item_connection_blacklist = FNEnergyTransferProxy.getBlackListedValues(ForgeRegistries.ITEMS, FluxConfig.item_connection_blacklist_strings);
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        proxy.shutdown(event);
        logger.info("Cleared Network Caches");
    }

    public static ClientNetworkCache getClientCache() {
        return FluxNetworks.proxy.clientCache;
    }

    public static FluxNetworkCache getServerCache() {
        return FluxNetworks.proxy.serverCache;
    }

    static {
        TRANSFER_HANDLER = new FNEnergyTransferHandler();
        logger = LogManager.getLogger((String)"fluxnetworks");
        tab = new CreativeTabs("Flux Networks"){

            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)fluxPlug));
            }
        };
    }
}

