/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.NBTHelper;
import sonar.flux.api.ClientTransfer;
import sonar.flux.api.energy.internal.IFluxTransfer;
import sonar.flux.api.energy.internal.ITransferHandler;
import sonar.flux.api.tiles.IFlux;

public class ClientTransferHandler
implements INBTSyncable,
ITransferHandler {
    public IFlux flux;
    public List<IFluxTransfer> transfers = new ArrayList<IFluxTransfer>();
    public long removed;
    public long added;
    public long buffer;

    public ClientTransferHandler(IFlux flux) {
        this.flux = flux;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList list = nbt.func_150295_c("transfers", 10);
        this.transfers.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ClientTransfer trans = new ClientTransfer(this);
            trans.readData(tag, type);
            this.transfers.add(trans);
        }
        this.removed = nbt.func_74763_f("r");
        this.added = nbt.func_74763_f("a");
        this.buffer = nbt.func_74763_f("buf");
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList list = new NBTTagList();
        this.transfers.forEach(t -> list.func_74742_a((NBTBase)t.writeData(new NBTTagCompound(), type)));
        nbt.func_74782_a("transfers", (NBTBase)list);
        nbt.func_74772_a("r", this.removed);
        nbt.func_74772_a("a", this.added);
        nbt.func_74772_a("buf", this.buffer);
        return nbt;
    }

    public static ClientTransferHandler getInstanceFromHandler(IFlux flux, ITransferHandler handler) {
        ClientTransferHandler clienthandler = new ClientTransferHandler(flux);
        if (flux.isChunkLoaded()) {
            clienthandler.added = handler.getAdded();
            clienthandler.removed = handler.getRemoved();
            clienthandler.buffer = handler.getBuffer();
            handler.getTransfers().stream().filter(Objects::nonNull).forEach(t -> clienthandler.transfers.add(ClientTransfer.getInstanceFromHandler(clienthandler, t)));
        }
        return clienthandler;
    }

    @Override
    public void onStartServerTick() {
    }

    @Override
    public void onEndWorldTick() {
    }

    @Override
    public long getBuffer() {
        return this.buffer;
    }

    @Override
    public long getAdded() {
        return this.added;
    }

    @Override
    public long getRemoved() {
        return this.removed;
    }

    @Override
    public boolean hasTransfers() {
        return !this.transfers.isEmpty();
    }

    @Override
    public void updateTransfers(EnumFacing ... face) {
    }

    @Override
    public List<IFluxTransfer> getTransfers() {
        return this.transfers;
    }

    @Override
    public long addToNetwork(long maxTransferRF, EnergyType type, ActionType actionType) {
        return 0L;
    }

    @Override
    public long removeFromNetwork(long maxTransferRF, EnergyType type, ActionType actionType) {
        return 0L;
    }
}

