/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui.tabs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.client.gui.SelectionGrid;
import sonar.core.client.gui.SonarTextField;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.SonarHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.FluxTranslate;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.EnumActivationType;
import sonar.flux.api.EnumPriorityType;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.client.gui.GuiTabAbstract;
import sonar.flux.client.gui.GuiTabAbstractGrid;
import sonar.flux.client.gui.buttons.CheckBox;
import sonar.flux.client.gui.buttons.FluxTextField;
import sonar.flux.client.gui.buttons.PriorityButton;
import sonar.flux.client.gui.buttons.RedstoneSignalButton;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.PacketEditedTiles;

public class GuiTabIndexSingleEditing<G>
extends GuiTabAbstractGrid<G> {
    public ClientFlux flux;
    public SonarTextField fluxName;
    public SonarTextField priority;
    public SonarTextField limit;

    public GuiTabIndexSingleEditing(GuiTabAbstract origin, ClientFlux flux, List<EnumGuiTab> tabs) {
        super(tabs);
        this.flux = flux;
        this.setOrigin((Object)origin);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int networkColour = NetworkSettings.NETWORK_COLOUR.getValue(this.common).getRGB();
        this.priority = FluxTextField.create(FluxTranslate.PRIORITY.t() + ": ", 0, this.getFontRenderer(), 8, 46, 147, 12).setBoxOutlineColour(networkColour).setDigitsOnly(true);
        this.priority.func_146203_f(8);
        this.priority.func_146180_a(String.valueOf(this.flux.priority));
        this.limit = FluxTextField.create(FluxTranslate.TRANSFER_LIMIT.t() + ": ", 1, this.getFontRenderer(), 8, 64, 147, 12).setBoxOutlineColour(networkColour).setDigitsOnly(true);
        this.limit.func_146203_f(8);
        this.limit.func_146180_a(String.valueOf(this.flux.limit));
        this.fluxName = FluxTextField.create(FluxTranslate.NAME.t() + ": ", 2, this.getFontRenderer(), 8, 28, 147, 12).setBoxOutlineColour(networkColour);
        this.fluxName.func_146203_f(24);
        this.fluxName.func_146180_a(this.flux.getCustomName());
        this.fieldList.addAll(Lists.newArrayList((Object[])new SonarTextField[]{this.priority, this.limit, this.fluxName}));
        this.field_146292_n.add(new CheckBox(this, 3, this.getGuiLeft() + 156, this.getGuiTop() + 64, () -> !this.flux.disableLimit, FluxTranslate.ENABLE_LIMIT.t()));
        this.field_146292_n.add(new RedstoneSignalButton(this, 4, this.getGuiLeft() + 156, this.getGuiTop() + 28, () -> this.flux.activation_type, ""));
        this.field_146292_n.add(new PriorityButton(this, 5, this.getGuiLeft() + 156, this.getGuiTop() + 46, () -> this.flux.priority_type, ""));
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.renderNetwork(NetworkSettings.NETWORK_NAME.getValue(this.common), NetworkSettings.NETWORK_ACCESS.getValue(this.common), NetworkSettings.NETWORK_COLOUR.getValue(this.common).getRGB(), true, 11, 8);
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            this.switchTab(EnumGuiTab.NETWORK_SELECTION);
            return;
        }
        if (button.field_146127_k == 3) {
            this.flux.disableLimit = !this.flux.disableLimit;
            return;
        }
        if (button.field_146127_k == 4) {
            this.flux.activation_type = (EnumActivationType)SonarHelper.incrementEnum((Enum)this.flux.activation_type, (Enum[])EnumActivationType.values());
            return;
        }
        if (button.field_146127_k == 5) {
            this.flux.priority_type = (EnumPriorityType)SonarHelper.incrementEnum((Enum)this.flux.priority_type, (Enum[])EnumPriorityType.values());
            return;
        }
    }

    @Override
    public void func_73864_a(int x, int y, int mouseButton) throws IOException {
        super.func_73864_a(x, y, mouseButton);
        if (x - this.getGuiLeft() > 5 && x - this.getGuiLeft() < 165 && y - this.getGuiTop() > 10 && y - this.getGuiTop() < 20) {
            this.switchTab(EnumGuiTab.NETWORK_SELECTION);
        }
    }

    public void onTextFieldChanged(SonarTextField field) {
        super.onTextFieldChanged(field);
        if (field == this.priority) {
            this.flux.priority = this.priority.getIntegerFromText();
        } else if (field == this.limit) {
            this.flux.limit = this.limit.getLongFromText();
        } else if (field == this.fluxName) {
            this.flux.customName = this.fluxName.func_146179_b();
        }
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.isCloseKey(keyCode)) {
            FluxNetworks.network.sendToServer((IMessage)new PacketEditedTiles(Lists.newArrayList((Object[])new ClientFlux[]{this.flux})));
        }
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    public ResourceLocation getBackground() {
        return scroller_flux_gui;
    }

    @Override
    public EnumGuiTab getCurrentTab() {
        return EnumGuiTab.CONNECTIONS;
    }

    public void onGridClicked(int gridID, G element, int x, int y, int pos, int button, boolean empty) {
    }

    public void renderGridElement(int gridID, G element, int x, int y, int slot) {
    }

    public void renderElementToolTip(int gridID, G element, int x, int y) {
    }

    @Override
    public List getGridList(int gridID) {
        return new ArrayList();
    }

    @Override
    public void addGrids(Map<SelectionGrid, SonarScroller> grids) {
    }
}

