/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection.transfer;

import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.inventories.ItemStackHelper;
import sonar.flux.api.energy.internal.IEnergyTransfer;
import sonar.flux.common.tileentity.TileStorage;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.connection.transfer.BaseFluxTransfer;

public class StorageTransfer
extends BaseFluxTransfer
implements IEnergyTransfer {
    public final TileStorage tile;

    public StorageTransfer(TileStorage tile) {
        super(tile.getNetwork().getSetting(NetworkSettings.NETWORK_ENERGY_TYPE));
        this.tile = tile;
    }

    @Override
    public long addToNetwork(long maxTransferRF, ActionType actionType) {
        long remove = this.tile.storage.removeEnergy(maxTransferRF, actionType);
        if (!actionType.shouldSimulate()) {
            this.addedToNetwork(remove, this.getEnergyType());
        }
        return remove;
    }

    @Override
    public long removeFromNetwork(long maxTransferRF, ActionType actionType) {
        long added = this.tile.storage.addEnergy(maxTransferRF, actionType);
        if (!actionType.shouldSimulate()) {
            this.removedFromNetwork(added, this.getEnergyType());
        }
        return added;
    }

    @Override
    public ItemStack getDisplayStack() {
        return ItemStackHelper.getBlockItem((World)this.tile.func_145831_w(), (BlockPos)this.tile.func_174877_v());
    }

    @Override
    public EnergyType getEnergyType() {
        return this.tile.getNetwork().getSetting(NetworkSettings.NETWORK_ENERGY_TYPE);
    }
}

