/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection.transfer.handlers;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.ITileEnergyHandler;
import sonar.core.api.utils.ActionType;
import sonar.flux.FluxNetworks;
import sonar.flux.api.energy.internal.IFluxTransfer;
import sonar.flux.api.energy.internal.ITransferHandler;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.connection.transfer.ConnectionTransfer;
import sonar.flux.connection.transfer.ISidedTransfer;
import sonar.flux.connection.transfer.PhantomTransfer;
import sonar.flux.connection.transfer.SidedPhantomTransfer;
import sonar.flux.connection.transfer.handlers.FluxTransferHandler;

public class ConnectionTransferHandler
extends FluxTransferHandler
implements ITransferHandler {
    public final TileEntity tile;
    public final List<EnumFacing> validFaces;
    public boolean hasTransfers;
    public boolean wasChanged = true;
    public Map<EnumFacing, IFluxTransfer> transfers = new HashMap<EnumFacing, IFluxTransfer>();

    public ConnectionTransferHandler(TileEntity tile, IFlux flux, List<EnumFacing> validFaces) {
        super(flux);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.transfers.put(face, null);
        }
        this.tile = tile;
        this.validFaces = validFaces;
    }

    @Override
    public void onStartServerTick() {
        super.onStartServerTick();
        this.transfers.entrySet().stream().filter(E -> E.getValue() != null).forEach(E -> ((IFluxTransfer)E.getValue()).onStartServerTick());
    }

    @Override
    public void onEndWorldTick() {
        super.onEndWorldTick();
        this.transfers.entrySet().stream().filter(E -> E.getValue() != null).forEach(E -> ((IFluxTransfer)E.getValue()).onEndWorldTick());
    }

    public IFluxTransfer getValidPhantomTransfer(EnumFacing from, EnergyType energy_type, ActionType type) {
        TileEntity expected_source;
        if (this.getNetwork().isFakeNetwork()) {
            return null;
        }
        IFluxTransfer transfer = this.transfers.get(from);
        TileEntity tileEntity = expected_source = from == null ? null : this.tile.func_145831_w().func_175625_s(this.tile.func_174877_v().func_177972_a(from));
        if (from == null || expected_source == null || transfer instanceof ISidedTransfer && ((ISidedTransfer)transfer).getTile() != expected_source) {
            if (type.shouldSimulate()) {
                transfer = this.transfers.getOrDefault(null, new PhantomTransfer(energy_type));
            } else {
                Optional<Map.Entry> firstEUTransfer;
                if (energy_type == EnergyType.EU && (firstEUTransfer = this.transfers.entrySet().stream().filter(E -> E.getValue() != null && ((IFluxTransfer)E.getValue()).getEnergyType() == EnergyType.EU).findAny()).isPresent()) {
                    return (IFluxTransfer)firstEUTransfer.get().getValue();
                }
                transfer = this.transfers.computeIfAbsent(null, E -> new PhantomTransfer(energy_type));
            }
        } else if (transfer == null) {
            ITileEnergyHandler handler = FluxNetworks.TRANSFER_HANDLER.getTileHandler(expected_source, from);
            transfer = handler != null ? this.transfers.computeIfAbsent(from, E -> new ConnectionTransfer(this, handler, expected_source, from)) : this.transfers.computeIfAbsent(from, E -> new SidedPhantomTransfer(energy_type, expected_source, from));
        }
        return transfer;
    }

    public long addPhantomEnergyToNetwork(EnumFacing from, long maxReceive, EnergyType energy_type, ActionType type) {
        if (!this.flux.isActive()) {
            return 0L;
        }
        IFluxTransfer transfer = this.getValidPhantomTransfer(from, energy_type, type);
        if (transfer != null && this.getNetwork().canTransfer(energy_type) && this.getNetwork().canConvert(energy_type, this.getNetwork().getSetting(NetworkSettings.NETWORK_ENERGY_TYPE))) {
            long added = this.addToBuffer(maxReceive, energy_type, type.shouldSimulate());
            if (!type.shouldSimulate()) {
                transfer.addedToNetwork(added, energy_type);
            }
            return added;
        }
        return 0L;
    }

    @Override
    public List<IFluxTransfer> getTransfers() {
        return Lists.newArrayList(this.transfers.values());
    }

    public void setTransfer(EnumFacing face, TileEntity tile) {
        ITileEnergyHandler handler;
        IFluxTransfer transfer = this.transfers.get(face);
        if (tile == null || (handler = FluxNetworks.TRANSFER_HANDLER.getTileHandler(tile, face.func_176734_d())) == null) {
            this.transfers.put(face, null);
        } else if (!(transfer instanceof ConnectionTransfer) || ((ConnectionTransfer)transfer).getTile() != tile) {
            ConnectionTransfer newTransfer = new ConnectionTransfer(this, handler, tile, face);
            this.transfers.put(face, newTransfer);
        } else if (transfer.isInvalid()) {
            this.transfers.put(face, null);
        }
    }

    @Override
    public void updateTransfers(EnumFacing ... faces) {
        boolean change = false;
        for (EnumFacing face : faces) {
            boolean isConnected;
            if (!this.validFaces.contains(face)) continue;
            BlockPos neighbour_pos = this.tile.func_174877_v().func_177972_a(face);
            TileEntity neighbour_tile = this.tile.func_145831_w().func_175625_s(neighbour_pos);
            boolean wasConnected = this.transfers.get(face) != null;
            this.setTransfer(face, neighbour_tile);
            boolean bl = isConnected = this.transfers.get(face) != null;
            if (wasConnected == isConnected) continue;
            change = true;
        }
        this.wasChanged = change;
    }

    @Override
    public boolean hasTransfers() {
        return this.hasTransfers;
    }
}

