/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter;

import cubex2.mods.chesttransporter.ChestTransporter;
import cubex2.mods.chesttransporter.TransporterType;
import cubex2.mods.chesttransporter.Util;
import cubex2.mods.chesttransporter.api.TransportableChest;
import cubex2.mods.chesttransporter.chests.ChestRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemChestTransporter
extends Item {
    public final TransporterType type;

    ItemChestTransporter(TransporterType type) {
        this.type = type;
        this.func_77655_b("chesttransporter_" + type.iconName);
        this.func_77625_d(1);
        this.func_77656_e(type.maxDamage);
        this.func_77637_a(CreativeTabs.field_78040_i);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() || stack.func_77973_b() != this) {
            return EnumActionResult.PASS;
        }
        boolean[] success = new boolean[]{false};
        if (ItemChestTransporter.hasChest(stack)) {
            ItemChestTransporter.getChest(stack).ifPresent(chest -> {
                this.placeChest((TransportableChest)((Object)chest), stack, player, hand, world, pos, side);
                success[0] = true;
            });
        } else if (!MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), player))) {
            ItemChestTransporter.getChest(world, pos, world.func_180495_p(pos), player, stack).ifPresent(chest -> {
                this.grabChest((TransportableChest)((Object)chest), stack, player, world, pos);
                success[0] = true;
            });
        }
        return success[0] ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    private void grabChest(TransportableChest chest, ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            IBlockState iblockstate = world.func_180495_p(pos);
            Block chestBlock = iblockstate.func_177230_c();
            ItemChestTransporter.getTagCompound(stack).func_74778_a("ChestName", chest.getRegistryName().toString());
            if (chest.copyTileEntity()) {
                NBTTagCompound nbt = new NBTTagCompound();
                tile.func_189515_b(nbt);
                ItemChestTransporter.getTagCompound(stack).func_74782_a("ChestTile", (NBTBase)nbt);
                world.func_175713_t(pos);
            } else {
                IInventory inv = (IInventory)tile;
                ItemChestTransporter.moveItemsIntoStack(inv, stack);
            }
            chest.preRemoveChest(world, pos, player, stack);
            world.func_175698_g(pos);
            SoundType soundType = chestBlock.func_185467_w();
            world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        }
    }

    private void placeChest(TransportableChest chest, ItemStack stack, EntityPlayer player, EnumHand hand, World world, BlockPos pos, EnumFacing face) {
        BlockPos chestPos = this.getChestCoords(world, pos, face);
        if (!chest.canPlaceChest(world, chestPos, player, stack)) {
            return;
        }
        ItemStack chestStack = chest.createChestStack(stack);
        if (chestStack.func_190926_b()) {
            return;
        }
        player.func_184611_a(hand, chestStack);
        EnumActionResult result = chestStack.func_179546_a(player, world, pos, hand, face, 0.0f, 0.0f, 0.0f);
        player.func_184611_a(hand, stack);
        if (result != EnumActionResult.SUCCESS) {
            return;
        }
        TileEntity tile = world.func_175625_s(chestPos);
        if (tile == null) {
            return;
        }
        if (chest.copyTileEntity()) {
            NBTTagCompound nbt = ItemChestTransporter.getTagCompound(stack).func_74775_l("ChestTile");
            nbt = chest.modifyTileCompound(nbt, world, pos, player, stack);
            world.func_175690_a(chestPos, TileEntity.func_190200_a((World)world, (NBTTagCompound)nbt));
        } else {
            IInventory inv = (IInventory)tile;
            this.moveItemsIntoChest(stack, inv);
        }
        ItemChestTransporter.getTagCompound(stack).func_82580_o("ChestType");
        ItemChestTransporter.getTagCompound(stack).func_82580_o("ChestName");
        chest.onChestPlaced(world, pos, player, stack);
        this.damageItem(stack, player);
    }

    private BlockPos getChestCoords(World world, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!(block == Blocks.field_150431_aC && (Integer)iblockstate.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1 || block.func_176200_f((IBlockAccess)world, pos))) {
            pos = pos.func_177972_a(facing);
        }
        return pos;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean par5) {
        if (ItemChestTransporter.hasChest(stack) && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            if (ChestTransporter.debuffSlowness) {
                this.addEffect(player, MobEffects.field_76421_d, 2);
            }
            if (ChestTransporter.debuffMiningFatigue) {
                this.addEffect(player, MobEffects.field_76419_f, 3);
            }
            if (ChestTransporter.debuffJump) {
                this.addEffect(player, MobEffects.field_76430_j, -2);
            }
            if (ChestTransporter.debuffHunger) {
                this.addEffect(player, MobEffects.field_76438_s, 0);
            }
        }
    }

    private void addEffect(EntityPlayer player, Potion potion, int amplifier) {
        PotionEffect effect = player.func_70660_b(potion);
        if (effect == null || effect.func_76459_b() < 20) {
            player.func_70690_d(new PotionEffect(potion, 60, amplifier));
        }
    }

    @SubscribeEvent
    public void entityInteract(MinecartInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack stack = event.getItem();
        EntityMinecart minecart = event.getMinecart();
        if (stack.func_190926_b() || stack.func_77973_b() != this || minecart == null) {
            return;
        }
        Optional<TransportableChest> chest = ItemChestTransporter.getChest(stack);
        EntityPlayer player = event.getPlayer();
        if (minecart instanceof EntityMinecartEmpty && !minecart.func_184207_aI() && chest.isPresent() && ChestRegistry.isMinecartChest(chest.get())) {
            EntityMinecart newMinecart = ChestRegistry.createMinecart(minecart.field_70170_p, chest.get());
            if (newMinecart == null) {
                return;
            }
            if (!player.field_70170_p.field_72995_K) {
                this.replaceMinecart(minecart, newMinecart);
            }
            this.moveItemsIntoChest(stack, (IInventory)newMinecart);
            ItemChestTransporter.getTagCompound(stack).func_82580_o("ChestName");
            ItemChestTransporter.getTagCompound(stack).func_82580_o("ChestType");
            SoundType soundType = Blocks.field_150486_ae.func_185467_w();
            minecart.field_70170_p.func_184133_a(player, minecart.func_180425_c(), soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
            this.damageItem(stack, player);
            event.setCanceled(true);
        } else if (ChestRegistry.isSupportedMinecart(minecart) && !chest.isPresent()) {
            ItemChestTransporter.moveItemsIntoStack((IInventory)minecart, stack);
            ItemChestTransporter.getTagCompound(stack).func_74778_a("ChestName", ChestRegistry.getChestType(minecart).toString());
            SoundType soundType = Blocks.field_150486_ae.func_185467_w();
            minecart.field_70170_p.func_184133_a(player, minecart.func_180425_c(), soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
            if (!player.field_70170_p.field_72995_K) {
                EntityMinecartEmpty newMinecart = new EntityMinecartEmpty(minecart.field_70170_p);
                this.replaceMinecart(minecart, (EntityMinecart)newMinecart);
            }
            event.setCanceled(true);
        }
    }

    private void damageItem(ItemStack stack, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_77972_a(1, (EntityLivingBase)player);
            if (this.type.maxDamage == 1) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
    }

    private void replaceMinecart(EntityMinecart old, EntityMinecart now) {
        now.func_70080_a(old.field_70165_t, old.field_70163_u, old.field_70161_v, old.field_70125_A, old.field_70177_z);
        old.field_70170_p.func_72838_d((Entity)now);
        old.func_70106_y();
    }

    public boolean func_77651_p() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag advanced) {
        NBTTagCompound tagCompound = ItemChestTransporter.getTagCompound(stack);
        ItemChestTransporter.getChest(stack).ifPresent(chest -> {
            NonNullList<Pair<Integer, ItemStack>> items = Util.readItemsFromNBT(tagCompound);
            int numItems = 0;
            for (Pair pair : items) {
                numItems += ((ItemStack)pair.getRight()).func_190916_E();
            }
            if (numItems > 0) {
                list.add("Contains " + numItems + " items");
            }
            list.add(chest.getRegistryName().toString());
            chest.addInformation(stack, world, list, advanced);
        });
    }

    private static boolean hasChest(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        byte chestType = stack.func_77978_p().func_74771_c("ChestType");
        if (chestType != 0) {
            return true;
        }
        String chestName = stack.func_77978_p().func_74779_i("ChestName");
        return ChestRegistry.getChestFromType(new ResourceLocation(chestName)).isPresent();
    }

    private static Optional<TransportableChest> getChest(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack transporter) {
        for (TransportableChest chest : ChestRegistry.getChests()) {
            if (!chest.canGrabChest(world, pos, state, player, transporter)) continue;
            return Optional.of(chest);
        }
        return Optional.empty();
    }

    public static Optional<TransportableChest> getChest(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Optional.empty();
        }
        Optional<TransportableChest> chest = ChestRegistry.getChestFromType(stack.func_77978_p().func_74771_c("ChestType"));
        if (chest.isPresent()) {
            return chest;
        }
        return ChestRegistry.getChestFromType(new ResourceLocation(stack.func_77978_p().func_74779_i("ChestName")));
    }

    private static void moveItemsIntoStack(IInventory chest, ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList nbtList = new NBTTagList();
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (chest.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound nbtTabCompound2 = new NBTTagCompound();
            nbtTabCompound2.func_74777_a("Slot", (short)i);
            chest.func_70301_a(i).func_77946_l().func_77955_b(nbtTabCompound2);
            chest.func_70299_a(i, ItemStack.field_190927_a);
            nbtList.func_74742_a((NBTBase)nbtTabCompound2);
        }
        stack.func_77978_p().func_74782_a("Items", (NBTBase)nbtList);
    }

    private void moveItemsIntoChest(ItemStack stack, IInventory chest) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbtTag = ItemChestTransporter.getTagCompound(stack);
        NonNullList<Pair<Integer, ItemStack>> items = Util.readItemsFromNBT(nbtTag);
        for (Pair pair : items) {
            if ((Integer)pair.getLeft() >= chest.func_70302_i_()) continue;
            chest.func_70299_a(((Integer)pair.getLeft()).intValue(), (ItemStack)pair.getRight());
        }
        nbtTag.func_82580_o("Items");
    }

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }
}

