/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import openblocks.client.renderer.block.canvas.CanvasSideState;
import openblocks.client.renderer.block.canvas.CanvasState;
import openblocks.client.renderer.block.canvas.InnerModelInfo;
import openblocks.client.renderer.block.canvas.ModelQuads;
import openblocks.client.renderer.block.canvas.RenderLayerCache;
import openblocks.client.renderer.block.canvas.StencilCoverQuadBuilder;
import openblocks.client.renderer.block.canvas.StencilTextureProjection;
import openblocks.client.renderer.block.canvas.TextureOrientation;
import openmods.geometry.FaceClassifier;

public class StencilModelTransformer {
    private static final int NO_TINT = -1;
    private static final double COVER_DELTA = 0.01;
    private final InnerModelInfo baseModel;
    private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private final VertexFormat vertexFormat;
    private final RenderLayerCache renderLayerCache;
    private final LoadingCache<IBlockState, InnerModelInfo> innerModelCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<IBlockState, InnerModelInfo>(){

        public InnerModelInfo load(IBlockState blockState) {
            if (blockState.func_185901_i() != EnumBlockRenderType.MODEL) {
                return StencilModelTransformer.this.baseModel;
            }
            IBakedModel innerModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(blockState);
            Block block = blockState.func_177230_c();
            return InnerModelInfo.create(blockState, innerModel, (Predicate<BlockRenderLayer>)((Predicate)input -> block.canRenderInLayer(blockState, input)));
        }
    });
    private final LoadingCache<Key, ModelQuads> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(notification -> {
        Optional<CanvasState> canvasState = ((Key)notification.getKey()).canvasState;
        if (canvasState.isPresent()) {
            canvasState.get().release();
        }
    }).build((CacheLoader)new CacheLoader<Key, ModelQuads>(){

        public ModelQuads load(Key key) throws Exception {
            InnerModelInfo innerModel;
            if (key.canvasState.isPresent()) {
                key.canvasState.get().acquire();
            }
            RenderLayerCache.LayerRenderInfo layersToRender = StencilModelTransformer.this.renderLayerCache.get(key.innerBlockState, key.renderLayer);
            if (layersToRender.layers.isEmpty()) {
                return ModelQuads.EMPTY;
            }
            InnerModelInfo innerModelInfo = innerModel = key.innerBlockState.isPresent() ? (InnerModelInfo)StencilModelTransformer.this.innerModelCache.get((Object)key.innerBlockState.get()) : StencilModelTransformer.this.baseModel;
            if (!key.canvasState.isPresent()) {
                ModelQuads.Builder builder = ModelQuads.builder();
                for (BlockRenderLayer layer : layersToRender.layers) {
                    builder.merge(innerModel.layers.get(layer));
                }
                return builder.build();
            }
            CanvasState canvasState = key.canvasState.get();
            FaceClassifier faceClassifier = new FaceClassifier(canvasState.applicationOrder());
            ModelQuads.Builder builder = ModelQuads.builder();
            for (BlockRenderLayer layer : layersToRender.layers) {
                ModelQuads layerQuads = innerModel.layers.get(layer);
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    builder.addSidedQuads(side, StencilModelTransformer.this.prepareQuads(layerQuads.get(side), canvasState.sideStates, faceClassifier));
                }
                builder.addGeneralQuads(StencilModelTransformer.this.prepareQuads(layerQuads.get(null), canvasState.sideStates, faceClassifier));
            }
            if (layersToRender.renderCovers) {
                builder.addGeneralQuads(StencilModelTransformer.this.addStencilCovers(innerModel.bounds.func_186662_g(0.01), canvasState.sideStates));
            }
            return builder.build();
        }
    });

    public StencilModelTransformer(IBakedModel baseModel, Set<BlockRenderLayer> baseModelLayers, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, VertexFormat vertexFormat) {
        this.renderLayerCache = new RenderLayerCache((Predicate<BlockRenderLayer>)((Predicate)baseModelLayers::contains));
        this.baseModel = InnerModelInfo.create(null, baseModel, (Predicate<BlockRenderLayer>)((Predicate)baseModelLayers::contains));
        this.bakedTextureGetter = bakedTextureGetter;
        this.vertexFormat = vertexFormat;
    }

    private List<BakedQuad> prepareQuads(List<BakedQuad> baseQuads, Map<EnumFacing, CanvasSideState> sides, FaceClassifier faceClassifier) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)baseQuads.size());
        for (BakedQuad input : baseQuads) {
            result.addAll(this.prepareQuad(input, sides, faceClassifier));
        }
        return result;
    }

    private List<BakedQuad> prepareQuad(BakedQuad input, Map<EnumFacing, CanvasSideState> sides, FaceClassifier faceClassifier) {
        Vector3f[] pos = new Vector3f[4];
        VertexFormat format = input.getFormat();
        int[] vertexData = input.func_178209_a();
        ByteBuffer buffer = ByteBuffer.allocate(vertexData.length * 4);
        buffer.asIntBuffer().put(vertexData);
        buffer.limit(vertexData.length * 4);
        int vertexSize = format.func_177338_f();
        for (int i = 0; i < 4; ++i) {
            buffer.position(vertexSize * i);
            float x = buffer.getFloat();
            float y = buffer.getFloat();
            float z = buffer.getFloat();
            pos[i] = new Vector3f(x, y, z);
        }
        buffer.rewind();
        Vector3f quadNormal = StencilModelTransformer.calculateNormal(pos);
        Optional face = faceClassifier.classify(quadNormal);
        if (!face.isPresent()) {
            return ImmutableList.of((Object)input);
        }
        ArrayList quads = Lists.newArrayList();
        CanvasSideState sideInfo = sides.get(face.get());
        if (!sideInfo.isFullCover()) {
            quads.add(input);
        }
        if (sideInfo.hasStencils()) {
            CanvasSideState.OrientedTexture layersTextureInfo = sideInfo.getLayersTexture();
            quads.add(StencilModelTransformer.retextureQuad(input, buffer, (EnumFacing)face.get(), this.bakedTextureGetter.apply(layersTextureInfo.location), layersTextureInfo.orientation, pos));
        }
        return quads;
    }

    private static BakedQuad retextureQuad(BakedQuad original, ByteBuffer contents, EnumFacing side, TextureAtlasSprite texture, TextureOrientation orientation, Vector3f[] positions) {
        VertexFormat format = original.getFormat();
        int vertexSize = format.func_177338_f();
        int firstTextureOffset = format.func_177344_b(0);
        StencilTextureProjection projection = new StencilTextureProjection(side);
        for (int i = 0; i < 4; ++i) {
            Vector3f position = positions[i];
            contents.position(i * vertexSize);
            contents.putFloat(position.x);
            contents.putFloat(position.y);
            contents.putFloat(position.z);
            int shiftedI = orientation.shift(i);
            contents.position(shiftedI * vertexSize + firstTextureOffset);
            Vector2f projectedUv = projection.project(position);
            float nU = texture.func_94214_a((double)(16.0f * projectedUv.x));
            contents.putFloat(nU);
            float nV = texture.func_94207_b((double)(16.0f * projectedUv.y));
            contents.putFloat(nV);
        }
        int outputSize = format.func_181719_f() * 4;
        int[] data = new int[outputSize];
        contents.position(0);
        contents.asIntBuffer().get(data);
        return new BakedQuad(data, -1, original.func_178210_d(), texture, original.shouldApplyDiffuseLighting(), format);
    }

    private static Vector3f calculateNormal(Vector3f[] pos) {
        Vector3f a = new Vector3f();
        a.sub((Tuple3f)pos[0], (Tuple3f)pos[2]);
        Vector3f b = new Vector3f();
        b.sub((Tuple3f)pos[1], (Tuple3f)pos[3]);
        a.cross(a, b);
        a.normalize();
        return a;
    }

    private List<BakedQuad> addStencilCovers(AxisAlignedBB bounds, Map<EnumFacing, CanvasSideState> sides) {
        StencilCoverQuadBuilder builder = new StencilCoverQuadBuilder(bounds, this.vertexFormat, -1);
        for (Map.Entry<EnumFacing, CanvasSideState> e : sides.entrySet()) {
            CanvasSideState state = e.getValue();
            Optional<CanvasSideState.OrientedTexture> maybeCoverTextureInfo = state.getCoverTexture();
            if (!maybeCoverTextureInfo.isPresent()) continue;
            CanvasSideState.OrientedTexture coverTextureInfo = maybeCoverTextureInfo.get();
            builder.add(e.getKey(), this.bakedTextureGetter.apply(coverTextureInfo.location), coverTextureInfo.orientation);
        }
        return builder.build();
    }

    public ModelQuads getQuads(Optional<IBlockState> innerBlock, Optional<CanvasState> canvasState, BlockRenderLayer renderLayer) {
        Key key = new Key(innerBlock, canvasState, renderLayer);
        return (ModelQuads)this.cache.getUnchecked((Object)key);
    }

    private static class Key {
        public final Optional<IBlockState> innerBlockState;
        public final Optional<CanvasState> canvasState;
        public final BlockRenderLayer renderLayer;
        private final int hash;

        public Key(Optional<IBlockState> innerBlockState, Optional<CanvasState> canvasState, BlockRenderLayer renderLayer) {
            this.innerBlockState = innerBlockState;
            this.canvasState = canvasState;
            this.renderLayer = renderLayer;
            this.hash = this.hash();
        }

        public int hash() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.canvasState.hashCode();
            result = 31 * result + this.innerBlockState.hashCode();
            result = 31 * result + this.renderLayer.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.canvasState.equals(other.canvasState) && this.innerBlockState.equals(other.innerBlockState) && this.renderLayer == other.renderLayer;
            }
            return false;
        }

        public String toString() {
            return "inner = " + this.innerBlockState + "\ncanvas = " + this.canvasState + "\nlayer = " + this.renderLayer;
        }
    }
}

