/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityImaginary;
import openmods.block.OpenBlock;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.Orientation;
import openmods.utils.BlockUtils;

public class BlockImaginary
extends OpenBlock.FourDirections {
    public static final PropertyEnum<Shape> PROPERTY_SHAPE = PropertyEnum.func_177709_a((String)"shape", Shape.class);
    public static final PropertyEnum<Type> PROPERTY_TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    private static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final double PANEL_HEIGHT = 0.1;
    private static final AxisAlignedBB FULL_PANEL_AABB = new AxisAlignedBB(0.0, 0.9, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB HALF_PANEL_AABB = new AxisAlignedBB(0.0, 0.4, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB STAIRS_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB LOWER_STEP_PANEL_AABB = new AxisAlignedBB(0.0, 0.4, 0.0, 1.0, 0.5, 0.5);
    private static final AxisAlignedBB UPPER_STEP_PANEL_AABB = new AxisAlignedBB(0.0, 0.9, 0.5, 1.0, 1.0, 1.0);
    private static final Material IMAGINARY = new Material(MapColor.field_151660_b){

        public boolean func_76230_c() {
            return false;
        }

        public boolean func_76228_b() {
            return false;
        }
    };

    public BlockImaginary() {
        super(IMAGINARY);
        this.func_180632_j(this.func_176223_P().func_177226_a(PROPERTY_SHAPE, (Comparable)((Object)Shape.BLOCK)).func_177226_a(PROPERTY_TYPE, (Comparable)((Object)Type.PENCIL)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyOrientation(), PROPERTY_TYPE, PROPERTY_SHAPE});
    }

    public void setSoundType() {
        this.func_149672_a(new SoundType(0.5f, 1.0f, OpenBlocks.Sounds.ITEM_CRAYON_PLACE, OpenBlocks.Sounds.ITEM_CRAYON_PLACE, OpenBlocks.Sounds.ITEM_CRAYON_PLACE, OpenBlocks.Sounds.ITEM_CRAYON_PLACE, OpenBlocks.Sounds.ITEM_CRAYON_PLACE));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        TileEntityImaginary te = (TileEntityImaginary)((Object)BlockImaginary.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityImaginary.class));
        if (te != null && te.is(TileEntityImaginary.Property.SELECTABLE)) {
            Orientation orientation = (Orientation)state.func_177229_b(this.getPropertyOrientation());
            return te.getShape().getBlockBounds(orientation).func_186670_a(pos);
        }
        return EMPTY_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean something) {
        TileEntityImaginary te = (TileEntityImaginary)((Object)BlockImaginary.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityImaginary.class));
        if (te != null && te.is(TileEntityImaginary.Property.SOLID, entity)) {
            Orientation orientation = (Orientation)state.func_177229_b(this.getPropertyOrientation());
            te.getShape().addCollisions(orientation, pos, entityBox, collidingBoxes);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return EMPTY_AABB;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntityImaginary te = (TileEntityImaginary)((Object)BlockImaginary.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityImaginary.class));
        if (world.field_72995_K && (te == null || !te.is(TileEntityImaginary.Property.SELECTABLE))) {
            return null;
        }
        AxisAlignedBB box = te.getShape().getBlockBounds((Orientation)blockState.func_177229_b(this.getPropertyOrientation()));
        return this.func_185503_a(pos, start, end, box);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Lists.newArrayList();
    }

    protected boolean suppressPickBlock() {
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityImaginary te = (TileEntityImaginary)((Object)BlockImaginary.getTileEntity((IBlockAccess)worldIn, (BlockPos)pos, TileEntityImaginary.class));
        if (te != null) {
            Shape shape = te.getShape();
            Type type = te.getType();
            return state.func_177226_a(PROPERTY_SHAPE, (Comparable)((Object)shape)).func_177226_a(PROPERTY_TYPE, (Comparable)((Object)type));
        }
        return state;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum Shape implements IStringSerializable
    {
        BLOCK{

            @Override
            public void addCollisions(Orientation orientation, BlockPos pos, AxisAlignedBB region, List<AxisAlignedBB> result) {
                AxisAlignedBB aabb = BlockUtils.singleBlock((BlockPos)pos);
                Shape.addBox(aabb, region, result);
            }

            @Override
            public AxisAlignedBB getBlockBounds(Orientation orientation) {
                return Block.field_185505_j;
            }
        }
        ,
        PANEL{

            @Override
            public void addCollisions(Orientation orientation, BlockPos pos, AxisAlignedBB region, List<AxisAlignedBB> result) {
                AxisAlignedBB aabb = FULL_PANEL_AABB.func_186670_a(pos);
                Shape.addBox(aabb, region, result);
            }

            @Override
            public AxisAlignedBB getBlockBounds(Orientation orientation) {
                return FULL_PANEL_AABB;
            }
        }
        ,
        HALF_PANEL{

            @Override
            public void addCollisions(Orientation orientation, BlockPos pos, AxisAlignedBB region, List<AxisAlignedBB> result) {
                AxisAlignedBB aabb = HALF_PANEL_AABB.func_186670_a(pos);
                Shape.addBox(aabb, region, result);
            }

            @Override
            public AxisAlignedBB getBlockBounds(Orientation orientation) {
                return HALF_PANEL_AABB;
            }
        }
        ,
        STAIRS{

            @Override
            public void addCollisions(Orientation orientation, BlockPos pos, AxisAlignedBB region, List<AxisAlignedBB> result) {
                AxisAlignedBB lowerStep = BlockSpaceTransform.instance.mapBlockToWorld(orientation, LOWER_STEP_PANEL_AABB).func_186670_a(pos);
                Shape.addBox(lowerStep, region, result);
                AxisAlignedBB upperStep = BlockSpaceTransform.instance.mapBlockToWorld(orientation, UPPER_STEP_PANEL_AABB).func_186670_a(pos);
                Shape.addBox(upperStep, region, result);
            }

            @Override
            public AxisAlignedBB getBlockBounds(Orientation orientation) {
                return BlockSpaceTransform.instance.mapBlockToWorld(orientation, STAIRS_AABB);
            }
        };

        public static final Shape[] VALUES;
        private final String name = this.name().toLowerCase(Locale.ROOT);

        public abstract void addCollisions(Orientation var1, BlockPos var2, AxisAlignedBB var3, List<AxisAlignedBB> var4);

        public abstract AxisAlignedBB getBlockBounds(Orientation var1);

        public String func_176610_l() {
            return this.name;
        }

        private static void addBox(AxisAlignedBB aabb, AxisAlignedBB region, List<AxisAlignedBB> result) {
            if (aabb.func_72326_a(region)) {
                result.add(aabb);
            }
        }

        static {
            VALUES = Shape.values();
        }
    }

    public static enum Type implements IStringSerializable
    {
        PENCIL,
        CRAYON;

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String func_176610_l() {
            return this.name;
        }
    }
}

