/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openmods.block.OpenBlock;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.Orientation;
import openmods.infobook.BookDocumentation;
import openmods.utils.BlockManipulator;

@BookDocumentation
public class BlockRopeLadder
extends OpenBlock.FourDirections {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);

    public BlockRopeLadder() {
        super(Material.field_151594_q);
        this.func_149711_c(0.4f);
        this.func_149672_a(SoundType.field_185857_j);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public int func_149745_a(Random random) {
        return Config.infiniteLadder ? 0 : 1;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean something) {
        if (entity instanceof EntityLivingBase) {
            EnumFacing playerRotation = ((EntityLivingBase)entity).func_174811_aO();
            if (this.getFront(state) == playerRotation.func_176734_d()) {
                super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, something);
            }
        } else {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, something);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        Orientation orientation = this.getOrientation(source, pos);
        return BlockSpaceTransform.instance.mapBlockToWorld(orientation, AABB);
    }

    public boolean canRotateWithTool() {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbour, BlockPos neigbourPos) {
        EnumFacing dir = this.getBack(state);
        if (world.func_175623_d(pos.func_177972_a(dir)) && world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
            world.func_175655_b(pos, true);
        }
    }

    public boolean canBlockBePlaced(World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ, int itemMetadata, EntityPlayer player) {
        if (side == EnumFacing.DOWN) {
            IBlockState maybeLadder = world.func_180495_p(pos.func_177984_a());
            return maybeLadder.func_177230_c() == this;
        }
        for (Orientation o : this.getRotationMode().getValidDirections()) {
            EnumFacing placeDir = this.getRotationMode().getFront(o).func_176734_d();
            if (world.func_175623_d(pos.func_177972_a(placeDir))) continue;
            return true;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Block bottomBlock;
        if ((pos = pos.func_177977_b()).func_177956_o() > 0 && (bottomBlock = world.func_180495_p(pos).func_177230_c()) == this) {
            world.func_175655_b(pos, true);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        Orientation orientation = this.calculateOrientationAfterPlace(pos, facing, placer);
        if (orientation == null) {
            orientation = this.findValidBlock(world, pos);
        }
        if (orientation == null) {
            orientation = this.tryCloneState(world, pos, facing);
        }
        if (orientation == null) {
            return this.func_176223_P();
        }
        return this.func_176203_a(meta).func_177226_a(this.propertyOrientation, (Comparable)orientation);
    }

    private Orientation tryCloneState(World world, BlockPos pos, EnumFacing facing) {
        IBlockState maybeLadder;
        if (facing == EnumFacing.DOWN && (maybeLadder = world.func_180495_p(pos.func_177984_a())).func_177230_c() == this) {
            return (Orientation)maybeLadder.func_177229_b(this.getPropertyOrientation());
        }
        return null;
    }

    private Orientation findValidBlock(World world, BlockPos pos) {
        for (Orientation o : this.getRotationMode().getValidDirections()) {
            EnumFacing placeDir = this.getRotationMode().getFront(o).func_176734_d();
            if (world.func_175623_d(pos.func_177972_a(placeDir))) continue;
            return o;
        }
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            Orientation orientation = this.getOrientation(state);
            BlockPos placePos = pos.func_177977_b();
            while (placePos.func_177956_o() > 0 && (Config.infiniteLadder || stack.func_190916_E() > 1)) {
                BlockManipulator manipulator = new BlockManipulator(world, player, placePos);
                if (world.func_175623_d(placePos) && manipulator.place(state, orientation.north(), EnumHand.MAIN_HAND)) {
                    if (!Config.infiniteLadder) {
                        stack.func_190918_g(1);
                    }
                } else {
                    return;
                }
                placePos = placePos.func_177977_b();
            }
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == this.getOrientation(state).south() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

