/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.math;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public class Vector3d {
    public double X;
    public double Y;
    public double Z;

    public Vector3d(double x, double y, double z) {
        this.set(x, y, z);
    }

    public Vector3d(@Nonnull Vector3d other) {
        this.set(other);
    }

    public Vector3d(@Nonnull Vec3i other) {
        this.set(other);
    }

    @Nonnull
    public static Vector3d from(@Nonnull Vec3i data) {
        return new Vector3d(data.func_177958_n(), data.func_177956_o(), data.func_177952_p());
    }

    @Nonnull
    public static Vector3d fromCenter(@Nonnull Vec3i data) {
        return Vector3d.from(data).add(0.5);
    }

    @Nonnull
    public static Vector3d from(@Nonnull Entity data) {
        return new Vector3d(data.field_70165_t, data.field_70163_u, data.field_70161_v);
    }

    @Nonnull
    public static Vector3d fromCenter(@Nonnull Entity data) {
        return Vector3d.from(data).add(0.5);
    }

    @Nonnull
    public static Vector3d from(@Nonnull TileEntity data) {
        return new Vector3d((Vec3i)data.func_174877_v());
    }

    @Nonnull
    public static Vector3d fromCenter(@Nonnull TileEntity data) {
        return Vector3d.from(data).add(0.5);
    }

    @Nonnull
    public static Vector3d from(@Nonnull NBTTagCompound data) {
        return new Vector3d().loadFrom(data);
    }

    @Nonnull
    public Vec3i toVec3i() {
        return new Vec3i(this.X, this.Y, this.Z);
    }

    @Nonnull
    public BlockPos toBlockPos() {
        return new BlockPos(this.X, this.Y, this.Z);
    }

    @Nonnull
    public Vector3d loadFrom(@Nonnull NBTTagCompound data) {
        this.X = data.func_74769_h("vx");
        this.Y = data.func_74769_h("vy");
        this.Z = data.func_74769_h("vz");
        return this;
    }

    @Nonnull
    public NBTTagCompound saveTo(@Nonnull NBTTagCompound data) {
        data.func_74780_a("vx", this.X);
        data.func_74780_a("vy", this.Y);
        data.func_74780_a("vz", this.Z);
        return data;
    }

    @Nonnull
    public Vector3d set(double x, double y, double z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
        return this;
    }

    @Nonnull
    public Vector3d set(@Nonnull Vector3d data) {
        return this.set(data.X, data.Y, data.Z);
    }

    @Nonnull
    public Vector3d set(@Nonnull Vec3i data) {
        return this.set(data.func_177958_n(), data.func_177956_o(), data.func_177952_p());
    }

    @Nonnull
    public Vector3d add(double offsetX, double offsetY, double offsetZ) {
        this.X += offsetX;
        this.Y += offsetY;
        this.Z += offsetZ;
        return this;
    }

    @Nonnull
    public Vector3d add(double offset) {
        return this.add(offset, offset, offset);
    }

    @Nonnull
    public Vector3d add(@Nonnull Vector3d offset) {
        return this.add(offset.X, offset.Y, offset.X);
    }

    @Nonnull
    public Vector3d add(@Nonnull Vec3i offset) {
        return this.add(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
    }

    @Nonnull
    public Vector3d subtract(double offsetX, double offsetY, double offsetZ) {
        this.X -= offsetX;
        this.Y -= offsetY;
        this.Z -= offsetZ;
        return this;
    }

    @Nonnull
    public Vector3d subtract(double offset) {
        return this.subtract(offset, offset, offset);
    }

    @Nonnull
    public Vector3d subtract(@Nonnull Vec3i offset) {
        return this.subtract(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
    }

    @Nonnull
    public Vector3d multiply(double factorX, double factorY, double factorZ) {
        this.X *= factorX;
        this.Y *= factorY;
        this.Z *= factorZ;
        return this;
    }

    @Nonnull
    public Vector3d multiply(double factor) {
        return this.multiply(factor, factor, factor);
    }

    @Nonnull
    public Vector3d multiply(@Nonnull Vec3i factor) {
        return this.multiply(factor.func_177958_n(), factor.func_177956_o(), factor.func_177952_p());
    }

    @Nonnull
    public Vector3d divide(double factorX, double factorY, double factorZ) {
        this.X /= factorX;
        this.Y /= factorY;
        this.Z /= factorZ;
        return this;
    }

    @Nonnull
    public Vector3d divide(double factor) {
        return this.divide(factor, factor, factor);
    }

    @Nonnull
    public Vector3d divide(@Nonnull Vec3i factor) {
        return this.divide(factor.func_177958_n(), factor.func_177956_o(), factor.func_177952_p());
    }

    @Nonnull
    public Vector3d ceil() {
        this.X = MathHelper.func_76143_f((double)this.X);
        this.Y = MathHelper.func_76143_f((double)this.Y);
        this.Z = MathHelper.func_76143_f((double)this.Z);
        return this;
    }

    @Nonnull
    public Vector3d floor() {
        this.X = MathHelper.func_76128_c((double)this.X);
        this.Y = MathHelper.func_76128_c((double)this.Y);
        this.Z = MathHelper.func_76128_c((double)this.Z);
        return this;
    }

    public double magnitude() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z);
    }

    @Nonnull
    public Vector3d normalize() {
        double magnitude = this.magnitude();
        if (0.0 != magnitude) {
            this.multiply(1.0 / magnitude);
        }
        return this;
    }

    public double scalarProduct(double x, double y, double z) {
        return this.X * x + this.Y * y + this.Z * z;
    }

    public double scalarProduct(@Nonnull Vector3d vector) {
        double product = this.X * vector.X + this.Y * vector.Y + this.Z * vector.Z;
        if (product > 1.0 && product < 1.00001) {
            product = 1.0;
        } else if (product < -1.0 && product > -1.00001) {
            product = -1.0;
        }
        return product;
    }

    public boolean equals(Object other) {
        if (other instanceof Vector3d) {
            Vector3d v = (Vector3d)other;
            return this.X == v.X && this.Y == v.Y && this.Z == v.Z;
        }
        return false;
    }

    public String toString() {
        return String.format("Vector3d (%f, %f, %f)", this.X, this.Y, this.Z);
    }

    private Vector3d() {
    }
}

