/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn;

import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.items.ItemLance;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class LanceAttackMessage
implements IMessage {
    private String text = "lance";
    private int targetId = -1;
    private int attackerId = -1;
    private int lanceType = -1;

    public LanceAttackMessage() {
    }

    public LanceAttackMessage(int attackerId, int targetId, int lanceType) {
        this.attackerId = attackerId;
        this.targetId = targetId;
        this.lanceType = lanceType;
    }

    public void fromBytes(ByteBuf buf) {
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.attackerId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.targetId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.lanceType = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.attackerId, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.targetId, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.lanceType, (int)5);
    }

    public static class Handler
    implements IMessageHandler<LanceAttackMessage, IMessage> {
        public IMessage onMessage(LanceAttackMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Entity attacker = player.field_70170_p.func_73045_a(message.attackerId);
            Entity target = player.field_70170_p.func_73045_a(message.targetId);
            Entity thisRidingEntity = attacker.func_184187_bx();
            ItemLance l = (ItemLance)CommonProxy.lanceTypes[message.lanceType];
            if (attacker instanceof EntityPlayer) {
                l.attackTargetEntityWithLance((EntityPlayer)attacker, target);
                l.attemptUnhorse(null, (EntityLivingBase)attacker, (EntityLivingBase)target, (EntityLivingBase)thisRidingEntity, player.field_70170_p);
            } else if (attacker instanceof EntityLivingBase) {
                l.mobAttackTargetEntityWithLance((EntityLivingBase)attacker, (EntityLivingBase)target);
                l.attemptUnhorse(null, (EntityLivingBase)attacker, (EntityLivingBase)target, (EntityLivingBase)thisRidingEntity, player.field_70170_p);
            }
            return null;
        }
    }
}

