/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.projectile.EntityIceBall;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class IcyWingBuffet
extends AbstractPower {
    public static final float ext = 0.96f;
    public static final float ext2 = 0.35999998f;

    public IcyWingBuffet(boolean b) {
        super(b);
        this.name = I18n.func_74838_a((String)"power.icyWingBuffet");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.ICY_WING_BUFFET;
    }

    @Override
    public void doBuffetPower(EntityMagicalHorse horse, int buffetCooldownCounter, float forward, float sides, float up) {
        if (this.supercharged) {
            forward = (float)((double)forward * 1.2);
            sides = (float)((double)sides * 1.1);
        }
        int maxDir = (int)((double)forward * 3.5);
        int maxWidth = (int)sides;
        float v2 = -MathHelper.func_76126_a((float)(horse.field_70177_z * (float)Math.PI / 180.0f));
        float v3 = MathHelper.func_76134_b((float)(horse.field_70177_z * (float)Math.PI / 180.0f));
        Vec3d v = new Vec3d((double)v2, 0.0, (double)v3).func_72432_b();
        Vec3d vLeft = v.func_178785_b(0.5235988f);
        Vec3d vRight = v.func_178785_b(-0.5235988f);
        Vec3d vPerp = v.func_178785_b(-1.5707964f);
        Vec3d vPerpSide = new Vec3d(vPerp.field_72450_a * (double)maxWidth, vPerp.field_72448_b * (double)maxWidth, vPerp.field_72449_c * (double)maxWidth);
        Vec3d startPos = horse.func_174791_d().func_178787_e(vPerpSide);
        Vec3d startPos2 = horse.func_174791_d().func_178787_e(vPerpSide);
        Vec3d endPos = horse.func_174791_d().func_178788_d(vPerpSide);
        int counter = 0;
        if (!horse.field_70170_p.field_72995_K) {
            Material m;
            IBlockState bState;
            BlockPos bPos;
            int k;
            int i;
            Vec3d current;
            while (startPos.func_178788_d(endPos).func_72433_c() > 0.2 && counter < 100) {
                ++counter;
                current = new Vec3d(startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c);
                for (i = 0; i < maxDir; ++i) {
                    for (k = -1; k < 2; ++k) {
                        bPos = new BlockPos(current.func_178787_e(new Vec3d(0.0, (double)k, 0.0)));
                        bState = horse.field_70170_p.func_180495_p(bPos);
                        m = bState.func_185904_a();
                        if (m == Material.field_151586_h) {
                            horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150432_aD.func_176223_P());
                            continue;
                        }
                        if (m == Material.field_151587_i) {
                            horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150348_b.func_176223_P());
                            continue;
                        }
                        if (m != Material.field_151581_o) continue;
                        horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150350_a.func_176223_P());
                    }
                    current = current.func_178787_e(vLeft);
                }
                startPos = startPos.func_178788_d(vPerp);
            }
            counter = 0;
            while (startPos2.func_178788_d(endPos).func_72433_c() > 1.0 && counter < 100) {
                ++counter;
                current = new Vec3d(endPos.field_72450_a, endPos.field_72448_b, endPos.field_72449_c);
                for (i = 0; i < maxDir; ++i) {
                    for (k = -1; k < 4; ++k) {
                        bPos = new BlockPos(current.func_178787_e(new Vec3d(0.0, (double)k, 0.0)));
                        bState = horse.field_70170_p.func_180495_p(bPos);
                        m = bState.func_185904_a();
                        if (m == Material.field_151586_h) {
                            horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150432_aD.func_176223_P());
                            continue;
                        }
                        if (m == Material.field_151587_i) {
                            horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150348_b.func_176223_P());
                            continue;
                        }
                        if (m != Material.field_151581_o) continue;
                        horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150350_a.func_176223_P());
                    }
                    current = current.func_178787_e(vRight);
                }
                endPos = endPos.func_178787_e(vPerp);
            }
        }
        if (this.supercharged) {
            this.shootSnowballs(horse, buffetCooldownCounter);
        }
    }

    public void shootSnowballs(EntityMagicalHorse horse, int buffetCooldownCounter) {
        if (buffetCooldownCounter % 9 == 6 && this.isNearIce(horse.field_70170_p, horse.func_180425_c())) {
            Vec3d lookVec = null != horse.func_184179_bs() ? horse.func_184179_bs().func_70040_Z() : horse.func_70040_Z();
            float f2 = MathHelper.func_76126_a((float)(1.5707964f + horse.field_70177_z * (float)Math.PI / 180.0f));
            float f3 = MathHelper.func_76134_b((float)(1.5707964f + horse.field_70177_z * (float)Math.PI / 180.0f));
            double x = 0.96f * f2;
            double z = -0.96f * f3;
            if (horse.hasDestrierBody()) {
                x *= (double)1.6f;
                z *= (double)1.6f;
            }
            double x2 = 0.35999998f * f2;
            double z2 = -0.35999998f * f3;
            for (int i = 0; i < 3; ++i) {
                EntityIceBall sfb = new EntityIceBall(horse.field_70170_p, (EntityLivingBase)horse);
                sfb.func_70107_b(horse.field_70165_t + lookVec.field_72450_a * (double)1.8f + x * (double)i, horse.field_70163_u + (double)horse.func_70047_e() + lookVec.field_72448_b * (double)1.8f, horse.field_70161_v + lookVec.field_72449_c * (double)1.8f + z * (double)i);
                sfb.field_70159_w = lookVec.field_72450_a * 2.5 + horse.field_70159_w + x2 * (double)i;
                sfb.field_70181_x = lookVec.field_72448_b * 2.5 + horse.field_70181_x;
                sfb.field_70179_y = lookVec.field_72449_c * 2.5 + horse.field_70179_y + z2 * (double)i;
                if (horse.field_70170_p.field_72995_K) {
                    sfb.func_70016_h(lookVec.field_72450_a * 2.5 + horse.field_70159_w + x2 * (double)i, lookVec.field_72448_b * 2.5 + horse.field_70181_x, lookVec.field_72449_c * 2.5 + horse.field_70179_y + z2 * (double)i);
                }
                horse.field_70170_p.func_72838_d((Entity)sfb);
                EntityIceBall sfb2 = new EntityIceBall(horse.field_70170_p, (EntityLivingBase)horse);
                sfb2.func_70107_b(horse.field_70165_t + lookVec.field_72450_a * (double)1.8f - x * (double)i, horse.field_70163_u + (double)horse.func_70047_e() + lookVec.field_72448_b * (double)1.8f, horse.field_70161_v + lookVec.field_72449_c * (double)1.8f - z * (double)i);
                sfb2.field_70159_w = lookVec.field_72450_a * 2.5 + horse.field_70159_w - x2 * (double)i;
                sfb2.field_70181_x = lookVec.field_72448_b * 2.5 + horse.field_70181_x;
                sfb2.field_70179_y = lookVec.field_72449_c * 2.5 + horse.field_70179_y - z2 * (double)i;
                if (horse.field_70170_p.field_72995_K) {
                    sfb2.func_70016_h(lookVec.field_72450_a * 2.5 + horse.field_70159_w - x2 * (double)i, lookVec.field_72448_b * 2.5 + horse.field_70181_x, lookVec.field_72449_c * 2.5 + horse.field_70179_y - z2 * (double)i);
                }
                horse.field_70170_p.func_72838_d((Entity)sfb2);
            }
        }
    }

    @Override
    public float getBuffetStrengthMultiplier() {
        if (this.supercharged) {
            return 1.18f;
        }
        return 1.09f;
    }

    @Override
    public float getBuffetForwardSizeMultiplier() {
        if (this.supercharged) {
            return 1.2f;
        }
        return 1.1f;
    }

    @Override
    public float getBuffetSideSizeMultiplier() {
        if (this.supercharged) {
            return 1.2f;
        }
        return 1.1f;
    }

    @Override
    public float getBuffetUpSizeMultiplier() {
        if (this.supercharged) {
            return 1.2f;
        }
        return 1.1f;
    }

    protected boolean isNearIce(World world, BlockPos position) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int k = -1; k < 4; ++k) {
                    BlockPos bPos = position.func_177982_a(i, k, j);
                    Block block = world.func_180495_p(bPos).func_177230_c();
                    Material m = world.func_180495_p(bPos).func_185904_a();
                    if (block != Block.func_149729_e((int)78) && Material.field_151588_w != m && Material.field_151598_x != m && Material.field_151597_y != m) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

