/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.items.ItemHorseshoes;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;

public class PowerStomp
extends AbstractPower {
    public PowerStomp(boolean b) {
        super(b);
        this.name = I18n.func_74838_a((String)"power.powerStomp");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.POWER_STOMP;
    }

    @Override
    public void doBuffetPower(EntityMagicalHorse horse, int buffetCooldownCounter, float forward, float sides, float up) {
    }

    @Override
    public void doLandingPower(EntityMagicalHorse horse) {
        double xExp = 4.0;
        double up = 0.0;
        double zExp = 4.0;
        float f = (float)horse.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int powerLevel = 0;
        if (this.supercharged) {
            ++powerLevel;
        }
        if (horse.hasDestrierBody()) {
            ++powerLevel;
        }
        boolean poweredHooves = false;
        boolean gentledHooves = false;
        ItemStack horseshoesStack = horse.field_110296_bG.func_70301_a(2);
        if (!horseshoesStack.func_190926_b()) {
            ItemHorseshoes horseshoesItem = (ItemHorseshoes)horseshoesStack.func_77973_b();
            if (horseshoesItem.hasPower()) {
                poweredHooves = true;
            }
            if (horseshoesItem.isGentling()) {
                gentledHooves = true;
            }
        }
        if (poweredHooves) {
            ++powerLevel;
        } else if (gentledHooves) {
            --powerLevel;
        }
        if (powerLevel > 0) {
            f *= 1.5f + (float)powerLevel / 2.0f;
            xExp *= 1.4;
            xExp += (double)powerLevel;
            zExp *= 1.4;
            zExp += (double)powerLevel;
            up = 1.0 + (double)(powerLevel / 2);
            int down = -1 - powerLevel / 3;
            Set<Material> destroySet = EntityMagicalHorse.destrierKicksMaterials;
            if (powerLevel > 1) {
                destroySet = EntityMagicalHorse.destrierPowerKicksMaterials;
            }
            float hardness = 0.0f;
            for (int i = -2; i < 3; ++i) {
                for (int j = -2; j < 3; ++j) {
                    int k = down;
                    while ((double)k < up - 1.0) {
                        BlockPos bPos = horse.func_180425_c().func_177982_a(i, k, j);
                        IBlockState bState = horse.field_70170_p.func_180495_p(bPos);
                        Material m = bState.func_185904_a();
                        hardness = bState.func_185887_b(horse.func_130014_f_(), bPos);
                        if (destroySet.contains(m) && hardness > -1.0f && hardness < 3.1f) {
                            horse.field_70170_p.func_175655_b(bPos, poweredHooves);
                        }
                        ++k;
                    }
                }
            }
        }
        for (Object e : horse.field_70170_p.func_72872_a(Entity.class, horse.func_174813_aQ().func_72314_b(xExp, up, zExp))) {
            Entity targetEntity = (Entity)e;
            if (e == horse || e == horse.func_184179_bs()) continue;
            int i = 1;
            boolean flag = false;
            flag = targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)horse), f);
            if ((i += EnchantmentHelper.func_77501_a((EntityLivingBase)horse)) <= 0) continue;
            Vec3d diffVec = targetEntity.func_174791_d().func_178788_d(horse.func_174791_d()).func_72432_b();
            targetEntity.func_70024_g(diffVec.field_72450_a * xExp / 4.0, (double)i * 0.2, diffVec.field_72449_c * zExp / 4.0);
        }
    }
}

