/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class RainbowBeam
extends AbstractPower {
    public final int[] goodEffects = new int[]{1, 3, 5, 6, 8, 10, 11, 12, 13, 16};

    public RainbowBeam(boolean b) {
        super(b);
        this.name = I18n.func_74838_a((String)"power.rainbowBeam");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.RAINBOW_BEAM;
    }

    @Override
    public boolean doHornPower(EntityMagicalHorse shooter) {
        World worldIn = shooter.field_70170_p;
        if (!worldIn.field_72995_K) {
            Vec3d lookVec = shooter.getLevelLook(1.0f);
            Sorter theNearestTargetSorter = new Sorter((Entity)shooter);
            List list = worldIn.func_72839_b((Entity)shooter, shooter.func_174813_aQ().func_72321_a(lookVec.field_72450_a * 60.0, lookVec.field_72448_b, lookVec.field_72449_c * 60.0));
            Collections.sort(list, theNearestTargetSorter);
            for (Object obj : list) {
                if (obj == shooter.func_184179_bs()) continue;
                if (obj instanceof Entity) {
                    Entity e = (Entity)obj;
                    Vec3d objPosVec = new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
                    Vec3d shooterPosVec = new Vec3d(shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v);
                    Vec3d objVec = objPosVec.func_178788_d(shooterPosVec);
                    double crossLen = lookVec.func_72431_c(objVec.func_72432_b()).func_72433_c();
                    double dist = objVec.func_72433_c();
                    if (dist > 7.0 && crossLen > 0.07 || crossLen > 0.15) continue;
                }
                if (!(obj instanceof EntityLiving)) continue;
                if (shooter.field_70170_p.field_73012_v.nextInt(3) != 0) {
                    return false;
                }
                EntityLiving el = (EntityLiving)obj;
                if (el instanceof IMob) {
                    boolean flag = el.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)shooter), 3.5f);
                    if (!flag) break;
                    el.func_70024_g(lookVec.field_72450_a, 0.3, lookVec.field_72449_c);
                    break;
                }
                int effect = this.goodEffects[worldIn.field_73012_v.nextInt(this.goodEffects.length)];
                el.func_70690_d(new PotionEffect(Potion.func_188412_a((int)effect), 100, 1, true, true));
                break;
            }
        }
        return false;
    }

    public static class Sorter
    implements Comparator {
        private final Entity theEntity;
        private static final String __OBFID = "CL_00001622";

        public Sorter(Entity e) {
            this.theEntity = e;
        }

        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }

        public int compare(Object p_compare_1_, Object p_compare_2_) {
            return this.compare((Entity)p_compare_1_, (Entity)p_compare_2_);
        }
    }
}

