/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.items;

import com.google.common.collect.Multimap;
import com.hackshop.ultimate_unicorn.CombinedClientProxy;
import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.LanceAttackMessage;
import com.hackshop.ultimate_unicorn.gui.ChatFormatting;
import com.hackshop.ultimate_unicorn.items.ItemHelper;
import java.util.GregorianCalendar;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemLance
extends Item {
    private float attackDamage;
    private final Item.ToolMaterial material;
    private static final String __OBFID = "CL_00000072";
    private static final float REACH = 1.8f;
    private static final float OFFSET_DOWN = 0.4f;
    private LanceType type = LanceType.Normal;

    public ItemLance setType(LanceType type) {
        this.type = type;
        return this;
    }

    public ItemLance(Item.ToolMaterial material) {
        this.material = material;
        this.field_77777_bU = 1;
        this.func_77656_e((int)(Math.pow(material.func_77997_a(), 0.6) * 3.2));
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.attackDamage = 2.1f + material.func_78000_c() / 1.8f;
    }

    public float getDamageVsEntity() {
        return this.material.func_78000_c();
    }

    public static Item getRandomLanceFromLanceType(LanceType t, World worldObj) {
        int r = worldObj.field_73012_v.nextInt(4);
        switch (t) {
            case Normal: {
                return CommonProxy.lances[r];
            }
            case Knight: {
                return CommonProxy.knightLances[r];
            }
            case Priestess: {
                return CommonProxy.priestessLances[r];
            }
            case King: {
                return CommonProxy.kingLances[r];
            }
            case Queen: {
                return CommonProxy.queenLances[r];
            }
            case Fool: {
                return CommonProxy.foolLances[r];
            }
        }
        return CommonProxy.knightLanceIron;
    }

    public float getStrVsBlock(ItemStack stack, Block block) {
        if (block == Blocks.field_150321_G) {
            return 9.0f;
        }
        Material material = block.func_149688_o(block.func_176194_O().func_177621_b());
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.2f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (mat != null && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
        return multimap;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        block11: {
            if (worldIn.func_72820_D() % 4L != 0L || !worldIn.field_72995_K) break block11;
            boolean inOffHand = false;
            if (entityIn instanceof EntityLivingBase) {
                ItemStack offItem = ((EntityLivingBase)entityIn).func_184586_b(EnumHand.OFF_HAND);
                boolean bl = inOffHand = offItem == stack;
            }
            if (isSelected || inOffHand) {
                float angleOffset;
                double motionZ;
                double motionX;
                EntityLivingBase thisRidingEntity = null;
                if (null != entityIn.func_184187_bx() && entityIn.func_184187_bx() instanceof EntityLivingBase) {
                    thisRidingEntity = (EntityLivingBase)entityIn.func_184187_bx();
                }
                if (null != entityIn.func_184187_bx()) {
                    motionX = entityIn.func_184187_bx().field_70159_w;
                    motionZ = entityIn.func_184187_bx().field_70179_y;
                } else {
                    motionX = entityIn.field_70159_w;
                    motionZ = entityIn.field_70179_y;
                }
                float f = angleOffset = inOffHand ? -27.0f : 27.0f;
                if ((Math.abs(motionX) > (double)0.1f || Math.abs(motionZ) > (double)0.1f) && Math.signum(motionX) == Math.signum(entityIn.func_70040_Z().field_72450_a) && Math.signum(motionZ) == Math.signum(entityIn.func_70040_Z().field_72449_c)) {
                    float adjustedRotationYaw = MathHelper.func_76142_g((float)(entityIn.field_70177_z + angleOffset));
                    if (entityIn instanceof EntityPlayer) {
                        for (Object e : worldIn.func_72872_a(EntityLivingBase.class, entityIn.func_174813_aQ().func_72314_b(0.79, 0.1, 0.79).func_72317_d((double)(-MathHelper.func_76126_a((float)(adjustedRotationYaw * (float)Math.PI / 180.0f)) * 1.8f), (double)(-MathHelper.func_76126_a((float)(entityIn.field_70125_A * (float)Math.PI / 180.0f)) * 1.8f - 0.4f), (double)(MathHelper.func_76134_b((float)(adjustedRotationYaw * (float)Math.PI / 180.0f)) * 1.8f)))) {
                            EntityLivingBase targetEntity = (EntityLivingBase)e;
                            if (targetEntity == entityIn || targetEntity == entityIn.func_184187_bx() || targetEntity instanceof AbstractHorse) continue;
                            CombinedClientProxy.network.sendToServer((IMessage)new LanceAttackMessage(entityIn.func_145782_y(), targetEntity.func_145782_y(), this.type.index));
                            this.attackTargetEntityWithLance((EntityPlayer)entityIn, (Entity)targetEntity);
                            this.attemptUnhorse(stack, (EntityLivingBase)entityIn, targetEntity, thisRidingEntity, worldIn);
                        }
                    } else if (entityIn instanceof EntityLivingBase) {
                        for (Object e : worldIn.func_72872_a(EntityLivingBase.class, entityIn.func_174813_aQ().func_72314_b(0.79, 0.1, 0.79).func_72317_d((double)(-MathHelper.func_76126_a((float)(adjustedRotationYaw * (float)Math.PI / 180.0f)) * 1.8f), (double)(MathHelper.func_76126_a((float)(entityIn.field_70125_A * (float)Math.PI / 180.0f)) * 1.8f - 0.4f), (double)(MathHelper.func_76134_b((float)(adjustedRotationYaw * (float)Math.PI / 180.0f)) * 1.8f)))) {
                            EntityLivingBase targetEntity = (EntityLivingBase)e;
                            if (targetEntity == entityIn || targetEntity == entityIn.func_184187_bx() || targetEntity instanceof AbstractHorse) continue;
                            CombinedClientProxy.network.sendToServer((IMessage)new LanceAttackMessage(entityIn.func_145782_y(), targetEntity.func_145782_y(), this.type.index));
                            this.mobAttackTargetEntityWithLance(targetEntity, (EntityLivingBase)entityIn);
                            this.attemptUnhorse(stack, (EntityLivingBase)entityIn, targetEntity, thisRidingEntity, worldIn);
                        }
                    }
                }
            }
        }
    }

    public void mobAttackTargetEntityWithLance(EntityLivingBase targetEntity, EntityLivingBase attackerRidingEntity) {
        targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)attackerRidingEntity), this.attackDamage);
    }

    public void attemptUnhorse(ItemStack stack, EntityLivingBase attacker, EntityLivingBase targetEntity, EntityLivingBase attackerRidingEntity, World worldIn) {
        ItemStack armorStack = targetEntity.func_184582_a(EntityEquipmentSlot.CHEST);
        double damageFromArmor = this.damageVersusArmor(armorStack);
        if (null != stack) {
            stack.func_77972_a((int)damageFromArmor, attacker);
        }
        if (null != targetEntity.func_184187_bx() && targetEntity.func_184187_bx() instanceof EntityLivingBase) {
            double unhorseChance = this.unhorseChanceVersus(targetEntity.func_184586_b(EnumHand.MAIN_HAND));
            double knockbackPenalty = targetEntity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e() / 5.0;
            double armorPenalty = 0.0;
            if (null != armorStack && null != armorStack.func_77973_b() && armorStack.func_77973_b() instanceof ItemArmor) {
                armorPenalty = ((double)((ItemArmor)armorStack.func_77973_b()).func_82812_d().ordinal() + 1.0) / 10.0;
            }
            double horseBonus = 0.0;
            if (null != attackerRidingEntity) {
                double horseSpeed = attackerRidingEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / 100.0;
                double horsePower = 0.0;
                if (null != attackerRidingEntity.func_110148_a(SharedMonsterAttributes.field_111264_e)) {
                    horsePower = attackerRidingEntity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / 100.0;
                }
                horseBonus = horseSpeed + horsePower;
            }
            Vec3d targetLookVec = targetEntity.func_70040_Z();
            targetLookVec = new Vec3d(targetLookVec.field_72450_a, 0.0, targetLookVec.field_72449_c).func_72432_b();
            Vec3d thisLookVec = attacker.func_70040_Z();
            thisLookVec = new Vec3d(thisLookVec.field_72450_a, 0.0, thisLookVec.field_72449_c).func_72432_b();
            double angleBonus = (1.0 + thisLookVec.func_72430_b(targetLookVec)) * 0.4;
            unhorseChance = unhorseChance + horseBonus + angleBonus - armorPenalty - knockbackPenalty;
            if (worldIn.field_73012_v.nextDouble() < unhorseChance) {
                targetEntity.func_184210_p();
                this.sendMessage((Entity)attacker, targetEntity);
            }
        }
    }

    private void sendMessage(Entity entityIn, EntityLivingBase targetEntity) {
        if (!entityIn.field_70170_p.field_72995_K) {
            String message = (Object)((Object)ChatFormatting.RED) + targetEntity.func_70005_c_() + (Object)((Object)ChatFormatting.RESET) + " was unhorsed by " + (Object)((Object)ChatFormatting.GOLD) + entityIn.func_70005_c_() + (Object)((Object)ChatFormatting.RESET) + " with a " + (Object)((Object)ChatFormatting.DARK_AQUA) + this.type.getName() + "!";
            entityIn.field_70170_p.func_73046_m().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(message));
        }
    }

    public void attackTargetEntityWithLance(EntityPlayer player, Entity targetEntity) {
        if (!ForgeHooks.onPlayerAttackTarget((EntityPlayer)player, (Entity)targetEntity)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)player)) {
            float f = 2.4f * (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int b0 = 0;
            float f1 = 0.0f;
            f1 = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            int j = b0 + EnchantmentHelper.func_77501_a((EntityLivingBase)player);
            if (player.func_70051_ag()) {
                ++j;
            }
            if (f > 0.0f || f1 > 0.0f) {
                boolean flag;
                boolean bl = flag = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.func_188412_a((int)15)) && player.func_184187_bx() == null && targetEntity instanceof EntityLivingBase;
                if (flag && f > 0.0f) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag1 = false;
                int i = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (targetEntity instanceof EntityLivingBase && i > 0 && !targetEntity.func_70027_ad()) {
                    flag1 = true;
                    targetEntity.func_70015_d(1);
                }
                double d0 = targetEntity.field_70159_w;
                double d1 = targetEntity.field_70181_x;
                double d2 = targetEntity.field_70179_y;
                boolean flag2 = targetEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), f);
                if (flag2) {
                    EntityDragon ientitymultipart;
                    if (j > 0) {
                        targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)j * 0.8f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)j * 0.8f));
                        player.field_70159_w *= 0.8;
                        player.field_70179_y *= 0.8;
                        player.func_70031_b(false);
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = d0;
                        targetEntity.field_70181_x = d1;
                        targetEntity.field_70179_y = d2;
                    }
                    if (flag) {
                        player.func_71009_b(targetEntity);
                    }
                    if (f1 > 0.0f) {
                        player.func_71047_c(targetEntity);
                    }
                    player.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.func_151384_a((EntityLivingBase)player, (Entity)targetEntity);
                    ItemStack itemstack = player.func_184586_b(EnumHand.MAIN_HAND);
                    Entity object = targetEntity;
                    if (targetEntity instanceof EntityDragon && (ientitymultipart = (EntityDragon)targetEntity) instanceof EntityLivingBase) {
                        object = (EntityLivingBase)ientitymultipart;
                    }
                    if (itemstack != null && object instanceof EntityLivingBase) {
                        itemstack.func_77961_a((EntityLivingBase)object, player);
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        player.func_71064_a(StatList.field_188111_y, Math.round(f * 10.0f));
                        if (i > 0) {
                            targetEntity.func_70015_d(i * 4);
                        }
                    }
                    player.func_71020_j(0.3f);
                } else if (flag1) {
                    targetEntity.func_70066_B();
                }
            }
        }
    }

    public double unhorseChanceVersus(ItemStack stack) {
        if (null == stack || stack.func_77973_b() == null || !ItemHelper.isLance(stack.func_77973_b())) {
            return this.type.unhorsesChanceVersus(null);
        }
        return this.type.unhorsesChanceVersus(((ItemLance)stack.func_77973_b()).type);
    }

    public double damageVersusArmor(ItemStack stack) {
        if (null == stack || null == stack.func_77973_b() || !(stack.func_77973_b() instanceof ItemArmor)) {
            return this.type.damageVersusArmor(null);
        }
        return this.type.damageVersusArmor((ItemArmor)stack.func_77973_b());
    }

    public static enum LanceType {
        Normal("scrub lance", 0, new double[]{0.5, 0.3, 0.3, 0.4, 0.4, 0.4}, new double[]{1.0, 1.0, 2.0, 3.0, 2.0, 3.0}),
        King("King's Lance", 1, new double[]{0.9, 0.4, 0.5, 1.0, 0.0, 0.0}, new double[]{0.0, 1.0, 1.0, 1.0, 0.0, 1.0}),
        Queen("Queen's Lance", 2, new double[]{0.9, 0.5, 0.4, 0.0, 1.0, 0.0}, new double[]{0.0, 1.0, 1.0, 1.0, 0.0, 1.0}),
        Priestess("Priestess's Lance", 3, new double[]{0.7, 0.0, 1.0, 0.6, 0.5, 1.0}, new double[]{0.0, 1.0, 1.0, 2.0, 1.0, 2.0}),
        Knight("Knight's Lance", 4, new double[]{0.7, 1.0, 0.0, 0.5, 0.6, 1.0}, new double[]{0.0, 1.0, 1.0, 2.0, 1.0, 2.0}),
        Fool("Fool's Lance", 5, new double[]{0.8, 1.0, 1.0, 0.0, 0.0, 1.0}, new double[]{10.0, 2.0, 1.0, 1.0, 3.0, 4.0});

        private final double[] beatChances;
        private final double[] armorDmgs;
        private final String name;
        public final int index;

        private LanceType(String name, int index, double[] beats, double[] armorDmgs) {
            this.name = name;
            this.beatChances = beats;
            this.index = index;
            this.armorDmgs = armorDmgs;
        }

        public double unhorsesChanceVersus(LanceType type) {
            if (null == type) {
                return 1.0;
            }
            if (this.isFoolsDay() && (Fool == this || Fool == type)) {
                return 1.0 - this.beatChances[type.index];
            }
            return this.beatChances[type.index];
        }

        private boolean isFoolsDay() {
            GregorianCalendar cal = new GregorianCalendar();
            int dayOfYear = cal.get(6);
            if (dayOfYear % 3 == 0) {
                return true;
            }
            int dayOfMonth = cal.get(5);
            int month = cal.get(2);
            if (1 == dayOfMonth && (0 == month || 3 == month || 4 == month)) {
                return true;
            }
            if (11 == month && (25 == dayOfMonth || 31 == dayOfMonth)) {
                return true;
            }
            if (9 == month && 31 == dayOfMonth) {
                return true;
            }
            if (1 == month && 29 == dayOfMonth) {
                return true;
            }
            if (4 == month && 5 == dayOfMonth) {
                return true;
            }
            if (6 == month && 29 == dayOfMonth) {
                return true;
            }
            return 5 == month && 2 == dayOfMonth;
        }

        public double damageVersusArmor(ItemArmor armor) {
            if (null == armor || null == armor.func_82812_d() || armor.func_82812_d().ordinal() > this.armorDmgs.length - 1) {
                return this.armorDmgs[0];
            }
            return this.armorDmgs[armor.func_82812_d().ordinal()];
        }

        public String getName() {
            return this.name;
        }
    }
}

