/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.worldgen.feature;

import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.blocks.BlockLogHole;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenSpiritTree
extends WorldGenAbstractTree {
    private static final String __OBFID = "CL_00000430";
    private static final IBlockState logBlockState = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
    private static final IBlockState leaveBlockState = Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.DARK_OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public WorldGenSpiritTree(boolean p_i45461_1_) {
        super(p_i45461_1_);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        int heightToGrowTo = rand.nextInt(2) + rand.nextInt(2) + 6;
        boolean canGrowHereFlag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + heightToGrowTo + 1 <= 256) {
            int l;
            int k;
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + heightToGrowTo; ++j) {
                int b0 = 1;
                if (j == pos.func_177956_o()) {
                    b0 = 0;
                }
                if (j >= pos.func_177956_o() + 1 + heightToGrowTo - 2) {
                    b0 = 2;
                }
                for (k = pos.func_177958_n() - b0; k <= pos.func_177958_n() + b0 && canGrowHereFlag; ++k) {
                    for (l = pos.func_177952_p() - b0; l <= pos.func_177952_p() + b0 && canGrowHereFlag; ++l) {
                        if (j >= 0 && j < 256) {
                            if (this.isReplaceable(worldIn, new BlockPos(k, j, l))) continue;
                            canGrowHereFlag = false;
                            continue;
                        }
                        canGrowHereFlag = false;
                    }
                }
            }
            if (!canGrowHereFlag) {
                return false;
            }
            BlockPos down = pos.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && pos.func_177956_o() < 256 - heightToGrowTo - 1) {
                int z;
                int x;
                this.onPlantGrow(worldIn, pos.func_177977_b(), pos);
                EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                k = heightToGrowTo - rand.nextInt(4);
                l = 2 - rand.nextInt(3);
                int trunkCenterX = pos.func_177958_n();
                int trunkCenterZ = pos.func_177952_p();
                int heightTreeGrew = 0;
                int heightOfHole = rand.nextInt(2) + 1;
                for (x = 0; x < heightToGrowTo; ++x) {
                    z = pos.func_177956_o() + x;
                    if (x >= k && l > 0) {
                        trunkCenterX += enumfacing.func_82601_c();
                        trunkCenterZ += enumfacing.func_82599_e();
                        --l;
                    }
                    BlockPos blockpos1 = new BlockPos(trunkCenterX, z, trunkCenterZ);
                    state = worldIn.func_180495_p(blockpos1);
                    if (0 == x) {
                        for (int i = -1; i <= 1; ++i) {
                            for (int j = -1; j <= 1; ++j) {
                                blockpos1 = new BlockPos(trunkCenterX + i, z, trunkCenterZ + j);
                                state = worldIn.func_180495_p(blockpos1);
                                if ((0 != i || 0 != j) && rand.nextInt(3) == 0 || !state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos1) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos1) && state.func_177230_c() != Blocks.field_150346_d && state.func_177230_c() != Blocks.field_150349_c && state.func_177230_c() != Blocks.field_150329_H) continue;
                                this.func_175903_a(worldIn, blockpos1, logBlockState);
                                blockpos1 = blockpos1.func_177977_b();
                                state = worldIn.func_180495_p(blockpos1);
                                if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos1) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos1) || state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150329_H) {
                                    this.func_175903_a(worldIn, blockpos1, logBlockState);
                                }
                                this.onPlantGrow(worldIn, blockpos1, pos);
                            }
                        }
                        continue;
                    }
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos1) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos1)) continue;
                    if (heightOfHole == x) {
                        this.func_175903_a(worldIn, blockpos1, CommonProxy.logHoleBlock.func_176223_P().func_177226_a((IProperty)BlockLogHole.FACING, (Comparable)EnumFacing.func_176731_b((int)worldIn.field_73012_v.nextInt(4))));
                    } else {
                        this.func_175903_a(worldIn, blockpos1, logBlockState);
                    }
                    heightTreeGrew = z;
                }
                for (x = -2; x <= 0; ++x) {
                    for (z = -2; z <= 0; ++z) {
                        int b1 = -1;
                        this.func_150526_a(worldIn, trunkCenterX + x, heightTreeGrew + b1, trunkCenterZ + z);
                        this.func_150526_a(worldIn, 1 + trunkCenterX - x, heightTreeGrew + b1, trunkCenterZ + z);
                        this.func_150526_a(worldIn, trunkCenterX + x, heightTreeGrew + b1, 1 + trunkCenterZ - z);
                        this.func_150526_a(worldIn, 1 + trunkCenterX - x, heightTreeGrew + b1, 1 + trunkCenterZ - z);
                        if (x <= -2 && z <= -1 || x == -1 && z == -2) continue;
                        int b2 = 1;
                        this.func_150526_a(worldIn, trunkCenterX + x, heightTreeGrew + b2, trunkCenterZ + z);
                        this.func_150526_a(worldIn, 1 + trunkCenterX - x, heightTreeGrew + b2, trunkCenterZ + z);
                        this.func_150526_a(worldIn, trunkCenterX + x, heightTreeGrew + b2, 1 + trunkCenterZ - z);
                        this.func_150526_a(worldIn, 1 + trunkCenterX - x, heightTreeGrew + b2, 1 + trunkCenterZ - z);
                    }
                }
                if (rand.nextBoolean()) {
                    this.func_150526_a(worldIn, trunkCenterX, heightTreeGrew + 2, trunkCenterZ);
                    this.func_150526_a(worldIn, trunkCenterX + 1, heightTreeGrew + 2, trunkCenterZ);
                    this.func_150526_a(worldIn, trunkCenterX + 1, heightTreeGrew + 2, trunkCenterZ + 1);
                    this.func_150526_a(worldIn, trunkCenterX, heightTreeGrew + 2, trunkCenterZ + 1);
                }
                for (x = -3; x <= 3; ++x) {
                    for (z = -3; z <= 3; ++z) {
                        if (x == -3 && z == -3 || x == -3 && z == 4 || x == 4 && z == -3 || x == 4 && z == 4 || Math.abs(x) >= 3 && Math.abs(z) >= 3) continue;
                        this.func_150526_a(worldIn, trunkCenterX + x, heightTreeGrew, trunkCenterZ + z);
                    }
                }
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        int j2;
                        int l2;
                        if (x == 0 && z == 0 || rand.nextInt(3) > 0) continue;
                        int k2 = rand.nextInt(2) + 1;
                        for (l2 = 0; l2 < k2; ++l2) {
                            this.func_175903_a(worldIn, new BlockPos(pos.func_177958_n() + x, heightTreeGrew - l2 - 1, pos.func_177952_p() + z), logBlockState);
                        }
                        for (l2 = -1; l2 <= 1; ++l2) {
                            for (j2 = -1; j2 <= 1; ++j2) {
                                this.func_150526_a(worldIn, trunkCenterX + x + l2, heightTreeGrew - 0, trunkCenterZ + z + j2);
                            }
                        }
                        for (l2 = -2; l2 <= 2; ++l2) {
                            for (j2 = -2; j2 <= 2; ++j2) {
                                if (Math.abs(l2) == 2 && Math.abs(j2) == 2) continue;
                                this.func_150526_a(worldIn, trunkCenterX + x + l2, heightTreeGrew - 1, trunkCenterZ + z + j2);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void func_150526_a(World worldIn, int p_150526_2_, int p_150526_3_, int p_150526_4_) {
        BlockPos pos = new BlockPos(p_150526_2_, p_150526_3_, p_150526_4_);
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos)) {
            this.func_175903_a(worldIn, new BlockPos(p_150526_2_, p_150526_3_, p_150526_4_), leaveBlockState);
        }
    }

    private void onPlantGrow(World world, BlockPos pos, BlockPos source) {
        IBlockState state = world.func_180495_p(pos);
        state.func_177230_c().onPlantGrow(state, world, pos, source);
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos) || this.func_150523_a(state.func_177230_c());
    }

    protected boolean func_150523_a(Block block) {
        IBlockState state = block.func_176194_O().func_177621_b();
        return block.func_149688_o(state) == Material.field_151579_a || block.func_149688_o(state) == Material.field_151584_j || block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150364_r || block == Blocks.field_150363_s || block == Blocks.field_150345_g || block == CommonProxy.spiritTreeSaplingBlock || block == Blocks.field_150395_bd;
    }
}

