/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei;

import blusunrize.immersiveengineering.client.gui.GuiFluidSorter;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.List;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraftforge.fluids.FluidStack;

public class FluidSorterGhostHandler
implements IGhostIngredientHandler<GuiFluidSorter> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(GuiFluidSorter gui, I ingredient, boolean doStart) {
        if (ingredient instanceof FluidStack) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int side = 0; side < 6; ++side) {
                for (int slot = 0; slot < 8; ++slot) {
                    builder.add((Object)new GhostFluidTarget(side, slot, gui));
                }
            }
            return builder.build();
        }
        IELogger.info(ingredient + " of type " + ingredient.getClass());
        return ImmutableList.of();
    }

    public void onComplete() {
    }

    private static class GhostFluidTarget
    implements IGhostIngredientHandler.Target<FluidStack> {
        final int side;
        final int slot;
        final GuiFluidSorter gui;
        Rectangle area;
        int lastGuiLeft;
        int lastGuiTop;

        public GhostFluidTarget(int side, int slot, GuiFluidSorter gui) {
            this.side = side;
            this.slot = slot;
            this.gui = gui;
            this.initRectangle();
        }

        private void initRectangle() {
            int x = 4 + this.side / 2 * 58 + (this.slot < 3 ? this.slot * 18 : (this.slot > 4 ? (this.slot - 5) * 18 : (this.slot == 3 ? 0 : 36)));
            int y = 22 + this.side % 2 * 76 + (this.slot < 3 ? 0 : (this.slot > 4 ? 36 : 18));
            this.area = new Rectangle(this.gui.getGuiLeft() + x, this.gui.getGuiTop() + y, 16, 16);
            this.lastGuiLeft = this.gui.getGuiLeft();
            this.lastGuiTop = this.gui.getGuiTop();
        }

        public Rectangle getArea() {
            if (this.lastGuiLeft != this.gui.getGuiLeft() || this.lastGuiTop != this.gui.getGuiTop()) {
                this.initRectangle();
            }
            return this.area;
        }

        public void accept(FluidStack ingredient) {
            this.gui.setFluidInSlot(this.side, this.slot, ingredient);
        }
    }
}

