/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.item.ItemMod;

public class ItemDirtRod
extends ItemMod
implements IManaUsingItem,
IBlockProvider,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_dirt.png");
    static final int COST = 75;

    public ItemDirtRod() {
        this("dirtRod");
    }

    public ItemDirtRod(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float par8, float par9, float par10) {
        return ItemDirtRod.place(player, world, pos, hand, side, par8, par9, par10, Blocks.field_150346_d, 75, 0.35f, 0.2f, 0.05f);
    }

    public static EnumActionResult place(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ, Block block, int cost, float r, float g, float b) {
        ItemStack stack = player.func_184586_b(hand);
        if (ManaItemHandler.requestManaExactForTool(stack, player, cost, false)) {
            int entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos.func_177972_a(side), pos.func_177972_a(side).func_177982_a(1, 1, 1))).size();
            if (entities == 0) {
                ItemStack stackToPlace = new ItemStack(block);
                player.func_184611_a(hand, stackToPlace);
                stackToPlace.func_179546_a(player, world, pos, hand, side, hitX, hitY, hitZ);
                player.func_184611_a(hand, stack);
                if (stackToPlace.func_190926_b()) {
                    ManaItemHandler.requestManaExactForTool(stack, player, cost, true);
                    for (int i = 0; i < 6; ++i) {
                        Botania.proxy.sparkleFX((double)(pos.func_177958_n() + side.func_82601_c()) + Math.random(), (double)(pos.func_177956_o() + side.func_96559_d()) + Math.random(), (double)(pos.func_177952_p() + side.func_82599_e()) + Math.random(), r, g, b, 1.0f, 5);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public boolean provideBlock(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta, boolean doit) {
        if (block == Blocks.field_150346_d && meta == 0) {
            return !doit || ManaItemHandler.requestManaExactForTool(requestor, player, 75, true);
        }
        return false;
    }

    @Override
    public int getBlockCount(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta) {
        if (block == Blocks.field_150346_d && meta == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        BlockPos pos;
        IBlockState state;
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        if (!world.field_72995_K && tile.getCurrentMana() >= 75 && tile.getElapsedFunctionalTicks() % 4 == 0 && world.field_73012_v.nextInt(8) == 0 && tile.isEnabled() && (state = world.func_180495_p(pos = ((TileEntity)tile).func_174877_v().func_177972_a(tile.getAvatarFacing()))).func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P()));
            tile.recieveMana(-75);
        }
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

