/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.network;

import engineers.workshop.EngineersWorkshop;
import engineers.workshop.client.container.ContainerTable;
import engineers.workshop.common.network.PacketId;
import engineers.workshop.common.network.data.DataType;
import engineers.workshop.common.table.TileTable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import reborncore.common.network.ExtendedPacketBuffer;
import reborncore.common.network.INetworkPacket;

public class DataPacket
implements INetworkPacket<DataPacket> {
    public BlockPos tablePos;
    public PacketId packetId;
    public NBTTagCompound compound;
    public DataType dataType;

    public NBTTagCompound createCompound() {
        NBTTagCompound tagCompound;
        this.compound = tagCompound = new NBTTagCompound();
        return tagCompound;
    }

    public void writeData(ExtendedPacketBuffer buffer) throws IOException {
        if (this.tablePos != null) {
            buffer.writeBoolean(true);
            buffer.func_179255_a(this.tablePos);
        } else {
            buffer.writeBoolean(false);
            buffer.func_179255_a(new BlockPos(0, 0, 0));
        }
        if (this.compound != null) {
            buffer.writeBoolean(true);
            buffer.func_150786_a(this.compound);
        } else {
            buffer.writeBoolean(false);
            buffer.func_150786_a(new NBTTagCompound());
        }
        if (this.dataType != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.dataType.ordinal());
        } else {
            buffer.writeBoolean(false);
            buffer.writeInt(0);
        }
        buffer.writeInt(this.packetId.ordinal());
    }

    public void readData(ExtendedPacketBuffer buffer) throws IOException {
        if (buffer.readBoolean()) {
            this.tablePos = buffer.func_179259_c();
        } else {
            buffer.func_179259_c();
            this.tablePos = null;
        }
        if (buffer.readBoolean()) {
            this.compound = buffer.func_150793_b();
        } else {
            buffer.func_150793_b();
        }
        if (buffer.readBoolean()) {
            this.dataType = DataType.values()[buffer.readInt()];
        } else {
            buffer.readInt();
        }
        this.packetId = PacketId.values()[buffer.readInt()];
    }

    public void processData(DataPacket message, MessageContext context) {
        if (context.side == Side.CLIENT) {
            this.onPacket(message, EngineersWorkshop.proxy.getPlayer(), false);
        } else {
            this.onPacket(message, (EntityPlayer)context.getServerHandler().field_147369_b, true);
        }
    }

    private void onPacket(DataPacket message, EntityPlayer player, boolean onServer) {
        PacketId id = message.packetId;
        TileTable table = null;
        if (id.isInInterface() && player.field_71070_bA instanceof ContainerTable) {
            table = ((ContainerTable)player.field_71070_bA).getTable();
        }
        if (table == null && message.tablePos != null) {
            World world = player.field_70170_p;
            BlockPos tablePos = message.tablePos;
            if (!world.func_175667_e(tablePos)) {
                return;
            }
            TileEntity te = world.func_175625_s(tablePos);
            if (te instanceof TileTable) {
                table = (TileTable)te;
            }
        }
        if (table != null) {
            if (onServer) {
                table.receiveServerPacket(message, id, player);
            } else {
                table.receiveClientPacket(message, id);
            }
        }
    }
}

