/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.network.data;

import engineers.workshop.client.page.setting.ItemSetting;
import engineers.workshop.client.page.setting.Setting;
import engineers.workshop.client.page.setting.Side;
import engineers.workshop.client.page.setting.Transfer;
import engineers.workshop.client.page.setting.TransferMode;
import engineers.workshop.common.network.data.DataBase;
import engineers.workshop.common.table.TileTable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class DataSide
extends DataBase {
    private static final int SETTINGS = 5;
    private static final int SIDES = 6;
    private static final int MODES = 2;
    public static final int LENGTH = 60;

    public static int getId(Setting setting, Side side, Transfer transfer) {
        return setting.getId() + 5 * side.getDirection().ordinal() + (transfer.isInput() ? 0 : 30);
    }

    protected Transfer getTransfer(TileTable table, int id) {
        int settingId = id % 5;
        int sideId = (id /= 5) % 6;
        int modeId = id /= 6;
        Side side = table.getTransferPage().getSettings().get(settingId).getSides().get(sideId);
        if (modeId == 0) {
            return side.getInput();
        }
        return side.getOutput();
    }

    public static class FilterMode
    extends FilterBase {
        @Override
        public void save(TileTable table, NBTTagCompound dw, int id) {
            dw.func_74768_a("mode", this.getSetting(table, id).getMode().ordinal());
        }

        @Override
        public void load(TileTable table, NBTTagCompound dr, int id) {
            this.getSetting(table, id).setMode(TransferMode.values()[dr.func_74762_e("mode")]);
        }
    }

    public static class Filter
    extends FilterBase {
        @Override
        public void save(TileTable table, NBTTagCompound dw, int id) {
            ItemSetting setting = this.getSetting(table, id);
            ItemStack itemStack = setting.getItem();
            dw.func_74757_a("hasItem", !itemStack.func_190926_b());
            if (!itemStack.func_190926_b()) {
                dw.func_74768_a("id", Item.func_150891_b((Item)itemStack.func_77973_b()));
                dw.func_74768_a("damage", itemStack.func_77952_i());
                if (itemStack.func_77942_o()) {
                    dw.func_74782_a("nbt", (NBTBase)itemStack.func_77978_p());
                }
            }
        }

        @Override
        public void load(TileTable table, NBTTagCompound dr, int id) {
            ItemSetting setting = this.getSetting(table, id);
            if (dr.func_74767_n("hasItem")) {
                int itemId = dr.func_74762_e("id");
                int itemDmg = dr.func_74762_e("damage");
                ItemStack item = new ItemStack(Item.func_150899_d((int)itemId), 1, itemDmg);
                if (dr.func_74764_b("nbt")) {
                    item.func_77982_d(dr.func_74775_l("nbt"));
                }
                setting.setItem(item);
            } else {
                setting.setItem(ItemStack.field_190927_a);
            }
        }
    }

    public static abstract class FilterBase
    extends DataSide {
        public static final int LENGTH = 600;

        public static int getId(Setting setting, Side side, Transfer transfer, ItemSetting itemSetting) {
            return FilterBase.getId(setting, side, transfer) * 10 + itemSetting.getId();
        }

        protected ItemSetting getSetting(TileTable table, int id) {
            return this.getTransfer(table, id / 10).getItem(id % 10);
        }
    }

    public static class WhiteList
    extends DataSide {
        @Override
        public void save(TileTable table, NBTTagCompound dw, int id) {
            dw.func_74757_a("whitelist", this.getTransfer(table, id).hasWhiteList());
        }

        @Override
        public void load(TileTable table, NBTTagCompound dr, int id) {
            this.getTransfer(table, id).setUseWhiteList(dr.func_74767_n("whitelist"));
        }
    }

    public static class Auto
    extends DataSide {
        @Override
        public void save(TileTable table, NBTTagCompound dw, int id) {
            dw.func_74757_a("auto", this.getTransfer(table, id).isAuto());
        }

        @Override
        public void load(TileTable table, NBTTagCompound dr, int id) {
            this.getTransfer(table, id).setAuto(dr.func_74767_n("auto"));
        }
    }

    public static class Enabled
    extends DataSide {
        @Override
        public void save(TileTable table, NBTTagCompound dw, int id) {
            dw.func_74757_a("enabled", this.getTransfer(table, id).isEnabled());
        }

        @Override
        public void load(TileTable table, NBTTagCompound dr, int id) {
            this.getTransfer(table, id).setEnabled(dr.func_74767_n("enabled"));
        }
    }
}

