/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.network.data;

import engineers.workshop.common.network.IBitCount;
import engineers.workshop.common.network.LengthCount;
import engineers.workshop.common.network.data.DataBase;
import engineers.workshop.common.network.data.DataLit;
import engineers.workshop.common.network.data.DataPage;
import engineers.workshop.common.network.data.DataSide;
import engineers.workshop.common.network.data.DataUnit;
import engineers.workshop.common.table.TileTable;
import net.minecraft.nbt.NBTTagCompound;

public enum DataType {
    PAGE(DataPage.class),
    PROGRESS(DataUnit.Progress.class, 8),
    SIDE_ENABLED(DataSide.Enabled.class, 60),
    SIDE_AUTO(DataSide.Auto.class, 60),
    SIDE_FILTER(DataSide.Filter.class, 600),
    SIDE_WHITE_LIST(DataSide.WhiteList.class, 60),
    SIDE_FILTER_MODE(DataSide.FilterMode.class, 600),
    LIT(DataLit.class),
    CHARGED(DataUnit.Charged.class, 8);

    private IBitCount lengthBits;
    private int length;
    private DataBase data;

    private DataType(Class<? extends DataBase> clazz, int length) {
        this(clazz);
        this.length = length;
        this.lengthBits = new LengthCount(length);
    }

    private DataType(Class<? extends DataBase> clazz) {
        try {
            this.data = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.length = 1;
    }

    public void save(TileTable table, NBTTagCompound dw, int id) {
        if (this.data != null) {
            if (id == -1) {
                for (int i = 0; i < this.length; ++i) {
                    this.data.save(table, dw, i);
                }
            } else {
                if (this.lengthBits != null) {
                    dw.func_74768_a("id", id);
                }
                this.data.save(table, dw, id);
            }
        }
    }

    public int load(TileTable table, NBTTagCompound dr, boolean all) {
        if (this.data != null) {
            if (all) {
                for (int i = 0; i < this.length; ++i) {
                    this.data.load(table, dr, i);
                }
            } else {
                int id = 0;
                if (this.lengthBits != null) {
                    id = dr.func_74762_e("id");
                }
                this.data.load(table, dr, id);
                return id;
            }
        }
        return -1;
    }

    public boolean shouldBounce(TileTable table) {
        return this.data != null && this.data.shouldBounce(table);
    }

    public boolean shouldBounceToAll(TileTable table) {
        return this.data != null && this.data.shouldBounceToAll(table);
    }
}

