/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.blocks;

import binnie.botany.CreativeTabBotany;
import binnie.botany.EnumHelper;
import binnie.botany.api.gardening.EnumAcidity;
import binnie.botany.api.gardening.EnumMoisture;
import binnie.botany.api.gardening.EnumSoilType;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.blocks.BlockPlant;
import binnie.botany.blocks.PlantType;
import binnie.botany.core.BotanyCore;
import binnie.botany.modules.ModuleFlowers;
import binnie.botany.modules.ModuleGardening;
import binnie.core.util.I18N;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSoil
extends Block
implements IBlockSoil,
IItemModelRegister {
    public static final PropertyEnum<EnumMoisture> MOISTURE = PropertyEnum.func_177709_a((String)"moisture", EnumMoisture.class);
    public static final PropertyEnum<EnumAcidity> ACIDITY = PropertyEnum.func_177709_a((String)"acidity", EnumAcidity.class);
    public static final AxisAlignedBB SOIL_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    private final boolean weedKilled;
    private final EnumSoilType type;

    public BlockSoil(EnumSoilType type, String blockName, boolean weedKilled) {
        super(Material.field_151578_c);
        this.type = type;
        this.weedKilled = weedKilled;
        this.func_149663_c("botany.soil." + type.func_176610_l());
        this.func_149647_a(CreativeTabBotany.INSTANCE);
        this.setRegistryName(blockName);
        this.func_149675_a(true);
        this.func_149713_g(255);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
    }

    public static int getMeta(EnumAcidity acid, EnumMoisture moisture) {
        return acid.ordinal() * 3 + moisture.ordinal();
    }

    public static String getPH(ItemStack stack, boolean withColor, boolean byNeutralNone) {
        int index = stack.func_77952_i() / 3;
        index = index < EnumAcidity.values().length ? index : EnumAcidity.values().length - 1;
        EnumAcidity ph = EnumAcidity.values()[index];
        if (byNeutralNone && ph == EnumAcidity.NEUTRAL) {
            return "";
        }
        return TextFormatting.GRAY + I18N.localise("botany.ph") + ": " + EnumHelper.getLocalisedName(ph, withColor);
    }

    public static String getMoisture(ItemStack stack, boolean withColor, boolean byNormalNone) {
        EnumMoisture moisure = EnumMoisture.values()[stack.func_77952_i() % 3];
        if (byNormalNone && moisure == EnumMoisture.NORMAL) {
            return "";
        }
        return TextFormatting.GRAY + I18N.localise("botany.moisture") + ": " + EnumHelper.getLocalisedName(moisure, withColor);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da && block != this;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public String func_149739_a() {
        return super.func_149739_a().replaceFirst("tile.", "");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SOIL_BLOCK_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return SOIL_BLOCK_AABB;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return SOIL_BLOCK_AABB;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 9; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (EnumAcidity acidity : EnumAcidity.values()) {
            for (EnumMoisture moisture : EnumMoisture.values()) {
                String modelName = "";
                if (acidity != EnumAcidity.NEUTRAL) {
                    modelName = modelName + acidity.func_176610_l();
                }
                if (moisture != EnumMoisture.NORMAL) {
                    if (!modelName.isEmpty()) {
                        modelName = modelName + "_";
                    }
                    modelName = modelName + moisture.func_176610_l();
                }
                if (modelName.isEmpty()) {
                    modelName = "normal";
                }
                String identifier = this.weedKilled ? this.type.func_176610_l() + "_no_weed/" + modelName : this.type.func_176610_l() + '/' + modelName;
                manager.registerItemModel(item, moisture.ordinal() + acidity.ordinal() * 3, identifier);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MOISTURE, ACIDITY});
    }

    public int func_176201_c(IBlockState state) {
        return BlockSoil.getMeta((EnumAcidity)((Object)state.func_177229_b(ACIDITY)), (EnumMoisture)((Object)state.func_177229_b(MOISTURE)));
    }

    public IBlockState func_176203_a(int meta) {
        EnumMoisture moisture = EnumMoisture.values()[meta % 3];
        EnumAcidity acidity = EnumAcidity.values()[meta / 3];
        return this.func_176223_P().func_177226_a(MOISTURE, (Comparable)((Object)moisture)).func_177226_a(ACIDITY, (Comparable)((Object)acidity));
    }

    public EnumSoilType getType() {
        return this.type;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        EnumMoisture moisture = (EnumMoisture)((Object)state.func_177229_b(MOISTURE));
        EnumMoisture desiredMoisture = BotanyCore.getGardening().getNaturalMoisture(world, pos);
        if (desiredMoisture.ordinal() > moisture.ordinal()) {
            moisture = moisture == EnumMoisture.DRY ? EnumMoisture.NORMAL : EnumMoisture.DAMP;
        } else if (desiredMoisture.ordinal() < moisture.ordinal()) {
            moisture = moisture == EnumMoisture.DAMP ? EnumMoisture.NORMAL : EnumMoisture.DRY;
        }
        IBlockState blockState = state.func_177226_a(MOISTURE, (Comparable)((Object)moisture));
        if (state != blockState) {
            world.func_180501_a(pos, blockState, 2);
        }
        if (!this.weedKilled) {
            if (rand.nextInt(5 - this.getType(world, pos).ordinal()) != 0) {
                return;
            }
            if (!world.func_175623_d(pos = pos.func_177984_a())) {
                return;
            }
            world.func_180501_a(pos, ModuleGardening.plant.func_176203_a(PlantType.WEEDS.ordinal()), 2);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        }
    }

    @Override
    public EnumAcidity getPH(World world, BlockPos pos) {
        return (EnumAcidity)((Object)world.func_180495_p(pos).func_177229_b(ACIDITY));
    }

    @Override
    public EnumMoisture getMoisture(World world, BlockPos pos) {
        return (EnumMoisture)((Object)world.func_180495_p(pos).func_177229_b(MOISTURE));
    }

    @Override
    public EnumSoilType getType(World world, BlockPos pos) {
        return this.type;
    }

    @Override
    public boolean fertilise(World world, BlockPos pos, EnumSoilType maxLevel) {
        EnumSoilType type = this.getType(world, pos);
        if (type.ordinal() >= maxLevel.ordinal()) {
            return false;
        }
        IBlockState old = world.func_180495_p(pos);
        IBlockState newState = BotanyCore.getGardening().getSoil(maxLevel, this.weedKilled, (EnumMoisture)((Object)old.func_177229_b(MOISTURE)), (EnumAcidity)((Object)old.func_177229_b(ACIDITY)));
        return world.func_180501_a(pos, newState, 2);
    }

    @Override
    public boolean degrade(World world, BlockPos pos, EnumSoilType minLevel) {
        EnumSoilType type = this.getType(world, pos);
        if (type.ordinal() <= minLevel.ordinal()) {
            return false;
        }
        IBlockState old = world.func_180495_p(pos);
        IBlockState newState = BotanyCore.getGardening().getSoil(minLevel, this.weedKilled, (EnumMoisture)((Object)old.func_177229_b(MOISTURE)), (EnumAcidity)((Object)old.func_177229_b(ACIDITY)));
        return world.func_180501_a(pos, newState, 2);
    }

    @Override
    public boolean setPH(World world, BlockPos pos, EnumAcidity pH) {
        IBlockState blockState = world.func_180495_p(pos);
        return world.func_175656_a(pos, blockState.func_177226_a(ACIDITY, (Comparable)((Object)pH)));
    }

    @Override
    public boolean setMoisture(World world, BlockPos pos, EnumMoisture moisture) {
        IBlockState blockState = world.func_180495_p(pos);
        return world.func_175656_a(pos, blockState.func_177226_a(MOISTURE, (Comparable)((Object)moisture)));
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        if (world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN, false)) {
            ((World)world).func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177984_a());
        if (ForestryAPI.moduleManager.isModuleEnabled("botany", "botany.flowers") && plant.func_177230_c() == ModuleFlowers.flower) {
            return true;
        }
        if (plant.func_177230_c() == ModuleGardening.plant) {
            return !this.weedKilled || !BlockPlant.isWeed(world, pos);
        }
        return world instanceof World && Blocks.field_150346_d.canSustainPlant(state, world, pos, direction, plantable);
    }

    @Override
    public boolean resistsWeeds(World world, BlockPos pos) {
        return this.weedKilled;
    }

    public boolean isWeedKilled() {
        return this.weedKilled;
    }
}

