/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft;

import binnie.core.gui.Tooltip;
import net.minecraft.util.text.TextFormatting;

public class MinecraftTooltip
extends Tooltip {
    public static int getOutline(Tooltip.ITooltipType type) {
        return TypeColour.valueOf(type.toString()).getOutline();
    }

    public static String getTitle(Tooltip.ITooltipType type) {
        return TypeColour.valueOf(type.toString()).getTitle();
    }

    public static String getBody(Tooltip.ITooltipType type) {
        return TypeColour.valueOf(type.toString()).getBody();
    }

    private static enum TypeColour {
        STANDARD(0x5000FF, TextFormatting.WHITE, TextFormatting.GRAY),
        HELP(5046016, TextFormatting.GREEN, TextFormatting.DARK_GREEN),
        INFORMATION(49151, TextFormatting.AQUA, TextFormatting.DARK_AQUA),
        ERROR(16724224, TextFormatting.RED, TextFormatting.DARK_RED),
        WARNING(0xFF9F00, TextFormatting.YELLOW, TextFormatting.GOLD),
        USER(9839667, TextFormatting.RED, TextFormatting.DARK_RED),
        POWER(9006592, TextFormatting.YELLOW, TextFormatting.GOLD);

        private final int outline;
        private final String mainText;
        private final String bodyText;

        private TypeColour(int outline, TextFormatting mainText, TextFormatting bodyText) {
            this.outline = outline;
            this.mainText = mainText.toString();
            this.bodyText = bodyText.toString();
        }

        public int getOutline() {
            return this.outline;
        }

        public String getTitle() {
            return this.mainText;
        }

        public String getBody() {
            return this.bodyText;
        }
    }

    public static enum Type implements Tooltip.ITooltipType
    {
        ERROR,
        WARNING;

    }
}

