/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.integration.extrabees;

import binnie.core.IInitializable;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ExtraBeesIntegration
implements IInitializable {
    private static final boolean loaded = Loader.isModLoaded((String)"extrabees");
    @Nullable
    private static IAlleleBeeSpecies water;
    @Nullable
    private static IAlleleBeeSpecies rock;
    @Nullable
    private static IAlleleBeeSpecies basalt;
    @Nullable
    private static IAlleleBeeSpecies marble;
    private static Block hive;

    public static boolean isLoaded() {
        return loaded;
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        hive = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("extrabees", "hive"));
    }

    @Override
    public void postInit() {
        water = this.getExtraBeesSpecies("water");
        rock = this.getExtraBeesSpecies("rock");
        basalt = this.getExtraBeesSpecies("basalt");
        marble = this.getExtraBeesSpecies("marble");
    }

    public static ItemStack getHive(@Nullable IAlleleSpecies speciesCurrent) {
        if (speciesCurrent == null || hive == null) {
            return ItemStack.field_190927_a;
        }
        if (speciesCurrent == water) {
            return new ItemStack(hive, 1, 0);
        }
        if (speciesCurrent == rock) {
            return new ItemStack(hive, 1, 1);
        }
        if (speciesCurrent == basalt) {
            return new ItemStack(hive, 1, 2);
        }
        if (speciesCurrent == marble) {
            return new ItemStack(hive, 1, 3);
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    private IAlleleBeeSpecies getExtraBeesSpecies(String species) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("extrabees.species." + species);
    }
}

