/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.ModId;
import binnie.core.machines.inventory.BaseSlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.util.I18N;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class InventorySlot
extends BaseSlot<ItemStack> {
    private ItemStack content = ItemStack.field_190927_a;
    private Type type = Type.Standard;

    public InventorySlot(int index, ResourceLocation unlocLocation) {
        super(index, unlocLocation);
    }

    public boolean isFake() {
        return false;
    }

    @Override
    @Nonnull
    public ItemStack getContent() {
        return this.content.func_190926_b() ? ItemStack.field_190927_a : this.content;
    }

    public void setContent(ItemStack itemStack) {
        this.content = itemStack;
    }

    public ItemStack getItemStack() {
        return this.content;
    }

    public ItemStack decrStackSize(int amount) {
        if (this.content.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.content.func_190916_E() <= amount) {
            ItemStack stack = this.content.func_77946_l();
            this.content = ItemStack.field_190927_a;
            return stack;
        }
        ItemStack stack = this.content.func_77946_l();
        this.content.func_190918_g(amount);
        stack.func_190920_e(amount);
        return stack;
    }

    public void readFromNBT(NBTTagCompound slotNBT) {
        if (slotNBT.func_74764_b("item")) {
            NBTTagCompound itemNBT = slotNBT.func_74775_l("item");
            this.content = new ItemStack(itemNBT);
        } else {
            this.content = ItemStack.field_190927_a;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound slotNBT) {
        NBTTagCompound itemNBT = new NBTTagCompound();
        if (!this.content.func_190926_b()) {
            this.content.func_77955_b(itemNBT);
        }
        slotNBT.func_74782_a("item", (NBTBase)itemNBT);
        return slotNBT;
    }

    public SlotValidator getValidator() {
        return (SlotValidator)super.getValidator();
    }

    public void setType(Type type) {
        this.type = type;
        if (type == Type.Recipe) {
            this.forbidInteraction();
        }
    }

    public boolean isRecipe() {
        return this.type == Type.Recipe;
    }

    @Override
    public String getName() {
        SlotValidator validator = this.getValidator();
        if (validator != null) {
            return I18N.localise(ModId.CORE, "gui.slot.validated", validator.getTooltip());
        }
        if (this.unlocLocation == null) {
            return "";
        }
        return I18N.localise(this.unlocLocation);
    }

    public static enum Type {
        Standard,
        Recipe;

    }
}

