/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.power.ITankMachine;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class TankInfo
implements INbtReadable,
INbtWritable {
    @Nullable
    private FluidStack liquid;
    private float capacity = 0.0f;

    public TankInfo(IFluidTank tank) {
        this.capacity = tank.getCapacity();
        this.liquid = tank.getFluid();
    }

    public TankInfo() {
    }

    public static TankInfo[] get(ITankMachine machine) {
        TankInfo[] info = new TankInfo[machine.getTanks().length];
        for (int i = 0; i < info.length; ++i) {
            info[i] = new TankInfo(machine.getTanks()[i]);
        }
        return info;
    }

    public float getAmount() {
        return this.liquid == null ? 0.0f : (float)this.liquid.amount;
    }

    public float getCapacity() {
        return this.capacity;
    }

    public boolean isEmpty() {
        return this.liquid == null;
    }

    public String getName() {
        return this.liquid == null ? "" : this.liquid.getFluid().getLocalizedName(this.liquid);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.capacity = nbt.func_74762_e("capacity");
        if (nbt.func_74764_b("liquid")) {
            this.liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("liquid"));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("capacity", (int)this.getCapacity());
        if (this.liquid == null) {
            return nbt;
        }
        NBTTagCompound tag = new NBTTagCompound();
        this.liquid.writeToNBT(tag);
        nbt.func_74782_a("liquid", (NBTBase)tag);
        return nbt;
    }

    @Nullable
    public FluidStack getLiquid() {
        return this.liquid;
    }
}

