/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.modules;

import binnie.core.modules.IConfigHandler;
import forestry.api.modules.ForestryModule;
import forestry.api.modules.IForestryModule;
import forestry.api.modules.IModuleContainer;
import forestry.modules.ForestryPluginUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ModuleContainer
implements IModuleContainer {
    private static final String CONFIG_CATEGORY = "modules";
    protected final Set<IForestryModule> loadedModules;
    protected final Set<IForestryModule> unloadedModules;
    protected final File configFolder;
    protected final Configuration configModules;
    protected final String containerID;
    protected final ContainerState state;
    protected final Set<IConfigHandler> configHandlers;

    public ModuleContainer(String containerID, ContainerState state) {
        this.containerID = containerID;
        this.state = state;
        this.loadedModules = new LinkedHashSet<IForestryModule>();
        this.unloadedModules = new LinkedHashSet<IForestryModule>();
        this.configFolder = new File(Loader.instance().getConfigDir(), "forestry/" + containerID);
        this.configModules = new Configuration(new File(this.configFolder, "modules.cfg"));
        this.configHandlers = new HashSet<IConfigHandler>();
    }

    public void setupAPI() {
        for (IForestryModule module : this.loadedModules) {
            module.setupAPI();
        }
        for (IForestryModule module : this.unloadedModules) {
            module.disabledSetupAPI();
        }
    }

    protected void runPreInit(FMLPreInitializationEvent event) {
        for (IConfigHandler handler : this.configHandlers) {
            handler.loadConfig();
        }
        for (IForestryModule module : this.loadedModules) {
            module.registerItemsAndBlocks();
        }
        for (IForestryModule module : this.loadedModules) {
            module.preInit();
        }
    }

    public void runInit(FMLInitializationEvent event) {
        for (IForestryModule module : this.loadedModules) {
            module.doInit();
            module.registerRecipes();
        }
    }

    public void runPostInit(FMLPostInitializationEvent event) {
        for (IForestryModule module : this.loadedModules) {
            module.postInit();
        }
    }

    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        for (IConfigHandler handler : this.configHandlers) {
            handler.loadConfig();
        }
    }

    public boolean isModuleEnabled(IForestryModule module) {
        ForestryModule info = module.getClass().getAnnotation(ForestryModule.class);
        String comment = ForestryPluginUtil.getComment((IForestryModule)module);
        Property prop = this.getModulesConfig().get(CONFIG_CATEGORY, info.moduleID(), true, comment);
        return prop.getBoolean();
    }

    public void onConfiguredModules(Collection<IForestryModule> activeModules, Collection<IForestryModule> unloadedModules) {
        this.loadedModules.addAll(activeModules);
        this.unloadedModules.addAll(unloadedModules);
    }

    public String getID() {
        return this.containerID;
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    public Configuration getModulesConfig() {
        return this.configModules;
    }

    public void registerConfigHandler(IConfigHandler handler) {
        this.configHandlers.add(handler);
    }

    public boolean isAvailable() {
        return this.state.isAvailable();
    }

    public static interface ContainerState {
        public boolean isAvailable();
    }
}

