/*
 * Decompiled with CFR 0.152.
 */
package binnie.design.blocks;

import binnie.design.DesignHelper;
import binnie.design.EnumDesign;
import binnie.design.api.IDesign;
import binnie.design.api.IDesignMaterial;
import binnie.design.api.IDesignSystem;
import binnie.design.api.ILayout;
import binnie.design.api.IToolHammer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DesignBlock {
    private static final int[][] ROTATION_MATRIX = new int[][]{{0, 1, 4, 5, 3, 2, 6}, {0, 1, 5, 4, 2, 3, 6}, {5, 4, 2, 3, 0, 1, 6}, {4, 5, 2, 3, 1, 0, 6}, {2, 3, 1, 0, 4, 5, 6}, {3, 2, 0, 1, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 6}};
    private final IDesign design;
    private final IDesignMaterial primaryMaterial;
    private final IDesignMaterial secondaryMaterial;
    private int rotation;
    private EnumFacing facing;
    private boolean panel = false;

    public DesignBlock(IDesignSystem system, @Nullable IDesignMaterial primaryWood, @Nullable IDesignMaterial secondaryWood, @Nullable IDesign design, int rotation, @Nullable EnumFacing dir) {
        this.rotation = rotation;
        this.design = design == null ? EnumDesign.Blank : design;
        this.primaryMaterial = primaryWood == null ? system.getDefaultMaterial() : primaryWood;
        this.secondaryMaterial = secondaryWood == null ? system.getDefaultMaterial() : secondaryWood;
        if (this.rotation > 3 || this.rotation < 0) {
            this.rotation = 0;
        }
        this.facing = dir == null ? EnumFacing.UP : dir;
    }

    public String toString() {
        return super.toString() + " { design:" + this.design + " }, { primary:" + this.primaryMaterial + " }, { secondary:" + this.secondaryMaterial + " }, { rotation:" + this.rotation + " }, { facing:" + this.facing + " }";
    }

    public IDesign getDesign() {
        return this.design;
    }

    public IDesignMaterial getPrimaryMaterial() {
        return this.primaryMaterial;
    }

    public IDesignMaterial getSecondaryMaterial() {
        return this.secondaryMaterial;
    }

    public int getPrimaryColour() {
        return this.getPrimaryMaterial().getColour();
    }

    public int getSecondaryColour() {
        return this.getSecondaryMaterial().getColour();
    }

    EnumFacing getRotation(EnumFacing dir, EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.Y) {
            switch (dir) {
                case EAST: {
                    return EnumFacing.NORTH;
                }
                case NORTH: {
                    return EnumFacing.WEST;
                }
                case SOUTH: {
                    return EnumFacing.EAST;
                }
                case WEST: {
                    return EnumFacing.SOUTH;
                }
            }
            return dir;
        }
        if (axis == EnumFacing.Axis.X) {
            switch (dir) {
                case EAST: {
                    return EnumFacing.UP;
                }
                case UP: {
                    return EnumFacing.WEST;
                }
                case WEST: {
                    return EnumFacing.DOWN;
                }
                case DOWN: {
                    return EnumFacing.EAST;
                }
            }
            return dir;
        }
        switch (dir) {
            case SOUTH: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.NORTH;
            }
            case NORTH: {
                return EnumFacing.DOWN;
            }
            case DOWN: {
                return EnumFacing.SOUTH;
            }
        }
        return dir;
    }

    public EnumFacing getRotation(EnumFacing facing, EnumFacing axis) {
        return this.getNewFacing(ROTATION_MATRIX[axis.ordinal()][facing.ordinal()]);
    }

    public ILayout getLayout(EnumFacing facing) {
        ILayout layout;
        block72: {
            EnumFacing adjustedFacing;
            facing = adjustedFacing = this.getRotation(facing, EnumFacing.DOWN);
            switch (this.getFacing()) {
                case DOWN: {
                    adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.EAST);
                    adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.EAST);
                    break;
                }
                case EAST: {
                    adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.EAST);
                    adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.NORTH);
                    break;
                }
                case NORTH: {
                    adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.EAST);
                    adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.SOUTH);
                    adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.SOUTH);
                    break;
                }
                case SOUTH: {
                    adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.EAST);
                    break;
                }
                case WEST: {
                    adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.EAST);
                    adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.SOUTH);
                    break;
                }
            }
            for (int i = 0; i < this.rotation; ++i) {
                adjustedFacing = this.getRotation(adjustedFacing, EnumFacing.DOWN);
            }
            layout = null;
            switch (adjustedFacing) {
                case EAST: {
                    layout = this.getDesign().getEastPattern();
                    break;
                }
                case NORTH: {
                    layout = this.getDesign().getNorthPattern();
                    break;
                }
                case SOUTH: {
                    layout = this.getDesign().getSouthPattern();
                    break;
                }
                case WEST: {
                    layout = this.getDesign().getWestPattern();
                    break;
                }
                case DOWN: {
                    layout = this.getDesign().getBottomPattern();
                    break;
                }
                default: {
                    layout = this.getDesign().getTopPattern();
                }
            }
            block14 : switch (this.getFacing()) {
                case UP: {
                    switch (facing) {
                        case UP: {
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateRight();
                            }
                            break block14;
                        }
                        case DOWN: {
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateLeft();
                            }
                        }
                    }
                    break;
                }
                case DOWN: {
                    switch (facing) {
                        case UP: {
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateLeft();
                            }
                            break block14;
                        }
                        case DOWN: {
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateRight();
                            }
                            break block14;
                        }
                        case EAST: 
                        case NORTH: 
                        case SOUTH: 
                        case WEST: {
                            layout = layout.rotateRight().rotateRight();
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (facing) {
                        case SOUTH: 
                        case UP: 
                        case DOWN: {
                            layout = layout.rotateRight();
                            break;
                        }
                        case NORTH: {
                            layout = layout.rotateLeft().flipHorizontal();
                            break;
                        }
                        case WEST: {
                            layout = layout.rotateLeft().rotateLeft();
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateLeft();
                            }
                            break block14;
                        }
                        case EAST: {
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateRight();
                            }
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (facing) {
                        case NORTH: {
                            layout = layout.rotateRight();
                            break;
                        }
                        case SOUTH: 
                        case UP: {
                            layout = layout.rotateLeft();
                            break;
                        }
                        case DOWN: {
                            layout = layout.rotateRight().flipVertical();
                            break;
                        }
                        case EAST: {
                            layout = layout.rotateLeft().rotateLeft();
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateLeft();
                            }
                            break block14;
                        }
                        case WEST: {
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateRight();
                            }
                        }
                    }
                    break;
                }
                case NORTH: {
                    switch (facing) {
                        case DOWN: {
                            layout = layout.flipHorizontal();
                            break;
                        }
                        case WEST: {
                            layout = layout.rotateLeft();
                            break;
                        }
                        case EAST: {
                            layout = layout.rotateRight();
                            break;
                        }
                        case NORTH: {
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateRight();
                            }
                            break block14;
                        }
                        case SOUTH: {
                            layout = layout.rotateLeft().rotateLeft();
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateLeft();
                            }
                        }
                    }
                    break;
                }
                case SOUTH: {
                    switch (facing) {
                        case UP: {
                            layout = layout.rotateRight().rotateRight();
                            break block14;
                        }
                        case DOWN: {
                            layout = layout.flipVertical();
                            break block14;
                        }
                        case WEST: {
                            layout = layout.rotateRight();
                            break block14;
                        }
                        case EAST: {
                            layout = layout.rotateLeft();
                            break block14;
                        }
                        case NORTH: {
                            layout = layout.rotateLeft().rotateLeft();
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateLeft();
                            }
                            break block72;
                        }
                        case SOUTH: {
                            for (int j = 0; j < this.rotation; ++j) {
                                layout = layout.rotateRight();
                            }
                        }
                    }
                }
            }
        }
        return layout;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getPrimarySprite(IDesignSystem system, EnumFacing facing) {
        ILayout layout = this.getLayout(facing);
        return layout.getPrimarySprite(system);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSecondarySprite(IDesignSystem system, EnumFacing facing) {
        ILayout layout = this.getLayout(facing);
        return layout.getSecondarySprite(system);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite(IDesignSystem system, boolean secondary, EnumFacing facing) {
        return secondary ? this.getSecondarySprite(system, facing) : this.getPrimarySprite(system, facing);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void rotate(EnumFacing facing, ItemStack hammer, EntityPlayer player, World world, BlockPos pos) {
        IToolHammer hammerI = (IToolHammer)hammer.func_77973_b();
        if (player.func_70093_af()) {
            if (this.panel) {
                EnumFacing newFacing = this.getFacing();
                while ((newFacing = this.getNewFacing(newFacing.ordinal() + 1)) != this.getFacing() && !DesignHelper.isValidPanelPlacement((IBlockAccess)world, pos, newFacing)) {
                }
                if (newFacing != this.getFacing()) {
                    hammerI.onHammerUsed(hammer, player);
                }
                this.setFacing(newFacing);
            } else {
                if (facing != this.getFacing()) {
                    hammerI.onHammerUsed(hammer, player);
                }
                this.setFacing(facing);
            }
        } else {
            ++this.rotation;
            hammerI.onHammerUsed(hammer, player);
        }
        if (this.rotation > 3) {
            this.rotation = 0;
        }
        if (this.rotation < 0) {
            this.rotation = 3;
        }
    }

    private EnumFacing getNewFacing(int index) {
        if (index >= 0 && index < EnumFacing.field_82609_l.length) {
            return EnumFacing.field_82609_l[index];
        }
        return EnumFacing.DOWN;
    }

    public int getBlockMetadata(IDesignSystem system) {
        return DesignHelper.getBlockMetadata(system, this);
    }

    public int getItemMetadata(IDesignSystem system) {
        return DesignHelper.getItemMetadata(system, this);
    }

    public void setPanel() {
        this.panel = true;
    }

    public String getString() {
        String type = "";
        type = this.getPrimaryMaterial() != this.getSecondaryMaterial() ? this.getPrimaryMaterial().getDesignMaterialName() + " and " + this.getSecondaryMaterial().getDesignMaterialName() : this.getPrimaryMaterial().getDesignMaterialName();
        return super.toString() + ' ' + '{' + type + ' ' + this.getDesign().getName() + ' ' + (this.panel ? "Panel" : "Tile") + ", Facing:" + this.getFacing() + ", Rotation:" + this.getRotation() + '}';
    }
}

