/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.gui;

import binnie.core.api.gui.IArea;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.resource.textures.CraftGUITexture;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlBiomes
extends Control
implements ITooltip {
    private final List<Integer> tolerated = new ArrayList<Integer>();

    public ControlBiomes(IWidget parent, int x, int y, int width, int height) {
        super(parent, x, y, width * 16, height * 16);
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        int y;
        if (this.tolerated.isEmpty()) {
            return;
        }
        int x = (int)((float)this.getRelativeMousePosition().xPos() / 16.0f);
        int i = x + (y = (int)((float)this.getRelativeMousePosition().yPos() / 16.0f)) * 8;
        if (i >= this.tolerated.size()) {
            return;
        }
        Biome biome = Biome.func_150568_d((int)this.tolerated.get(i));
        if (biome != null) {
            tooltip.add(biome.func_185359_l());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
        for (int i = 0; i < this.tolerated.size(); ++i) {
            int x = i % 8 * 16;
            int y = i / 8 * 16;
            if (Biome.func_150568_d((int)i) != null) {
                // empty if block
            }
            CraftGUI.RENDER.texture((Object)CraftGUITexture.BUTTON, (IArea)new Area(x, y, 16, 16));
        }
    }

    public void setSpecies(IAlleleBeeSpecies species) {
        this.tolerated.clear();
        IBeeGenome genome = BeeManager.beeRoot.templateAsGenome(BeeManager.beeRoot.getTemplate((IAlleleSpecies)species));
        IBee bee = BeeManager.beeRoot.getBee(genome);
    }
}

