/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.blocks;

import binnie.extratrees.blocks.property.PropertyETTypeFruit;
import binnie.extratrees.genetics.ETTreeDefinition;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IModelManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.arboriculture.ModuleArboriculture;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class BlockETDefaultLeavesFruit
extends BlockAbstractLeaves {
    private static final int VARIANTS_PER_BLOCK = 4;
    protected final int blockNumber;

    public static List<BlockETDefaultLeavesFruit> create() {
        ArrayList<BlockETDefaultLeavesFruit> blocks = new ArrayList<BlockETDefaultLeavesFruit>();
        int blockCount = PropertyETTypeFruit.getBlockCount(4);
        for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
            final PropertyETTypeFruit variant = PropertyETTypeFruit.create("variant", blockNumber, 4);
            BlockETDefaultLeavesFruit block = new BlockETDefaultLeavesFruit(blockNumber){

                @Override
                public PropertyETTypeFruit getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    public BlockETDefaultLeavesFruit(int blockNumber) {
        this.blockNumber = blockNumber;
        PropertyETTypeFruit variant = this.getVariant();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)variant, (Comparable)variant.getFirstType()).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
        this.func_149663_c("leaves.default." + blockNumber);
        this.setRegistryName(new ResourceLocation("extratrees", "leaves.default.fruit." + blockNumber));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getVariant(), field_176236_b, field_176237_a});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack mainHand = player.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offHand = player.func_184586_b(EnumHand.OFF_HAND);
        if (mainHand.func_190926_b() && offHand.func_190926_b()) {
            ITree tree = this.getTree((IBlockAccess)world, pos);
            if (tree == null) {
                return false;
            }
            IFruitProvider fruitProvider = tree.getGenome().getFruitProvider();
            NonNullList products = tree.produceStacks(world, pos, fruitProvider.getRipeningPeriod());
            world.func_180501_a(pos, ModuleArboriculture.getBlocks().getDefaultLeaves(tree.getIdent()), 2);
            for (ItemStack fruit : products) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)fruit);
            }
            return true;
        }
        return false;
    }

    protected void getLeafDrop(NonNullList<ItemStack> drops, World world, @Nullable GameProfile playerProfile, BlockPos pos, float saplingModifier, int fortune) {
        ITree tree = this.getTree((IBlockAccess)world, pos);
        if (tree == null) {
            return;
        }
        List saplings = tree.getSaplings(world, playerProfile, pos, saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            drops.add((Object)TreeManager.treeRoot.getMemberStack((IIndividual)sapling, (ISpeciesType)EnumGermlingType.SAPLING));
        }
        ITreeGenome genome = tree.getGenome();
        IFruitProvider fruitProvider = genome.getFruitProvider();
        if (fruitProvider.isFruitLeaf(genome, world, pos)) {
            NonNullList produceStacks = tree.produceStacks(world, pos, Integer.MAX_VALUE);
            drops.addAll((Collection)produceStacks);
        }
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public abstract PropertyETTypeFruit getVariant();

    @Nullable
    public PropertyETTypeFruit.LeafVariant getLeafVariant(IBlockState blockState) {
        if (blockState.func_177230_c() == this) {
            return (PropertyETTypeFruit.LeafVariant)blockState.func_177229_b((IProperty)this.getVariant());
        }
        return null;
    }

    public int func_180651_a(IBlockState state) {
        PropertyETTypeFruit.LeafVariant treeDefinition = this.getLeafVariant(state);
        if (treeDefinition == null) {
            return 0;
        }
        return treeDefinition.metadata - this.blockNumber * 4;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)this.getTreeType(meta)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = this.func_180651_a(state);
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public PropertyETTypeFruit.LeafVariant getTreeType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.blockNumber * 4;
        return PropertyETTypeFruit.getVariant(variantMeta);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        PropertyETTypeFruit.LeafVariant type = this.getTreeType(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)type);
    }

    protected ITree getTree(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        PropertyETTypeFruit.LeafVariant treeDefinition = this.getLeafVariant(blockState);
        if (treeDefinition != null) {
            return treeDefinition.definition.getIndividual();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (IBlockState state : this.field_176227_L.func_177619_a()) {
            int meta = this.func_176201_c(state);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("extratrees:leaves.default.fruit." + this.blockNumber, "inventory"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        PropertyETTypeFruit.LeafVariant variant = this.getLeafVariant(state);
        ETTreeDefinition treeDefinition = variant != null ? variant.definition : ETTreeDefinition.OrchardApple;
        ITreeGenome genome = treeDefinition.getGenome();
        if (tintIndex == 2) {
            IFruitProvider fruitProvider = genome.getFruitProvider();
            return fruitProvider.getDecorativeColor();
        }
        ILeafSpriteProvider spriteProvider = genome.getPrimary().getLeafSpriteProvider();
        return spriteProvider.getColor(false);
    }
}

