/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.integration.jei.multifence;

import binnie.extratrees.blocks.decor.MultiFenceRecipePattern;
import binnie.extratrees.wood.WoodManager;
import binnie.extratrees.wood.planks.IPlankType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class MultiFenceRecipeSizeWrapper
implements IRecipeWrapper {
    @Nullable
    private final IPlankType plankType;
    @Nullable
    private final IPlankType plankTypeSecond;
    private final MultiFenceRecipePattern pattern;
    private final String[] recipePattern;

    public MultiFenceRecipeSizeWrapper(MultiFenceRecipePattern pattern) {
        this(pattern, null, null);
    }

    public MultiFenceRecipeSizeWrapper(MultiFenceRecipePattern pattern, @Nullable IPlankType plankType) {
        this(pattern, plankType, null);
    }

    public MultiFenceRecipeSizeWrapper(MultiFenceRecipePattern pattern, @Nullable IPlankType plankType, @Nullable IPlankType plankTypeSecond) {
        this.pattern = pattern;
        String recipe = pattern.getPattern();
        this.recipePattern = new String[3];
        this.recipePattern[0] = recipe.substring(0, 3);
        this.recipePattern[1] = recipe.substring(3, 6);
        this.recipePattern[2] = recipe.substring(6);
        this.plankType = plankType;
        this.plankTypeSecond = plankTypeSecond;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> planks;
        int typeCount = this.pattern.getTypeCount();
        NonNullList types = NonNullList.func_191196_a();
        if (this.plankType != null) {
            types.add(Collections.singletonList(this.plankType.getStack(false)));
        } else {
            planks = new ArrayList<ItemStack>(WoodManager.getAllPlankStacks().values());
            Collections.shuffle(planks);
            types.add(planks);
        }
        if (typeCount > 1) {
            if (this.plankTypeSecond != null) {
                types.add(Collections.singletonList(this.plankTypeSecond.getStack(false)));
            } else {
                planks = this.plankType != null ? new ArrayList<ItemStack>(WoodManager.getAllPlankStacks(this.plankType)) : new ArrayList<ItemStack>(WoodManager.getAllPlankStacks().values());
                Collections.shuffle(planks);
                types.add(planks);
            }
        } else {
            types.add(types.get(0));
        }
        NonNullList itemInputs = NonNullList.func_191197_a((int)9, (Object)NonNullList.func_191196_a());
        for (int p = 0; p < 3; ++p) {
            String pattern = this.recipePattern[p];
            for (int index = 0; index < 3; ++index) {
                char c = pattern.charAt(index);
                if (c == '0') {
                    itemInputs.set(p * 3 + index, types.get(0));
                    continue;
                }
                if (c == '1') {
                    itemInputs.set(p * 3 + index, types.get(1));
                    continue;
                }
                itemInputs.set(p * 3 + index, NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a));
            }
        }
        ArrayList itemOutputs = new ArrayList();
        int size = typeCount > 1 || this.plankType == null ? ((List)types.get(1)).size() : 1;
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        itemOutputs.add(outputs);
        for (int i = 0; i < size; ++i) {
            IPlankType secondary;
            IPlankType primary = this.plankType;
            if (primary == null) {
                ItemStack item = (ItemStack)((List)types.get(0)).get(i);
                primary = WoodManager.getPlankType(item);
            }
            if ((secondary = this.plankTypeSecond) == null) {
                ItemStack itemSecond = (ItemStack)((List)types.get(1)).get(i);
                secondary = WoodManager.getPlankType(itemSecond);
            }
            outputs.add(this.pattern.createFence(primary, secondary));
        }
        ingredients.setOutputLists(ItemStack.class, itemOutputs);
        ingredients.setInputLists(ItemStack.class, (List)itemInputs);
    }
}

