/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.util.FluidStackUtil;
import binnie.core.util.UniqueFluidStackSet;
import binnie.core.util.UniqueItemStackSet;
import binnie.genetics.Genetics;
import binnie.genetics.api.analyst.IAnalystIcons;
import binnie.genetics.api.analyst.IAnalystManager;
import binnie.genetics.api.analyst.IAnalystPagePlugin;
import binnie.genetics.api.analyst.IBehaviourPlugin;
import binnie.genetics.api.analyst.IBiologyPlugin;
import binnie.genetics.api.analyst.IClimatePlugin;
import binnie.genetics.api.analyst.IProducePlugin;
import binnie.genetics.gui.analyst.AnalystPageBehaviour;
import binnie.genetics.gui.analyst.AnalystPageBiology;
import binnie.genetics.gui.analyst.tree.AnalystPageClimate;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnalystManager
implements IAnalystManager {
    private final Collection<IAnalystPagePlugin> analystPagePlugins = new ArrayList<IAnalystPagePlugin>();
    private final Collection<IProducePlugin> producePlugins = new ArrayList<IProducePlugin>();

    @Override
    public void registerAnalystPagePlugin(IAnalystPagePlugin<?> analystPageFactory) {
        this.analystPagePlugins.add(analystPageFactory);
    }

    @Override
    @Nullable
    public <T extends IIndividual> IAnalystPagePlugin<T> getAnalystPagePlugin(T individual) {
        for (IAnalystPagePlugin plugin : this.analystPagePlugins) {
            if (!plugin.handles(individual)) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public void registerProducePlugin(IProducePlugin producePlugin) {
        this.producePlugins.add(producePlugin);
    }

    @Override
    public Collection<IProducePlugin> getProducePlugins() {
        return Collections.unmodifiableCollection(this.producePlugins);
    }

    @Override
    public NonNullList<ItemStack> getAllProducts(ItemStack key) {
        NonNullList products = NonNullList.func_191196_a();
        for (IProducePlugin plugin : this.getProducePlugins()) {
            plugin.getItems(key, (NonNullList<ItemStack>)products);
        }
        return products;
    }

    @Override
    public NonNullList<FluidStack> getAllFluidsFromItems(Collection<ItemStack> itemStacks) {
        NonNullList allFluids = NonNullList.func_191196_a();
        for (ItemStack itemStack : itemStacks) {
            for (IProducePlugin producePlugin : this.getProducePlugins()) {
                producePlugin.getFluids(itemStack, (NonNullList<FluidStack>)allFluids);
            }
        }
        return FluidStackUtil.removeEqualFluids((Collection<FluidStack>)allFluids);
    }

    @Override
    public NonNullList<FluidStack> getAllFluidsFromFluids(Collection<FluidStack> fluidStacks) {
        NonNullList allFluids = NonNullList.func_191196_a();
        for (FluidStack itemStack : fluidStacks) {
            for (IProducePlugin producePlugin : Genetics.getAnalystManager().getProducePlugins()) {
                producePlugin.getFluids(itemStack, (NonNullList<FluidStack>)allFluids);
            }
        }
        return FluidStackUtil.removeEqualFluids((Collection<FluidStack>)allFluids);
    }

    @Override
    public Collection<ItemStack> getAllProductsAndFluids(Collection<ItemStack> collection) {
        UniqueItemStackSet products = new UniqueItemStackSet();
        for (ItemStack itemStack : collection) {
            products.addAll(this.getAllProducts(itemStack));
        }
        UniqueItemStackSet products2 = new UniqueItemStackSet();
        for (Object stack2 : products) {
            products2.addAll(this.getAllProducts((ItemStack)stack2));
        }
        UniqueItemStackSet uniqueItemStackSet = new UniqueItemStackSet();
        for (ItemStack stack3 : products2) {
            uniqueItemStackSet.addAll(this.getAllProducts(stack3));
        }
        products.addAll(products2);
        products.addAll(uniqueItemStackSet);
        UniqueFluidStackSet allFluids = new UniqueFluidStackSet();
        allFluids.addAll(this.getAllFluidsFromItems(collection));
        UniqueFluidStackSet fluids2 = new UniqueFluidStackSet();
        fluids2.addAll(this.getAllFluidsFromFluids(allFluids));
        UniqueFluidStackSet fluids3 = new UniqueFluidStackSet();
        fluids3.addAll(this.getAllFluidsFromFluids(fluids2));
        allFluids.addAll(fluids2);
        allFluids.addAll(fluids3);
        for (FluidStack fluid : allFluids) {
            ItemStack container = FluidStackUtil.getContainer(fluid);
            if (container == null) continue;
            products.add(container);
        }
        return products;
    }

    @Override
    public IAnalystIcons getIcons() {
        return Genetics.getIcons();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public <T extends IIndividual> ITitledWidget createClimatePage(IWidget parent, IArea area, T ind, IClimatePlugin<T> plugin) {
        return new AnalystPageClimate<T>(parent, area, ind, plugin);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public <T extends IIndividual> ITitledWidget createBiologyPage(IWidget parent, IArea area, T ind, IBiologyPlugin<T> plugin) {
        return new AnalystPageBiology<T>(parent, area, ind, plugin, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public <T extends IIndividual> ITitledWidget createBehaviorPage(IWidget parent, IArea area, T ind, IBehaviourPlugin<T> behaviourPlugin) {
        return new AnalystPageBehaviour<T>(parent, area, ind, behaviourPlugin);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int drawRefined(IWidget parent, String string, int y, Collection<ItemStack> products) {
        new ControlTextCentered(parent, y, string).setColor(parent.getColor());
        y += 10;
        int maxBiomePerLine = (parent.getWidth() + 2 - 16) / 18;
        int biomeListX = (parent.getWidth() - (Math.min(maxBiomePerLine, products.size()) * 18 - 2)) / 2;
        int dx = 0;
        int dy = 0;
        for (ItemStack soilStack : products) {
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)soilStack);
            soilStack.func_190920_e(1);
            ControlItemDisplay display = new ControlItemDisplay(parent, biomeListX + dx, y + dy, soilStack, fluid == null);
            if (fluid != null) {
                display.addTooltip(fluid.getLocalizedName());
            }
            dx += 18;
        }
        if (dx != 0) {
            dy += 18;
        }
        return y += dy;
    }
}

