/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.ByteBufAdapterRegistry;
import info.loenwind.autoconfig.factory.IByteBufAdapter;
import info.loenwind.autoconfig.util.NullHelper;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ByteBufAdapters {
    public static final IByteBufAdapter<Integer> INTEGER = ByteBufAdapters.register(new IByteBufAdapter<Integer>(){

        @Override
        public void saveValue(ByteBuf buf, @Nonnull Integer value) {
            buf.writeInt(value.intValue());
        }

        @Override
        public Integer readValue(ByteBuf buf) {
            return buf.readInt();
        }

        @Override
        public String getName() {
            return "I";
        }
    });
    public static final IByteBufAdapter<Double> DOUBLE = ByteBufAdapters.register(new IByteBufAdapter<Double>(){

        @Override
        public void saveValue(ByteBuf buf, @Nonnull Double value) {
            buf.writeDouble(value.doubleValue());
        }

        @Override
        public Double readValue(ByteBuf buf) {
            return buf.readDouble();
        }

        @Override
        public String getName() {
            return "D";
        }
    });
    public static final IByteBufAdapter<Float> FLOAT = ByteBufAdapters.register(new IByteBufAdapter<Float>(){

        @Override
        public void saveValue(ByteBuf buf, @Nonnull Float value) {
            buf.writeFloat(value.floatValue());
        }

        @Override
        public Float readValue(ByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public String getName() {
            return "F";
        }
    });
    public static final IByteBufAdapter<Boolean> BOOLEAN = ByteBufAdapters.register(new IByteBufAdapter<Boolean>(){

        @Override
        public void saveValue(ByteBuf buf, @Nonnull Boolean value) {
            buf.writeBoolean(value.booleanValue());
        }

        @Override
        public Boolean readValue(ByteBuf buf) {
            return buf.readBoolean();
        }

        @Override
        public String getName() {
            return "B";
        }
    });
    public static final IByteBufAdapter<String> STRING = ByteBufAdapters.register(new IByteBufAdapter<String>(){

        @Override
        public void saveValue(ByteBuf buf, @Nonnull String value) {
            byte[] vbytes = value.getBytes(Charset.forName("UTF-8"));
            if (vbytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("String too long");
            }
            buf.writeShort(vbytes.length);
            buf.writeBytes(vbytes);
        }

        @Override
        public String readValue(ByteBuf buf) {
            short len = buf.readShort();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes, 0, (int)len);
            return new String(bytes, Charset.forName("UTF-8"));
        }

        @Override
        public String getName() {
            return "S";
        }
    });
    public static final IByteBufAdapter<String> STRING127 = ByteBufAdapters.register(new IByteBufAdapter<String>(){

        @Override
        public void saveValue(ByteBuf buf, @Nonnull String value) {
            byte[] vbytes = value.getBytes(Charset.forName("UTF-8"));
            if (vbytes.length > 127) {
                throw new RuntimeException("String too long");
            }
            buf.writeByte(vbytes.length);
            buf.writeBytes(vbytes);
        }

        @Override
        public String readValue(ByteBuf buf) {
            byte len = buf.readByte();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes, 0, (int)len);
            return new String(bytes, Charset.forName("UTF-8"));
        }

        @Override
        public String getName() {
            return "7";
        }
    });
    public static final IByteBufAdapter<Boolean> ENDMARKER = ByteBufAdapters.register(new IByteBufAdapter<Boolean>(){

        @Override
        public void saveValue(ByteBuf buf, @Nonnull Boolean value) {
            buf.writeByte(0);
        }

        @Override
        @Nullable
        public Boolean readValue(ByteBuf buf) {
            buf.markReaderIndex();
            byte val = buf.readByte();
            if (val == 0) {
                return true;
            }
            buf.resetReaderIndex();
            return null;
        }

        @Override
        public String getName() {
            return "X";
        }
    });
    public static final IByteBufAdapter<Boolean> NONE = ByteBufAdapters.register(new IByteBufAdapter<Boolean>(){

        @Override
        public void saveValue(ByteBuf buf, @Nonnull Boolean value) {
        }

        @Override
        @Nullable
        public Boolean readValue(ByteBuf buf) {
            return null;
        }

        @Override
        public String getName() {
            return "N";
        }
    });
    public static final IByteBufAdapter<Fluid> FLUID = ByteBufAdapters.register(new IByteBufAdapter<Fluid>(){

        @Override
        public void saveValue(ByteBuf buf, @Nonnull Fluid value) {
            byte[] vbytes = NullHelper.first(FluidRegistry.getFluidName((Fluid)value), "").getBytes(Charset.forName("UTF-8"));
            if (vbytes.length > 127) {
                throw new RuntimeException("Fluid name too long");
            }
            buf.writeByte(vbytes.length);
            buf.writeBytes(vbytes);
        }

        @Override
        @Nullable
        public Fluid readValue(ByteBuf buf) {
            byte len = buf.readByte();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes, 0, (int)len);
            return FluidRegistry.getFluid((String)new String(bytes, Charset.forName("UTF-8")));
        }

        @Override
        public String getName() {
            return "L";
        }
    });

    public static <P> IByteBufAdapter<P> register(IByteBufAdapter<P> adapter) {
        ByteBufAdapterRegistry.register(adapter);
        return adapter;
    }
}

