/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.data;

import crafttweaker.api.data.IData;
import crafttweaker.api.data.IDataConverter;
import crafttweaker.api.data.IllegalDataException;
import java.util.List;
import java.util.Map;

public class DataShort
implements IData {
    private final short value;

    public DataShort(short value) {
        this.value = value;
    }

    @Override
    public boolean asBool() {
        throw new IllegalDataException("Cannot cast a short to a bool");
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return this.value;
    }

    @Override
    public int asInt() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public String asString() {
        return Short.toString(this.value);
    }

    @Override
    public List<IData> asList() {
        return null;
    }

    @Override
    public Map<String, IData> asMap() {
        return null;
    }

    @Override
    public byte[] asByteArray() {
        return null;
    }

    @Override
    public int[] asIntArray() {
        return null;
    }

    @Override
    public IData getAt(int i) {
        throw new UnsupportedOperationException("A short is not indexable");
    }

    @Override
    public void setAt(int i, IData value) {
        throw new UnsupportedOperationException("A short is not indexable");
    }

    @Override
    public IData memberGet(String name) {
        throw new UnsupportedOperationException("A short is not indexable");
    }

    @Override
    public void memberSet(String name, IData data) {
        throw new UnsupportedOperationException("A short is not indexable");
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public boolean contains(IData data) {
        return data.asShort() == this.value;
    }

    @Override
    public boolean equals(IData data) {
        return this.value == data.asShort();
    }

    @Override
    public int compareTo(IData data) {
        return Short.compare(this.value, data.asShort());
    }

    @Override
    public IData immutable() {
        return this;
    }

    @Override
    public IData update(IData data) {
        return data;
    }

    @Override
    public <T> T convert(IDataConverter<T> converter) {
        return converter.fromShort(this.value);
    }

    @Override
    public IData add(IData other) {
        return new DataShort((short)(this.value + other.asShort()));
    }

    @Override
    public IData sub(IData other) {
        return new DataShort((short)(this.value - other.asShort()));
    }

    @Override
    public IData mul(IData other) {
        return new DataShort((short)(this.value * other.asShort()));
    }

    @Override
    public IData div(IData other) {
        return new DataShort((short)(this.value / other.asShort()));
    }

    @Override
    public IData mod(IData other) {
        return new DataShort((short)(this.value % other.asShort()));
    }

    @Override
    public IData and(IData other) {
        return new DataShort((short)(this.value & other.asShort()));
    }

    @Override
    public IData or(IData other) {
        return new DataShort((short)(this.value | other.asShort()));
    }

    @Override
    public IData xor(IData other) {
        return new DataShort((short)(this.value ^ other.asShort()));
    }

    @Override
    public IData neg() {
        return new DataShort(-this.value);
    }

    @Override
    public IData not() {
        return new DataShort(~this.value);
    }

    @Override
    public String toString() {
        return this.asString() + " as short";
    }
}

