/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.liquid;

import crafttweaker.api.data.IData;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IItemTransformerNew;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.liquid.MCLiquidDefinition;
import java.util.Collections;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class MCLiquidStack
implements ILiquidStack {
    private final FluidStack stack;
    private final IItemTransformerNew transformerNew;
    private IData tag;

    public MCLiquidStack(FluidStack stack) {
        this(stack, null, null);
    }

    private MCLiquidStack(FluidStack stack, IData tag, IItemTransformerNew transformerNew) {
        this.stack = stack;
        this.tag = tag;
        this.transformerNew = transformerNew;
    }

    @Override
    public ILiquidDefinition getDefinition() {
        return new MCLiquidDefinition(this.stack.getFluid());
    }

    @Override
    public String getName() {
        return this.stack.getFluid().getName();
    }

    @Override
    public String getDisplayName() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public int getAmount() {
        return this.stack.amount;
    }

    @Override
    public IData getTag() {
        if (this.tag == null) {
            if (this.stack.tag == null) {
                return null;
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.tag, true);
        }
        return this.tag;
    }

    @Override
    public ILiquidStack withTag(IData data) {
        FluidStack result = new FluidStack(this.stack.getFluid(), this.stack.amount);
        result.tag = (NBTTagCompound)NBTConverter.from(data);
        return new MCLiquidStack(result, data.immutable(), this.transformerNew);
    }

    @Override
    public ILiquidStack withAmount(int amount) {
        FluidStack result = new FluidStack(this.stack.getFluid(), amount);
        result.tag = this.stack.tag;
        return new MCLiquidStack(result, this.tag, this.transformerNew);
    }

    @Override
    public int getLuminosity() {
        return this.stack.getFluid().getLuminosity(this.stack);
    }

    @Override
    public int getDensity() {
        return this.stack.getFluid().getDensity(this.stack);
    }

    @Override
    public int getTemperature() {
        return this.stack.getFluid().getTemperature(this.stack);
    }

    @Override
    public int getViscosity() {
        return this.stack.getFluid().getViscosity(this.stack);
    }

    @Override
    public boolean isGaseous() {
        return this.stack.getFluid().isGaseous(this.stack);
    }

    @Override
    public Object getInternal() {
        return this.stack;
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public List<IItemStack> getItems() {
        IItemStack stack = CraftTweakerMC.getIItemStack(FluidUtil.getFilledBucket((FluidStack)this.stack.copy()));
        if (stack != null) {
            String name = String.format("Any container with %s * %d", this.stack.getLocalizedName(), this.getAmount());
            return Collections.singletonList(stack.withDisplayName(name));
        }
        return Collections.emptyList();
    }

    @Override
    public IItemStack[] getItemArray() {
        IItemStack stack = CraftTweakerMC.getIItemStack(FluidUtil.getFilledBucket((FluidStack)this.stack.copy()));
        if (stack != null) {
            String name = String.format("Any container with %s * %d", this.stack.getLocalizedName(), this.getAmount());
            return new IItemStack[]{stack.withDisplayName(name)};
        }
        return new IItemStack[0];
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.singletonList(this);
    }

    @Override
    public IIngredient amount(int amount) {
        return this.withAmount(amount);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public IIngredient transformNew(IItemTransformerNew transformer) {
        return new MCLiquidStack(this.stack, this.tag, transformer);
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        throw new UnsupportedOperationException("Liquid stack can't have conditions");
    }

    @Override
    public IIngredient marked(String mark) {
        throw new UnsupportedOperationException("Liquid stack can't be marked");
    }

    @Override
    public boolean matches(IItemStack item) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)CraftTweakerMC.getItemStack(item));
        return fluidStack != null && this.matches(CraftTweakerMC.getILiquidStack(fluidStack));
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        return this.matches(item);
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return liquid != null && this.getDefinition().equals(liquid.getDefinition()) && this.getAmount() <= liquid.getAmount();
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        if (ingredient == null) {
            return false;
        }
        for (ILiquidStack liquid : ingredient.getLiquids()) {
            if (this.matches(liquid)) continue;
            return false;
        }
        return !ingredient.getLiquids().isEmpty();
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return item;
    }

    @Override
    public IItemStack applyNewTransform(IItemStack item) {
        if (this.transformerNew != null) {
            return this.transformerNew.transform(item);
        }
        ItemStack itemStack = CraftTweakerMC.getItemStack(item);
        Item item1 = itemStack.func_77973_b();
        if (item1 instanceof ItemBucket || item1 instanceof UniversalBucket || item1 == Items.field_151117_aB || item1 == Items.field_151131_as || item1 == Items.field_151129_at || item1 == ForgeModContainer.getInstance().universalBucket) {
            return new MCItemStack(new ItemStack(Items.field_151133_ar, 1));
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return CraftTweakerMC.getIItemStack(ForgeHooks.getContainerItem((ItemStack)itemStack));
        }
        fluidHandler.drain(this.stack.copy(), true);
        return MCItemStack.createNonCopy(itemStack);
    }

    @Override
    public boolean hasNewTransformers() {
        return true;
    }

    @Override
    public boolean hasTransformers() {
        return false;
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        throw new UnsupportedOperationException("Liquid stack can't have transformers");
    }

    public String toString() {
        return "<liquid:" + this.getName() + ">";
    }

    @Override
    public String toCommandString() {
        return this.toString();
    }
}

