/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.core;

import info.tehnut.soulshardsrespawn.block.BlockSoulCage;
import info.tehnut.soulshardsrespawn.block.TileEntitySoulCage;
import info.tehnut.soulshardsrespawn.core.data.Tier;
import info.tehnut.soulshardsrespawn.core.util.EnchantmentSoulStealer;
import info.tehnut.soulshardsrespawn.item.ItemEnum;
import info.tehnut.soulshardsrespawn.item.ItemSoulShard;
import info.tehnut.soulshardsrespawn.item.ItemVileSword;
import info.tehnut.soulshardsrespawn.item.Materials;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="soulshardsrespawn")
@GameRegistry.ObjectHolder(value="soulshardsrespawn")
public class RegistrarSoulShards {
    public static final Block SOUL_CAGE = Blocks.field_150350_a;
    public static final Item VILE_SWORD = Items.field_190931_a;
    public static final Item SOUL_SHARD = Items.field_190931_a;
    public static final Item MATERIALS = Items.field_190931_a;
    public static final Enchantment SOUL_STEALER = Enchantments.field_185312_x;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new BlockSoulCage().setRegistryName("soul_cage")});
        GameRegistry.registerTileEntity(TileEntitySoulCage.class, (String)"soulshardsrespawn:soul_cage");
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Tier.readTiers();
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemBlock(SOUL_CAGE).setRegistryName(SOUL_CAGE.getRegistryName()), (Item)new ItemVileSword().setRegistryName("vile_sword"), (Item)new ItemSoulShard().setRegistryName("soul_shard"), (Item)new ItemEnum<Materials>(Materials.class).setRegistryName("materials")});
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{(Enchantment)new EnchantmentSoulStealer().setRegistryName("soul_stealer")});
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        OreDictionary.registerOre((String)"dustCorrupted", (ItemStack)Materials.CORRUPTED_ESSENCE.getStack());
        OreDictionary.registerOre((String)"ingotCorrupted", (ItemStack)Materials.CORRUPTED_INGOT.getStack());
        OreDictionary.registerOre((String)"dustVile", (ItemStack)Materials.VILE_DUST.getStack());
        GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150425_aM), (ItemStack)Materials.VILE_DUST.getStack(), (float)0.75f);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)SOUL_SHARD, (int)0, (ModelResourceLocation)new ModelResourceLocation(SOUL_SHARD.getRegistryName(), "inventory"));
        for (Materials material : Materials.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)MATERIALS, (int)material.ordinal(), (ModelResourceLocation)new ModelResourceLocation("soulshardsrespawn:" + material.getInternalName(), "inventory"));
        }
        ModelLoader.setCustomModelResourceLocation((Item)VILE_SWORD, (int)0, (ModelResourceLocation)new ModelResourceLocation(VILE_SWORD.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)SOUL_CAGE), (int)0, (ModelResourceLocation)new ModelResourceLocation(SOUL_CAGE.getRegistryName(), "active=true,powered=false"));
    }
}

