/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.platforms.client.gui.Textures;
import shetiphian.platforms.common.block.BlockPlatform;
import shetiphian.platforms.common.entity.EntityGuiItem;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.helpers.PlatformHelper;
import shetiphian.platforms.common.network.NetworkHandler;
import shetiphian.platforms.common.network.PacketPlatformSelect;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;

public class GuiPlatformSelect
extends GuiScreen {
    private final EntityPlayer player;
    private final World world;
    private final BlockPos pos;
    private EntityGuiItem displayItem = null;
    private List<ItemStack> types;
    private int start;
    private int index;
    private int listSize;
    private int xSize = 182;
    private int ySize = 110;
    private int guiLeft;
    private int guiTop;

    public GuiPlatformSelect(EntityPlayer player, World world, BlockPos pos, TileEntityTypeBase tile) {
        this.player = player;
        this.world = world;
        this.pos = pos;
        this.index = this.start = (int)tile.getType();
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(world.func_180495_p(pos));
        int counter = 0;
        switch (platform.TYPE) {
            case FRAME: 
            case PLATFORMER: {
                counter = 1;
                break;
            }
            case FLAT: 
            case FLOOR: {
                counter = 15;
                break;
            }
            case RAIL: 
            case RISE: {
                counter = 4;
                break;
            }
            case RAMP: {
                counter = 3;
            }
        }
        if (counter < 1) {
            throw new Error("Unexpected Platform");
        }
        String[] textures = tile.getTextures();
        ItemStack basePlatform = PlatformHelper.getStack(platform, textures[0], textures[1]);
        this.types = new ArrayList<ItemStack>();
        for (int type = 0; type < counter; ++type) {
            ItemStack stack = basePlatform.func_77946_l();
            NBTTagCompound nbtTag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            nbtTag.func_74768_a("type", type);
            stack.func_77982_d(nbtTag);
            this.types.add(stack);
        }
        this.listSize = this.types.size();
        this.updateDisplayItem();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    private void updateDisplayItem() {
        this.displayItem = new EntityGuiItem(this.world, 0.0, 0.0, 0.0, this.types.get(this.index));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.field_146297_k.func_110434_K().func_110577_a(Textures.WRENCH.get());
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 182, 110);
        int centerX = this.guiLeft + this.xSize / 2;
        int centerY = this.guiTop + this.ySize / 2;
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(true);
        this.func_73732_a(this.field_146289_q, this.index + 1 + " / " + this.listSize, centerX, centerY + 5, -30720);
        this.func_73732_a(this.field_146289_q, Localization.get((String)"gui.platform_select.back.txt"), centerX, centerY + 14, -7631989);
        this.func_73732_a(this.field_146289_q, Localization.get((String)"gui.platform_select.next.txt"), centerX, centerY + 22, -7631989);
        this.func_73732_a(this.field_146289_q, Localization.get((String)"gui.platform_select.first.txt"), centerX, centerY + 30, -7631989);
        this.func_73732_a(this.field_146289_q, Localization.get((String)"gui.platform_select.save.txt"), centerX, centerY + 38, -7631989);
        this.field_146289_q.func_78264_a(unicode);
        GuiFunctions.exitDrawTextureStateWithBlend();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(this.guiLeft + 91), (float)(this.guiTop + 52), (float)50.0f);
        GlStateManager.func_179152_a((float)-90.0f, (float)90.0f, (float)90.0f);
        GlStateManager.func_179114_b((float)130.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(System.currentTimeMillis() / 30L % 360L), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        try {
            this.field_146297_k.func_175598_ae().func_188391_a((Entity)this.displayItem, 0.0, 0.01, 0.0, 0.0f, 0.0f, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GlStateManager.func_179114_b((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        RenderHelper.func_74520_c();
        int count = this.types.size();
        if (count > 1) {
            this.field_146296_j.func_180450_b(this.types.get(this.getOffsetIndex(-1)), this.guiLeft + 52, this.guiTop + 34);
            this.field_146296_j.func_180450_b(this.types.get(this.getOffsetIndex(1)), this.guiLeft + 114, this.guiTop + 34);
        }
        if (count > 4) {
            this.field_146296_j.func_180450_b(this.types.get(this.getOffsetIndex(-2)), this.guiLeft + 34, this.guiTop + 34);
            this.field_146296_j.func_180450_b(this.types.get(this.getOffsetIndex(2)), this.guiLeft + 132, this.guiTop + 34);
        }
        if (count > 6) {
            this.field_146296_j.func_180450_b(this.types.get(this.getOffsetIndex(-3)), this.guiLeft + 16, this.guiTop + 34);
            this.field_146296_j.func_180450_b(this.types.get(this.getOffsetIndex(3)), this.guiLeft + 150, this.guiTop + 34);
        }
    }

    private int getOffsetIndex(int offset) {
        int value = this.index + offset;
        int max = this.listSize - 1;
        return value < 0 ? max : (value > max ? 0 : value);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getDWheel();
        if (wheel < 0) {
            this.index = this.getOffsetIndex(1);
            this.updateDisplayItem();
        } else if (wheel > 0) {
            this.index = this.getOffsetIndex(-1);
            this.updateDisplayItem();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        switch (mouseButton) {
            case 1: {
                this.setPlatform();
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.close();
        }
        switch (keyCode) {
            case 28: {
                this.setPlatform();
                break;
            }
            case 203: 
            case 208: {
                this.index = this.getOffsetIndex(-1);
                this.updateDisplayItem();
                break;
            }
            case 200: 
            case 205: {
                this.index = this.getOffsetIndex(1);
                this.updateDisplayItem();
                break;
            }
            case 57: {
                this.index = this.start;
                this.updateDisplayItem();
            }
        }
    }

    private void setPlatform() {
        NetworkHandler.sendToServer(new PacketPlatformSelect(this.pos, this.index));
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = this.player.func_184586_b(hand);
            Set toolTypes = stack.func_77973_b().getToolClasses(stack);
            if (toolTypes == null || !toolTypes.contains("wrench")) continue;
            this.player.func_184609_a(hand);
            break;
        }
        this.close();
    }

    private void close() {
        this.field_146297_k.func_147108_a(null);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }
}

