/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.platforms.client.model.ModelPlatform_Base;
import shetiphian.platforms.common.block.BlockPlatform;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformTypes;

@SideOnly(value=Side.CLIENT)
public class ModelPlatform_Composite
implements IBakedModel {
    private static ItemCameraTransforms[] transforms;
    private static String[] flatTypes;
    private static String[] rampTypes;
    private static String[] railTypes;

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        for (IBakedModel model : this.handleBlockState(state)) {
            quads.addAll(model.func_188616_a(state, side, rand));
        }
        return quads;
    }

    private List<IBakedModel> handleBlockState(IBlockState state) {
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        Object object = null;
        if (state instanceof IExtendedBlockState) {
            object = ((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockPlatform.EIBS);
        }
        if (object instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
            TileEntityPlatformTypes.TileEntityPlatformFlat tile = (TileEntityPlatformTypes.TileEntityPlatformFlat)((Object)object);
            this.addParts_Flat(list, tile.getType(), tile.getTextures(), tile.getFacing(), tile.getRail());
        } else if (object instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
            TileEntityPlatformTypes.TileEntityPlatformRamp tile = (TileEntityPlatformTypes.TileEntityPlatformRamp)((Object)object);
            this.addParts_Ramp(list, tile.getType(), tile.getTextures(), tile.getFacing(), tile.getRail(), tile.getAltSupport());
        } else if (object instanceof TileEntityPlatformTypes.TileEntityPlatformFloor) {
            TileEntityPlatformTypes.TileEntityPlatformFloor tile = (TileEntityPlatformTypes.TileEntityPlatformFloor)((Object)object);
            this.addParts_Floor(list, tile.getType(), tile.getTextures(), tile.getFacing(), tile.getAltSupport());
        } else if (object instanceof TileEntityPlatformTypes.TileEntityPlatformFrame) {
            TileEntityPlatformTypes.TileEntityPlatformFrame tile = (TileEntityPlatformTypes.TileEntityPlatformFrame)((Object)object);
            String[] textures = tile.getTextures();
            this.add(list, "frame-bar", textures[1], tile.getFacing());
            this.add(list, "frame-support", textures[0], tile.getFacing());
            EnumHelper.EnumPlatformTorch torch = tile.getTorchType();
            if (torch != null && torch != EnumHelper.EnumPlatformTorch.NONE) {
                this.add(list, "frame-brazier-base", "brazier", tile.getFacing());
                this.add(list, "frame-brazier-fill", torch.name().toLowerCase(), tile.getFacing());
            }
        } else if (object instanceof TileEntityPlatformTypes.TileEntityPlatformRise) {
            TileEntityPlatformTypes.TileEntityPlatformRise tile = (TileEntityPlatformTypes.TileEntityPlatformRise)((Object)object);
            if (tile.isLinkedToRamp()) {
                list.clear();
            } else {
                this.addParts_Rise(list, tile.getType(), tile.getTextures(), tile.getFacing(), tile.isRail(), tile.isLinkedToFloor());
            }
        }
        return list;
    }

    private void addParts_Flat(List<IBakedModel> list, int type, String[] textures, EnumFacing facing, EnumHelper.EnumPlatform railType) {
        String base = (type = this.zero_over(type, flatTypes.length)) == 0 || type == 1 || type == 10 ? "normal" : "corner";
        this.add(list, "flat-platform-" + base + "-" + flatTypes[type], textures[1], facing);
        this.add(list, "flat-base-" + base, textures[0], type > 1 && type < 6 ? facing.func_176734_d() : facing);
        if (railType != null && type < 10) {
            type = type >= 6 && type <= 9 ? 3 : (type >= 2 && type <= 5 ? 2 : type);
            String rail = railType.TYPE == EnumHelper.EnumPlatformType.RISE ? "rise" : "rail";
            this.add(list, rail + "-bar-" + base + "-" + railTypes[type], textures[3], facing);
            this.add(list, rail + "-support-" + base + "-" + railTypes[type], textures[2], facing);
        }
    }

    private void addParts_Ramp(List<IBakedModel> list, int type, String[] textures, EnumFacing facing, EnumHelper.EnumPlatform railType, int support) {
        type = this.zero_over(type, rampTypes.length);
        this.add(list, "ramp-platform-" + rampTypes[type], textures[1], facing);
        this.add(list, "ramp-base", textures[0], facing);
        if (support % 3 < 2) {
            this.add(list, "ramp-support-" + (support % 3 == 1 ? "single" : "dual"), textures[0], facing);
        }
        if (support > 2) {
            this.add(list, "ramp-support-beam-" + rampTypes[type] + (type == 2 ? "" : (support % 3 != 1 ? "-sb" : "-lb")), textures[0], facing);
        }
        if (railType != null) {
            String rail = railType.TYPE == EnumHelper.EnumPlatformType.RISE ? "rise" : "rail";
            this.add(list, "ramp-" + rail + "-bar-" + rampTypes[type], textures[3], facing);
            this.add(list, "ramp-" + rail + "-support-" + rampTypes[type], textures[2], facing);
        }
    }

    private void addParts_Floor(List<IBakedModel> list, int type, String[] textures, EnumFacing facing, int support) {
        String variant;
        if ((type = this.zero_over(type, flatTypes.length)) == 0 || type == 1 || type == 10) {
            variant = "normal-" + flatTypes[type];
            this.add(list, "floor-platform-" + variant, textures[1], facing);
        } else {
            this.add(list, "floor-platform-corner-" + flatTypes[type], textures[1], facing);
            variant = "corner-" + (type < 6 ? "inside" : (type < 11 ? "outside" : "middle"));
        }
        this.add(list, "floor-base-" + variant, textures[0], type > 1 && type < 6 ? facing.func_176734_d() : facing);
        if (support == 0) {
            this.add(list, "floor-support-legs", textures[0], facing);
        } else if (support == 1) {
            if (type < 10) {
                if (type > 1 && type < 6) {
                    this.add(list, "floor-support-post-" + variant, textures[0], facing.func_176734_d());
                } else {
                    this.add(list, "floor-support-post-" + variant, textures[0], type > 1 && type < 6 ? facing.func_176734_d() : facing);
                }
            } else {
                this.add(list, "floor-support-post-extension", textures[0], facing);
            }
        }
    }

    private void addParts_Rise(List<IBakedModel> list, int type, String[] textures, EnumFacing facing, boolean isRail, boolean isLinkedToFloor) {
        if (type < 4) {
            type = this.zero_over(type, railTypes.length);
            String base = (type < 2 ? "normal" : "corner") + "-" + railTypes[type];
            String variant = isRail ? "rail" : "rise";
            this.add(list, variant + "-bar-" + base, textures[1], facing);
            this.add(list, variant + "-support-" + base + (isLinkedToFloor ? "-extended" : ""), textures[0], facing);
        }
    }

    private int zero_over(int number, int max) {
        return number > 0 && number < max ? number : 0;
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Lists.newArrayList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                return ModelPlatform_Composite.this.handleItemState(stack);
            }
        };
    }

    private IBakedModel handleItemState(ItemStack stack) {
        if (transforms == null) {
            this.buildTransforms();
        }
        String key1 = "default";
        String key2 = "default";
        int type = -1;
        NBTTagCompound nbtTag = stack.func_77978_p();
        if (nbtTag != null) {
            key1 = nbtTag.func_74764_b("texture1") ? nbtTag.func_74779_i("texture1") : " default";
            key2 = nbtTag.func_74764_b("texture2") ? nbtTag.func_74779_i("texture2") : " default";
            type = nbtTag.func_74764_b("type") ? nbtTag.func_74762_e("type") : -1;
        }
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        int variant = stack.func_77952_i() % 10;
        switch (variant) {
            case 0: {
                if (type < 0) {
                    this.add(list, "flat-platform-normal-left", key2, EnumFacing.NORTH);
                    this.add(list, "flat-base-normal", key1, EnumFacing.NORTH);
                    break;
                }
                this.addParts_Flat(list, type, new String[]{key1, key2}, EnumFacing.NORTH, null);
                break;
            }
            case 1: {
                if (type < 0) {
                    this.add(list, "ramp-platform-left", key2, EnumFacing.NORTH);
                    this.add(list, "ramp-base", key1, EnumFacing.NORTH);
                    this.add(list, "ramp-support-single", key1, EnumFacing.NORTH);
                    break;
                }
                this.addParts_Ramp(list, type, new String[]{key1, key2}, EnumFacing.NORTH, null, 1);
                break;
            }
            case 2: {
                if (type < 0) {
                    this.add(list, "floor-platform-normal-left", key2, EnumFacing.NORTH);
                    this.add(list, "floor-base-normal-left", key1, EnumFacing.NORTH);
                    break;
                }
                this.addParts_Floor(list, type, new String[]{key1, key2}, EnumFacing.NORTH, 0);
                break;
            }
            case 3: {
                this.add(list, "frame-bar", key2, EnumFacing.NORTH);
                this.add(list, "frame-support", key1, EnumFacing.NORTH);
                break;
            }
            case 4: {
                if (type < 0) {
                    this.add(list, "rise-bar-normal-left", key2, EnumFacing.NORTH);
                    this.add(list, "rise-support-normal-left", key1, EnumFacing.NORTH);
                    break;
                }
                this.addParts_Rise(list, type, new String[]{key1, key2}, EnumFacing.NORTH, false, false);
                break;
            }
            case 5: {
                if (type < 0) {
                    this.add(list, "rail-bar-normal-left", key2, EnumFacing.NORTH);
                    this.add(list, "rail-support-normal-left", key1, EnumFacing.NORTH);
                    break;
                }
                this.addParts_Rise(list, type, new String[]{key1, key2}, EnumFacing.NORTH, true, false);
            }
        }
        return new AssembledBakedModel(list, new ItemCameraTransforms[]{transforms[variant]});
    }

    private void add(List<IBakedModel> list, String part, String texture, EnumFacing facing) {
        Map map;
        if (!ModelPlatform_Base.CACHE.contains((Object)part, (Object)texture)) {
            ModelPlatform_Base.buildCache(part, texture);
        }
        if ((map = (Map)ModelPlatform_Base.CACHE.get((Object)part, (Object)texture)) == null) {
            map = (Map)ModelPlatform_Base.CACHE.get((Object)part, (Object)"default");
        }
        if (map == null) {
            return;
        }
        list.add((IBakedModel)map.get(facing));
    }

    private void buildTransforms() {
        transforms = new ItemCameraTransforms[6];
        ModelPlatform_Composite.transforms[0] = this.getFlatTransforms();
        ModelPlatform_Composite.transforms[1] = this.getRampTransforms();
        ModelPlatform_Composite.transforms[2] = this.getFloorTransforms();
        ModelPlatform_Composite.transforms[3] = this.getFrameTransforms();
        ModelPlatform_Composite.transforms[4] = this.getRiseTransforms();
        ModelPlatform_Composite.transforms[5] = this.getRailTransforms();
    }

    private ItemCameraTransforms getFlatTransforms() {
        ItemTransformVec3f thirdperson_left = this.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 3.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f thirdperson_right = this.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 3.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f firstperson_left = this.create(0.0f, 135.0f, 0.0f, 0.0f, 5.25f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f firstperson_right = this.create(0.0f, 135.0f, 0.0f, 0.0f, 5.25f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f gui = this.create(30.0f, 315.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.625f, 0.625f, 0.625f);
        ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
        ItemTransformVec3f fixed = this.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
        return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
    }

    private ItemCameraTransforms getRampTransforms() {
        ItemTransformVec3f thirdperson_left = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f thirdperson_right = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f firstperson_left = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f firstperson_right = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f gui = this.create(30.0f, 315.0f, 0.0f, 0.0f, 0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
        ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
        ItemTransformVec3f fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
        return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
    }

    private ItemCameraTransforms getFloorTransforms() {
        ItemTransformVec3f thirdperson_left = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f thirdperson_right = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f firstperson_left = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f firstperson_right = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f gui = this.create(30.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
        ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
        ItemTransformVec3f fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
        return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
    }

    private ItemCameraTransforms getFrameTransforms() {
        ItemTransformVec3f thirdperson_left = this.create(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f thirdperson_right = this.create(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f firstperson_left = this.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f firstperson_right = this.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f gui = this.create(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
        ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
        ItemTransformVec3f fixed = this.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
        return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
    }

    private ItemCameraTransforms getRiseTransforms() {
        ItemTransformVec3f thirdperson_left = this.create(75.0f, 45.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f thirdperson_right = this.create(75.0f, 225.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f firstperson_left = this.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f firstperson_right = this.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f gui = this.create(30.0f, 315.0f, 0.0f, 0.75f, -0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
        ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
        ItemTransformVec3f fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, -2.75f, 0.5f, 0.5f, 0.5f);
        return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
    }

    private ItemCameraTransforms getRailTransforms() {
        ItemTransformVec3f thirdperson_left = this.create(75.0f, 45.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f thirdperson_right = this.create(75.0f, 225.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
        ItemTransformVec3f firstperson_left = this.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f firstperson_right = this.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
        ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f gui = this.create(30.0f, 315.0f, 0.0f, 0.75f, -0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
        ItemTransformVec3f ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
        ItemTransformVec3f fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, -2.75f, 0.5f, 0.5f, 0.5f);
        return new ItemCameraTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
    }

    private ItemTransformVec3f create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
        Vector3f rotation = new Vector3f(rX, rY, rZ);
        Vector3f translation = new Vector3f(tX, tY, tZ);
        translation.scale(0.0625f);
        translation.x = MathHelper.func_76131_a((float)translation.x, (float)-1.5f, (float)1.5f);
        translation.y = MathHelper.func_76131_a((float)translation.y, (float)-1.5f, (float)1.5f);
        translation.z = MathHelper.func_76131_a((float)translation.z, (float)-1.5f, (float)1.5f);
        Vector3f scale = new Vector3f(sX, sY, sZ);
        scale.x = MathHelper.func_76131_a((float)scale.x, (float)-4.0f, (float)4.0f);
        scale.y = MathHelper.func_76131_a((float)scale.y, (float)-4.0f, (float)4.0f);
        scale.z = MathHelper.func_76131_a((float)scale.z, (float)-4.0f, (float)4.0f);
        return new ItemTransformVec3f(rotation, translation, scale);
    }

    static {
        flatTypes = new String[]{"right", "left", "inside-dark_dark", "inside-dark_light", "inside-light_dark", "inside-light_light", "outside-dark_dark", "outside-dark_light", "outside-light_dark", "outside-light_light", "middle", "middle-dark_dark", "middle-dark_light", "middle-light_dark", "middle-light_light"};
        rampTypes = new String[]{"right", "left", "middle"};
        railTypes = new String[]{"right", "left", "inside", "outside", "middle"};
    }
}

