/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.helpers;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.platforms.common.helpers.EnumHelper;

public class CraftHelper {
    private static Set<MaterialId> PLANKS = CraftHelper.generatePlankLookup();
    private static Set<MaterialId> STONE = CraftHelper.generateStoneLookup();
    private static Set<MaterialId> USER_PLANKS;
    private static Set<MaterialId> USER_STONE;
    private static Map<MaterialId, MaterialId> METAL;

    public static ItemStack[] getCraftStacks(EnumHelper.EnumPlatformMaterial material, ItemStack floor_brace, ItemStack joist_strut) {
        ItemStack[] ret = new ItemStack[]{floor_brace, joist_strut};
        if (ret[0] == null) {
            ret[0] = material.getDefaultItem();
        }
        if (ret[1] == null) {
            ret[1] = material.getDefaultItem();
        }
        return ret;
    }

    public static boolean isPlanks(ItemStack stack) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mId = MaterialId.getFor(stack, check == 1);
            if (!CraftHelper.isPlanks(mId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlanks(MaterialId mId) {
        return mId != null && (PLANKS.contains(mId) || USER_PLANKS.contains(mId));
    }

    public static boolean isStone(ItemStack stack) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mId = MaterialId.getFor(stack, check == 1);
            if (!CraftHelper.isStone(mId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStone(MaterialId mId) {
        return mId != null && (STONE.contains(mId) || USER_STONE.contains(mId));
    }

    public static boolean isMetal(ItemStack stack) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mId = MaterialId.getFor(stack, check == 1);
            if (!CraftHelper.isMetal(mId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMetal(MaterialId mId) {
        return mId != null && METAL.containsKey(mId);
    }

    public static boolean isRegistered(ItemStack stack) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mId = MaterialId.getFor(stack, check == 1);
            if (!CraftHelper.isRegistered(mId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRegistered(MaterialId mId) {
        return CraftHelper.isPlanks(mId) || CraftHelper.isStone(mId) || CraftHelper.isMetal(mId);
    }

    @Nonnull
    public static ItemStack getDeconStack(String mId) {
        MaterialId materialId = MaterialId.getFor(mId);
        if (materialId != null) {
            ItemStack deconStack = materialId.toStack();
            if (!(deconStack.func_190926_b() || CraftHelper.isPlanks(deconStack) || CraftHelper.isStone(deconStack))) {
                deconStack = CraftHelper.getIngot(deconStack);
            }
            return deconStack;
        }
        return ItemStack.field_190927_a;
    }

    public static MaterialId getOreMaterial(MaterialId mId) {
        return METAL.get(mId);
    }

    @Nonnull
    public static ItemStack getOreBlock(ItemStack ingot) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mId = MaterialId.getFor(ingot, check == 1);
            if (mId == null || !METAL.containsKey(mId)) continue;
            return METAL.get(mId).toStack();
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack getIngot(ItemStack oreBlock) {
        for (int check = 0; check < 2; ++check) {
            MaterialId mIdBlock = MaterialId.getFor(oreBlock, check == 1);
            if (mIdBlock == null) continue;
            for (Map.Entry<MaterialId, MaterialId> entry : METAL.entrySet()) {
                if (!entry.getValue().equals(mIdBlock)) continue;
                return entry.getKey().toStack();
            }
        }
        return ItemStack.field_190927_a;
    }

    private static Set<MaterialId> generatePlankLookup() {
        HashSet<MaterialId> set = new HashSet<MaterialId>();
        for (ItemStack stack : OreDictionary.getOres((String)"plankWood")) {
            CraftHelper.addStack(set, stack);
        }
        return set;
    }

    private static Set<MaterialId> generateStoneLookup() {
        String[] oreIds;
        OreDictionary.registerOre((String)"sandstone", (ItemStack)new ItemStack(Blocks.field_180395_cM, 1, Short.MAX_VALUE));
        HashSet<MaterialId> set = new HashSet<MaterialId>();
        for (String oreId : oreIds = new String[]{"stone", "cobblestone", "sandstone"}) {
            for (ItemStack stack : OreDictionary.getOres((String)oreId)) {
                CraftHelper.addStack(set, stack);
            }
        }
        return set;
    }

    public static void generateUserPlanks(ArrayList<ItemStack> list) {
        if (USER_PLANKS != null) {
            USER_PLANKS.clear();
        } else {
            USER_PLANKS = new HashSet<MaterialId>();
        }
        for (ItemStack stack : list) {
            CraftHelper.addStack(USER_PLANKS, stack);
        }
    }

    public static void generateUserStone(ArrayList<ItemStack> list) {
        if (USER_STONE != null) {
            USER_STONE.clear();
        } else {
            USER_STONE = new HashSet<MaterialId>();
        }
        for (ItemStack stack : list) {
            CraftHelper.addStack(USER_STONE, stack);
        }
    }

    private static void addStack(Set<MaterialId> set, ItemStack stack) {
        MaterialId mId = MaterialId.getFor(stack, stack.func_77952_i() == Short.MAX_VALUE);
        if (mId != null) {
            set.add(mId);
        }
    }

    private static Map<MaterialId, MaterialId> generateIngotLookup() {
        String[] names;
        HashMap<MaterialId, MaterialId> mapLookup = new HashMap<MaterialId, MaterialId>();
        for (String name : names = OreDictionary.getOreNames()) {
            if (Strings.isNullOrEmpty((String)name) || !name.startsWith("ingot")) continue;
            CraftHelper.processOreName(mapLookup, name);
        }
        return mapLookup;
    }

    private static void processOreName(Map<MaterialId, MaterialId> mapLookup, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return;
        }
        ArrayList unmappedIngots = new ArrayList(OreDictionary.getOres((String)name));
        if (unmappedIngots.isEmpty()) {
            return;
        }
        NonNullList listOreBlocks = OreDictionary.getOres((String)(name = name.replace("ingot", "block")));
        if (listOreBlocks == null || listOreBlocks.isEmpty()) {
            return;
        }
        MaterialId mIdDefaultBlock = null;
        ArrayList<ItemStack> mappedIngots = new ArrayList<ItemStack>();
        for (ItemStack oreStack : listOreBlocks) {
            MaterialId mIdBlock = MaterialId.getFor(oreStack, false);
            if (mIdBlock == null) continue;
            if (mIdDefaultBlock == null) {
                mIdDefaultBlock = mIdBlock;
            }
            for (ItemStack ingot : unmappedIngots) {
                MaterialId mIdIngot = MaterialId.getFor(ingot, false);
                if (mIdIngot == null || listOreBlocks.size() != 1 && !mIdBlock.compareMod(mIdIngot)) continue;
                mapLookup.put(mIdIngot, mIdBlock);
                mappedIngots.add(ingot);
            }
            unmappedIngots.removeAll(mappedIngots);
            mappedIngots.clear();
        }
        for (ItemStack ingot : unmappedIngots) {
            MaterialId mIdIngot = MaterialId.getFor(ingot, false);
            if (mIdIngot == null) continue;
            mapLookup.put(mIdIngot, mIdDefaultBlock);
        }
    }

    static {
        METAL = CraftHelper.generateIngotLookup();
    }

    public static class MaterialId {
        private final String mod;
        private final String name;
        private final int meta;

        private MaterialId(String mod, String name, int meta) {
            this.mod = mod;
            this.name = name;
            this.meta = meta;
        }

        static MaterialId getFor(ItemStack stack, boolean anyMeta) {
            if (stack != null) {
                ResourceLocation location = stack.func_77973_b().getRegistryName();
                return location == null ? null : new MaterialId(location.func_110624_b(), location.func_110623_a(), anyMeta ? Short.MAX_VALUE : stack.func_77952_i());
            }
            return null;
        }

        public static MaterialId getFor(String id) {
            String mod = "minecraft";
            String name = "planks";
            int meta = 0;
            if (!Strings.isNullOrEmpty((String)id)) {
                String[] split = id.split(":");
                try {
                    mod = split[0];
                    name = split[1];
                    meta = Integer.parseInt(split[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new MaterialId(mod, name, meta);
        }

        boolean compareMod(MaterialId mId) {
            return mId.mod.equals(this.mod);
        }

        @Nonnull
        public ItemStack toStack() {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.mod, this.name));
            return item == null ? ItemStack.field_190927_a : new ItemStack(item, 1, this.meta);
        }

        public String toString() {
            return this.mod + ":" + this.name + ":" + this.meta;
        }

        public boolean equals(Object obj) {
            return obj instanceof MaterialId && obj.toString().equals(this.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

