/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.RegistryHandler;
import de.ellpeck.actuallyadditions.mod.booklet.InitBooklet;
import de.ellpeck.actuallyadditions.mod.config.ConfigurationHandler;
import de.ellpeck.actuallyadditions.mod.crafting.CrusherCrafting;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.entity.InitEntities;
import de.ellpeck.actuallyadditions.mod.event.CommonEvents;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.gen.AAWorldGen;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.ItemCoffee;
import de.ellpeck.actuallyadditions.mod.items.lens.LensMining;
import de.ellpeck.actuallyadditions.mod.items.lens.LensRecipeHandler;
import de.ellpeck.actuallyadditions.mod.items.lens.Lenses;
import de.ellpeck.actuallyadditions.mod.material.InitArmorMaterials;
import de.ellpeck.actuallyadditions.mod.material.InitToolMaterials;
import de.ellpeck.actuallyadditions.mod.misc.BannerHelper;
import de.ellpeck.actuallyadditions.mod.misc.DungeonLoot;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.LaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.MethodHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.proxy.IProxy;
import de.ellpeck.actuallyadditions.mod.recipe.EmpowererHandler;
import de.ellpeck.actuallyadditions.mod.recipe.HairyBallHandler;
import de.ellpeck.actuallyadditions.mod.recipe.TreasureChestHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.update.UpdateChecker;
import de.ellpeck.actuallyadditions.mod.util.compat.CompatUtil;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="actuallyadditions", name="Actually Additions", version="1.12.2-r150", guiFactory="de.ellpeck.actuallyadditions.mod.config.GuiFactory", dependencies="required:forge@[14.23.5.2836,);before:craftingtweaks;after:fastbench@[1.3.2,)", acceptedMinecraftVersions="[1.12.2]")
public class ActuallyAdditions {
    public static final String MODID = "actuallyadditions";
    public static final String NAME = "Actually Additions";
    public static final String VERSION = "1.12.2-r150";
    public static final String GUIFACTORY = "de.ellpeck.actuallyadditions.mod.config.GuiFactory";
    public static final String DEPS = "required:forge@[14.23.5.2836,);before:craftingtweaks;after:fastbench@[1.3.2,)";
    public static final boolean DEOBF = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    @Mod.Instance
    public static ActuallyAdditions INSTANCE;
    @SidedProxy(clientSide="de.ellpeck.actuallyadditions.mod.proxy.ClientProxy", serverSide="de.ellpeck.actuallyadditions.mod.proxy.ServerProxy")
    public static IProxy PROXY;
    public static final Logger LOGGER;
    public static boolean commonCapsLoaded;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.info("Starting PreInitialization Phase...");
        ActuallyAdditionsAPI.methodHandler = new MethodHandler();
        ActuallyAdditionsAPI.connectionHandler = new LaserRelayConnectionHandler();
        Lenses.init();
        InitBooklet.preInit();
        CompatUtil.registerCraftingTweaks();
        commonCapsLoaded = Loader.isModLoaded((String)"commoncapabilities");
        MinecraftForge.EVENT_BUS.register((Object)new RegistryHandler());
        new ConfigurationHandler(event.getSuggestedConfigurationFile());
        PacketHandler.init();
        InitToolMaterials.init();
        InitArmorMaterials.init();
        InitFluids.init();
        new UpdateChecker();
        PROXY.preInit(event);
        LOGGER.info("PreInitialization Finished.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LOGGER.info("Starting Initialization Phase...");
        BannerHelper.init();
        GuiHandler.init();
        AAWorldGen gen = new AAWorldGen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)gen, (int)10000);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)gen);
        TileEntityBase.init();
        MinecraftForge.EVENT_BUS.register((Object)new CommonEvents());
        MinecraftForge.EVENT_BUS.register((Object)new DungeonLoot());
        InitEntities.init();
        PROXY.init(event);
        RegistryHandler.BLOCKS_TO_REGISTER.clear();
        LOGGER.info("Initialization Finished.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LOGGER.info("Starting PostInitialization Phase...");
        ItemCoffee.initIngredients();
        CrusherCrafting.init();
        HairyBallHandler.init();
        TreasureChestHandler.init();
        LensRecipeHandler.init();
        EmpowererHandler.init();
        LensMining.init();
        InitBooklet.postInit();
        PROXY.postInit(event);
        ConfigurationHandler.redefineConfigs();
        LOGGER.info("PostInitialization Finished.");
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        World world;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (world = server.func_130014_f_()) != null && !world.field_72995_K) {
            WorldData.get(world, true).func_76185_a();
        }
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        WorldData.clear();
    }

    static {
        LOGGER = LogManager.getLogger((String)NAME);
        FluidRegistry.enableUniversalBucket();
    }
}

