/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntValues;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBatteryBox;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBioReactor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCanolaPress;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoalGenerator;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCompost;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDirectionalBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDropper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEmpowerer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEnergizer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEnervator;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFarmer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFeeder;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFermentingBarrel;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFireworkBox;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFishingNet;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFluidCollector;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFluidPlacer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFurnaceSolar;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGiantChest;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGiantChestLarge;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGiantChestMedium;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGrinder;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGrinderDouble;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityHeatCollector;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInputter;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInputterAdvanced;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemRepairer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemViewer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemViewerHopping;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyAdvanced;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyExtreme;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayFluids;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItemWhitelist;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLavaFactoryController;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLeafGenerator;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityMiner;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityOilGenerator;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomBooster;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomEnergyface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomItemface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomLiquiface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomPlacer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomRedstoneface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPlacer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPlayerInterface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityRangedCollector;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityShockSuppressor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntitySmileyCloud;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityXPSolidifier;
import de.ellpeck.actuallyadditions.mod.util.VanillaPacketDispatcher;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityBase
extends TileEntity
implements ITickable {
    public final String name;
    public boolean isRedstonePowered;
    public boolean isPulseMode;
    public boolean stopFromDropping;
    protected int ticksElapsed;
    protected TileEntity[] tilesAround = new TileEntity[6];
    protected boolean hasSavedDataOnChangeOrWorldStart;
    private boolean shareEnergy = this instanceof ISharingEnergyProvider;
    private boolean shareFluid = this instanceof ISharingFluidHandler;

    public TileEntityBase(String name) {
        this.name = name;
    }

    public static void init() {
        ActuallyAdditions.LOGGER.info("Registering TileEntities...");
        TileEntityBase.register(TileEntityCompost.class);
        TileEntityBase.register(TileEntityFeeder.class);
        TileEntityBase.register(TileEntityGiantChest.class);
        TileEntityBase.register(TileEntityGiantChestMedium.class);
        TileEntityBase.register(TileEntityGiantChestLarge.class);
        TileEntityBase.register(TileEntityGrinder.class);
        TileEntityBase.register(TileEntityFurnaceDouble.class);
        TileEntityBase.register(TileEntityInputter.class);
        TileEntityBase.register(TileEntityFishingNet.class);
        TileEntityBase.register(TileEntityFurnaceSolar.class);
        TileEntityBase.register(TileEntityHeatCollector.class);
        TileEntityBase.register(TileEntityItemRepairer.class);
        TileEntityBase.register(TileEntityBreaker.class);
        TileEntityBase.register(TileEntityDropper.class);
        TileEntityBase.register(TileEntityInputterAdvanced.class);
        TileEntityBase.register(TileEntityPlacer.class);
        TileEntityBase.register(TileEntityGrinderDouble.class);
        TileEntityBase.register(TileEntityCanolaPress.class);
        TileEntityBase.register(TileEntityFermentingBarrel.class);
        TileEntityBase.register(TileEntityOilGenerator.class);
        TileEntityBase.register(TileEntityCoalGenerator.class);
        TileEntityBase.register(TileEntityPhantomItemface.class);
        TileEntityBase.register(TileEntityPhantomLiquiface.class);
        TileEntityBase.register(TileEntityPhantomEnergyface.class);
        TileEntityBase.register(TileEntityPlayerInterface.class);
        TileEntityBase.register(TileEntityPhantomPlacer.class);
        TileEntityBase.register(TileEntityPhantomBreaker.class);
        TileEntityBase.register(TileEntityFluidCollector.class);
        TileEntityBase.register(TileEntityFluidPlacer.class);
        TileEntityBase.register(TileEntityLavaFactoryController.class);
        TileEntityBase.register(TileEntityCoffeeMachine.class);
        TileEntityBase.register(TileEntityPhantomBooster.class);
        TileEntityBase.register(TileEntityEnergizer.class);
        TileEntityBase.register(TileEntityEnervator.class);
        TileEntityBase.register(TileEntityXPSolidifier.class);
        TileEntityBase.register(TileEntitySmileyCloud.class);
        TileEntityBase.register(TileEntityLeafGenerator.class);
        TileEntityBase.register(TileEntityDirectionalBreaker.class);
        TileEntityBase.register(TileEntityRangedCollector.class);
        TileEntityBase.register(TileEntityAtomicReconstructor.class);
        TileEntityBase.register(TileEntityMiner.class);
        TileEntityBase.register(TileEntityFireworkBox.class);
        TileEntityBase.register(TileEntityPhantomRedstoneface.class);
        TileEntityBase.register(TileEntityLaserRelayItem.class);
        TileEntityBase.register(TileEntityLaserRelayEnergy.class);
        TileEntityBase.register(TileEntityLaserRelayEnergyAdvanced.class);
        TileEntityBase.register(TileEntityLaserRelayEnergyExtreme.class);
        TileEntityBase.register(TileEntityLaserRelayItemWhitelist.class);
        TileEntityBase.register(TileEntityItemViewer.class);
        TileEntityBase.register(TileEntityDisplayStand.class);
        TileEntityBase.register(TileEntityShockSuppressor.class);
        TileEntityBase.register(TileEntityEmpowerer.class);
        TileEntityBase.register(TileEntityLaserRelayFluids.class);
        TileEntityBase.register(TileEntityBioReactor.class);
        TileEntityBase.register(TileEntityFarmer.class);
        TileEntityBase.register(TileEntityItemViewerHopping.class);
        TileEntityBase.register(TileEntityBatteryBox.class);
    }

    private static void register(Class<? extends TileEntityBase> tileClass) {
        try {
            ResourceLocation name = new ResourceLocation("actuallyadditions", tileClass.newInstance().name);
            GameRegistry.registerTileEntity(tileClass, (ResourceLocation)name);
        }
        catch (Exception e) {
            ActuallyAdditions.LOGGER.fatal("Registering a TileEntity failed!", (Throwable)e);
        }
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeSyncableNBT(compound, NBTType.SAVE_TILE);
        return compound;
    }

    public final void func_145839_a(NBTTagCompound compound) {
        this.readSyncableNBT(compound, NBTType.SAVE_TILE);
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeSyncableNBT(compound, NBTType.SYNC);
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, compound);
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readSyncableNBT(pkt.func_148857_g(), NBTType.SYNC);
    }

    public final NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeSyncableNBT(compound, NBTType.SYNC);
        return compound;
    }

    public final void handleUpdateTag(NBTTagCompound compound) {
        this.readSyncableNBT(compound, NBTType.SYNC);
    }

    public final void sendUpdate() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public void writeSyncableNBT(NBTTagCompound compound, NBTType type) {
        if (type != NBTType.SAVE_BLOCK) {
            super.func_189515_b(compound);
        }
        if (type == NBTType.SAVE_TILE) {
            compound.func_74757_a("Redstone", this.isRedstonePowered);
            compound.func_74768_a("TicksElapsed", this.ticksElapsed);
            compound.func_74757_a("StopDrop", this.stopFromDropping);
        } else if (type == NBTType.SYNC && this.stopFromDropping) {
            compound.func_74757_a("StopDrop", this.stopFromDropping);
        }
        if (this.isRedstoneToggle() && (type != NBTType.SAVE_BLOCK || this.isPulseMode)) {
            compound.func_74757_a("IsPulseMode", this.isPulseMode);
        }
    }

    public void readSyncableNBT(NBTTagCompound compound, NBTType type) {
        if (type != NBTType.SAVE_BLOCK) {
            super.func_145839_a(compound);
        }
        if (type == NBTType.SAVE_TILE) {
            this.isRedstonePowered = compound.func_74767_n("Redstone");
            this.ticksElapsed = compound.func_74762_e("TicksElapsed");
            this.stopFromDropping = compound.func_74767_n("StopDrop");
        } else if (type == NBTType.SYNC) {
            this.stopFromDropping = compound.func_74767_n("StopDrop");
        }
        if (this.isRedstoneToggle()) {
            this.isPulseMode = compound.func_74767_n("IsPulseMode");
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return !oldState.func_177230_c().func_149667_c(newState.func_177230_c());
    }

    public String getNameForTranslation() {
        return "container.actuallyadditions." + this.name + ".name";
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.getNameForTranslation(), new Object[0]);
    }

    public final void func_73660_a() {
        this.updateEntity();
    }

    public int getComparatorStrength() {
        return 0;
    }

    public void updateEntity() {
        ++this.ticksElapsed;
        if (!this.field_145850_b.field_72995_K) {
            ISharingFluidHandler handler;
            TileEntity tile;
            int amount;
            EnumFacing[] sides;
            int total;
            ISharingEnergyProvider provider;
            if (this.shareEnergy && (provider = (ISharingEnergyProvider)((Object)this)).doesShareEnergy() && (total = provider.getEnergyToSplitShare()) > 0) {
                sides = provider.getEnergyShareSides();
                amount = total / sides.length;
                if (amount <= 0) {
                    amount = total;
                }
                for (EnumFacing side : sides) {
                    tile = this.tilesAround[side.ordinal()];
                    if (tile == null || !provider.canShareTo(tile)) continue;
                    WorldUtil.doEnergyInteraction(this, tile, side, amount);
                }
            }
            if (this.shareFluid && (handler = (ISharingFluidHandler)((Object)this)).doesShareFluid() && (total = handler.getMaxFluidAmountToSplitShare()) > 0) {
                sides = handler.getFluidShareSides();
                amount = total / sides.length;
                if (amount <= 0) {
                    amount = total;
                }
                for (EnumFacing side : sides) {
                    tile = this.tilesAround[side.ordinal()];
                    if (tile == null) continue;
                    WorldUtil.doFluidInteraction(this, tile, side, amount);
                }
            }
            if (!this.hasSavedDataOnChangeOrWorldStart) {
                if (this.shouldSaveDataOnChangeOrWorldStart()) {
                    this.saveDataOnChangeOrWorldStart();
                }
                this.hasSavedDataOnChangeOrWorldStart = true;
            }
        }
    }

    public void saveDataOnChangeOrWorldStart() {
        for (EnumFacing side : EnumFacing.values()) {
            BlockPos pos = this.field_174879_c.func_177972_a(side);
            if (!this.field_145850_b.func_175667_e(pos)) continue;
            this.tilesAround[side.ordinal()] = this.field_145850_b.func_175625_s(pos);
        }
    }

    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return this instanceof ISharingEnergyProvider || this instanceof ISharingFluidHandler;
    }

    public void setRedstonePowered(boolean powered) {
        this.isRedstonePowered = powered;
        this.func_70296_d();
    }

    public boolean canPlayerUse(EntityPlayer player) {
        return player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0 && !this.func_145837_r() && this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    protected boolean sendUpdateWithInterval() {
        if (this.ticksElapsed % ConfigIntValues.TILE_ENTITY_UPDATE_INTERVAL.getValue() == 0) {
            this.sendUpdate();
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        IEnergyStorage storage;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IItemHandler handler = this.getItemHandler(facing);
            if (handler != null) {
                return (T)handler;
            }
        } else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler tank = this.getFluidHandler(facing);
            if (tank != null) {
                return (T)tank;
            }
        } else if (capability == CapabilityEnergy.ENERGY && (storage = this.getEnergyStorage(facing)) != null) {
            return (T)storage;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return null;
    }

    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return null;
    }

    public IItemHandler getItemHandler(EnumFacing facing) {
        return null;
    }

    public boolean isRedstoneToggle() {
        return false;
    }

    public void activateOnPulse() {
    }

    public boolean respondsToPulses() {
        return this.isRedstoneToggle() && this.isPulseMode;
    }

    public static enum NBTType {
        SAVE_TILE,
        SYNC,
        SAVE_BLOCK;

    }
}

