/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.craftingitem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mod.flatcoloredblocks.ModUtil;
import mod.flatcoloredblocks.block.BlockFlatColored;
import mod.flatcoloredblocks.block.EnumFlatBlockType;
import mod.flatcoloredblocks.block.EnumFlatColorAttributes;
import mod.flatcoloredblocks.block.ItemBlockFlatColored;
import mod.flatcoloredblocks.craftingitem.InventoryColoredBlockCrafter;
import mod.flatcoloredblocks.craftingitem.ItemColoredBlockCrafter;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class FlatColoredBlockRecipe
implements IRecipe {
    private ResourceLocation recipeName = new ResourceLocation("flatcoloredblocks", "flatcoloredblockcrafting");

    public ItemStack getRequirements(InventoryCrafting is) {
        if (is == null) {
            return ModUtil.getEmptyStack();
        }
        ItemStack target = null;
        IBlockState state = null;
        BlockFlatColored flatBlock = null;
        boolean hasCrafter = false;
        ArrayList<ItemStack> otherItems = new ArrayList<ItemStack>();
        for (int x = 0; x < is.func_70302_i_(); ++x) {
            ItemStack i = is.func_70301_a(x);
            if (i == null || i.func_77973_b() == null || ModUtil.isEmpty(i)) continue;
            Block blk = Block.func_149634_a((Item)i.func_77973_b());
            if (blk instanceof BlockFlatColored) {
                if (state != null) {
                    return ModUtil.getEmptyStack();
                }
                flatBlock = (BlockFlatColored)blk;
                target = i.func_77946_l();
                state = ModUtil.getStateFromMeta(blk, i.func_77952_i());
                continue;
            }
            if (i.func_77973_b() instanceof ItemColoredBlockCrafter) {
                if (hasCrafter) {
                    return ModUtil.getEmptyStack();
                }
                hasCrafter = true;
                continue;
            }
            otherItems.add(i);
        }
        if (hasCrafter && target != null && flatBlock != null) {
            Set<EnumFlatColorAttributes> charistics = flatBlock.getFlatColorAttributes(state);
            EnumFlatBlockType Craftable = flatBlock.getCraftable();
            HashSet<EnumDyeColor> requiredDyes = new HashSet<EnumDyeColor>();
            int craftAmount = Craftable instanceof EnumFlatBlockType ? Craftable.getOutputCount() : 1;
            ModUtil.setStackSize(target, craftAmount);
            EnumDyeColor alternateDye = EnumFlatColorAttributes.getAlternateDye(charistics);
            HashSet<EnumDyeColor> alternateSet = new HashSet<EnumDyeColor>();
            if (alternateDye != null) {
                alternateSet.add(alternateDye);
            }
            for (EnumFlatColorAttributes cc : charistics) {
                requiredDyes.add(cc.primaryDye);
                requiredDyes.add(cc.secondaryDye);
            }
            HashMap<Object, List<ItemStack>> dyeList = InventoryColoredBlockCrafter.getDyeList();
            if (!alternateSet.isEmpty() && this.testRequirements(alternateSet, flatBlock.getCraftable(), otherItems, dyeList)) {
                return target;
            }
            if (this.testRequirements(requiredDyes, flatBlock.getCraftable(), otherItems, dyeList)) {
                return target;
            }
        }
        return ModUtil.getEmptyStack();
    }

    private boolean testRequirements(HashSet<EnumDyeColor> requiredDyes, EnumFlatBlockType craftable, List<ItemStack> otherItems, HashMap<Object, List<ItemStack>> dyeList) {
        List<ItemStack> testList = this.cloneList(otherItems);
        List<ItemStack> buildingMaterials = dyeList.get((Object)craftable);
        if (this.findAndRemove(buildingMaterials, testList)) {
            for (EnumDyeColor dye : requiredDyes) {
                if (this.findAndRemove(dyeList.get(dye), testList)) continue;
                return false;
            }
            return testList.isEmpty();
        }
        return false;
    }

    private boolean findAndRemove(List<ItemStack> matchList, List<ItemStack> testList) {
        for (ItemStack match : matchList) {
            for (int idx = 0; idx < testList.size(); ++idx) {
                ItemStack test = testList.get(idx);
                if (!OreDictionary.itemMatches((ItemStack)match, (ItemStack)test, (boolean)false)) continue;
                testList.remove(idx);
                return true;
            }
        }
        return false;
    }

    private List<ItemStack> cloneList(List<ItemStack> otherItems) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        l.addAll(otherItems);
        return l;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return !ModUtil.isEmpty(this.getRequirements(inv));
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.getRequirements(inv);
    }

    public ItemStack func_77571_b() {
        return ModUtil.getEmptyStack();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (is == null) continue;
            if (is.func_77973_b() instanceof ItemColoredBlockCrafter || is.func_77973_b() instanceof ItemBlockFlatColored) {
                ModUtil.alterStack(is, 1);
                continue;
            }
            ItemStack containerItem = ForgeHooks.getContainerItem((ItemStack)is);
            if (containerItem == null || ModUtil.isEmpty(containerItem)) continue;
            ret.set(i, (Object)containerItem);
        }
        return ret;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.recipeName = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.recipeName;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public boolean func_194133_a(int width, int height) {
        return width > 1 || height > 1;
    }

    public boolean func_192399_d() {
        return true;
    }
}

