/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.gui.ContainerAlyzer;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class GuiAlyzer
extends GuiForestry<ContainerAlyzer> {
    public static final int COLUMN_0 = 12;
    public static final int COLUMN_1 = 90;
    public static final int COLUMN_2 = 155;
    private final ItemInventoryAlyzer itemInventory;

    public GuiAlyzer(EntityPlayer player, ItemInventoryAlyzer itemInventory) {
        super("textures/gui/portablealyzer.png", new ContainerAlyzer(itemInventory, player));
        this.itemInventory = itemInventory;
        this.field_146999_f = 246;
        this.field_147000_g = 238;
    }

    public final int getColorCoding(boolean dominant) {
        if (dominant) {
            return ColourProperties.INSTANCE.get("gui.beealyzer.dominant");
        }
        return ColourProperties.INSTANCE.get("gui.beealyzer.recessive");
    }

    public final void drawLine(String text, int x, IIndividual individual, IChromosomeType chromosome, boolean inactive) {
        if (!inactive) {
            this.textLayout.drawLine(text, x, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()));
        } else {
            this.textLayout.drawLine(text, x, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
        }
    }

    public final void drawSplitLine(String text, int x, int maxWidth, IIndividual individual, IChromosomeType chromosome, boolean inactive) {
        if (!inactive) {
            this.textLayout.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()));
        } else {
            this.textLayout.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
        }
    }

    public final void drawRow(String text0, String text1, String text2, IIndividual individual, IChromosomeType chromosome) {
        this.textLayout.drawRow(text0, text1, text2, ColourProperties.INSTANCE.get("gui.screen"), this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()), this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
    }

    public final void drawChromosomeRow(String chromosomeName, IIndividual individual, IChromosomeType chromosome) {
        IAllele active = individual.getGenome().getActiveAllele(chromosome);
        IAllele inactive = individual.getGenome().getInactiveAllele(chromosome);
        this.textLayout.drawRow(chromosomeName, active.getAlleleName(), inactive.getAlleleName(), ColourProperties.INSTANCE.get("gui.screen"), this.getColorCoding(active.isDominant()), this.getColorCoding(inactive.isDominant()));
    }

    public final void drawSpeciesRow(String text0, IIndividual individual, IChromosomeType chromosome, @Nullable String customPrimaryName, @Nullable String customSecondaryName) {
        IAlleleSpecies primary = individual.getGenome().getPrimary();
        IAlleleSpecies secondary = individual.getGenome().getSecondary();
        this.textLayout.drawLine(text0, this.textLayout.column0);
        int columnwidth = this.textLayout.column2 - this.textLayout.column1 - 2;
        Map<String, ItemStack> iconStacks = chromosome.getSpeciesRoot().getAlyzerPlugin().getIconStacks();
        GuiUtil.drawItemStack(this, iconStacks.get(primary.getUID()), this.field_147003_i + this.textLayout.column1 + columnwidth - 20, this.field_147009_r + 10);
        GuiUtil.drawItemStack(this, iconStacks.get(secondary.getUID()), this.field_147003_i + this.textLayout.column2 + columnwidth - 20, this.field_147009_r + 10);
        String primaryName = customPrimaryName == null ? primary.getAlleleName() : customPrimaryName;
        String secondaryName = customSecondaryName == null ? secondary.getAlleleName() : customSecondaryName;
        this.drawSplitLine(primaryName, this.textLayout.column1, columnwidth, individual, chromosome, false);
        this.drawSplitLine(secondaryName, this.textLayout.column2, columnwidth, individual, chromosome, true);
        this.textLayout.newLine();
    }

    @Nullable
    public static String checkCustomName(String key) {
        if (Translator.canTranslateToLocal(key)) {
            return Translator.translateToLocal(key);
        }
        return null;
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        super.func_146976_a(var1, mouseX, mouseY);
        this.widgetManager.clear();
        int specimenSlot = this.getSpecimenSlot();
        if (specimenSlot < 2) {
            this.drawAnalyticsOverview();
            return;
        }
        ItemStack stackInSlot = this.itemInventory.func_70301_a(specimenSlot);
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(stackInSlot);
        if (speciesRoot == null) {
            return;
        }
        switch (specimenSlot) {
            case 2: {
                speciesRoot.getAlyzerPlugin().drawAnalyticsPage1((GuiScreen)this, stackInSlot);
                break;
            }
            case 3: {
                speciesRoot.getAlyzerPlugin().drawAnalyticsPage2((GuiScreen)this, stackInSlot);
                break;
            }
            case 4: {
                speciesRoot.getAlyzerPlugin().drawAnalyticsPage3((GuiScreen)this, stackInSlot);
                break;
            }
            case 5: {
                IIndividual individual = speciesRoot.getMember(stackInSlot);
                this.drawAnalyticsPageMutations(individual);
                break;
            }
            case 6: {
                IIndividual individual = speciesRoot.getMember(stackInSlot);
                this.drawAnalyticsPageClassification(individual);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private int getSpecimenSlot() {
        for (int k = 1; k <= 6; ++k) {
            IIndividual individual;
            ISpeciesRoot speciesRoot;
            ItemStack stackInSlot = this.itemInventory.func_70301_a(k);
            if (stackInSlot.func_190926_b() || (speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(stackInSlot)) == null || !(individual = speciesRoot.getMember(stackInSlot)).isAnalyzed()) continue;
            return k;
        }
        return -1;
    }

    public void drawAnalyticsOverview() {
        this.textLayout.startPage();
        this.textLayout.newLine();
        String title = Translator.translateToLocal("for.gui.portablealyzer").toUpperCase(Locale.ENGLISH);
        this.textLayout.drawCenteredLine(title, 8, 208, ColourProperties.INSTANCE.get("gui.screen"));
        this.textLayout.newLine();
        this.field_146289_q.func_78279_b(Translator.translateToLocal("for.gui.portablealyzer.help"), this.field_147003_i + 12 + 4, this.field_147009_r + 42, 200, ColourProperties.INSTANCE.get("gui.screen"));
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.newLine();
        this.textLayout.drawLine(Translator.translateToLocal("for.gui.alyzer.overview") + ":", 16);
        this.textLayout.newLine();
        this.textLayout.drawLine("I  : " + Translator.translateToLocal("for.gui.general"), 16);
        this.textLayout.newLine();
        this.textLayout.drawLine("II : " + Translator.translateToLocal("for.gui.environment"), 16);
        this.textLayout.newLine();
        this.textLayout.drawLine("III: " + Translator.translateToLocal("for.gui.produce"), 16);
        this.textLayout.newLine();
        this.textLayout.drawLine("IV : " + Translator.translateToLocal("for.gui.evolution"), 16);
        this.textLayout.endPage();
    }

    public final void drawAnalyticsPageClassification(IIndividual individual) {
        this.textLayout.startPage();
        this.textLayout.drawLine(Translator.translateToLocal("for.gui.alyzer.classification") + ":", 12);
        this.textLayout.newLine();
        Stack<IClassification> hierarchy = new Stack<IClassification>();
        for (IClassification classification = individual.getGenome().getPrimary().getBranch(); classification != null; classification = classification.getParent()) {
            if (classification.getScientific().isEmpty()) continue;
            hierarchy.push(classification);
        }
        boolean overcrowded = hierarchy.size() > 5;
        int x = 12;
        IClassification group = null;
        while (!hierarchy.isEmpty()) {
            group = (IClassification)hierarchy.pop();
            if (overcrowded && group.getLevel().isDroppable()) continue;
            this.textLayout.drawLine(group.getScientific(), x, group.getLevel().getColour());
            this.textLayout.drawLine(group.getLevel().name(), 170, group.getLevel().getColour());
            this.textLayout.newLineCompressed();
            x += 12;
        }
        String binomial = individual.getGenome().getPrimary().getBinomial();
        if (group != null && group.getLevel() == IClassification.EnumClassLevel.GENUS) {
            binomial = group.getScientific().substring(0, 1) + ". " + binomial.toLowerCase(Locale.ENGLISH);
        }
        this.textLayout.drawLine(binomial, x, 15445637);
        this.textLayout.drawLine("SPECIES", 170, 15445637);
        this.textLayout.newLine();
        this.textLayout.drawLine(Translator.translateToLocal("for.gui.alyzer.authority") + ": " + individual.getGenome().getPrimary().getAuthority(), 12);
        if (AlleleManager.alleleRegistry.isBlacklisted(individual.getIdent())) {
            String extinct = ">> " + Translator.translateToLocal("for.gui.alyzer.extinct").toUpperCase(Locale.ENGLISH) + " <<";
            this.field_146289_q.func_175063_a(extinct, (float)(this.field_147003_i + 200 - this.field_146289_q.func_78256_a(extinct)), (float)(this.field_147009_r + this.textLayout.getLineY()), ColourProperties.INSTANCE.get("gui.beealyzer.dominant"));
        }
        this.textLayout.newLine();
        String description = individual.getGenome().getPrimary().getDescription();
        if (StringUtils.isBlank((CharSequence)description) || description.startsWith("for.description.")) {
            this.textLayout.drawSplitLine(Translator.translateToLocal("for.gui.alyzer.nodescription"), 12, 200, 0x666666);
        } else {
            String[] tokens = description.split("\\|");
            this.textLayout.drawSplitLine(tokens[0], 12, 200, 0x666666);
            if (tokens.length > 1) {
                String signature = "- " + tokens[1];
                this.field_146289_q.func_175063_a(signature, (float)(this.field_147003_i + 210 - this.field_146289_q.func_78256_a(signature)), (float)(this.field_147009_r + 145 - 14), 10079282);
            }
        }
        this.textLayout.endPage();
    }

    public void drawAnalyticsPageMutations(IIndividual individual) {
        this.textLayout.startPage(12, 90, 155);
        this.textLayout.drawLine(Translator.translateToLocal("for.gui.beealyzer.mutations") + ":", 12);
        this.textLayout.newLine();
        RenderHelper.func_74520_c();
        IGenome genome = individual.getGenome();
        ISpeciesRoot speciesRoot = genome.getSpeciesRoot();
        IAlleleSpecies species = genome.getPrimary();
        int columnWidth = 50;
        int x = 0;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
        for (IMutation iMutation : speciesRoot.getCombinations(species)) {
            if (breedingTracker.isDiscovered(iMutation)) {
                this.drawMutationInfo(iMutation, species, 12 + x, breedingTracker);
            } else {
                if (iMutation.isSecret()) continue;
                this.drawUnknownMutation(iMutation, 12 + x, breedingTracker);
            }
            if ((x += columnWidth) < columnWidth * 4) continue;
            x = 0;
            this.textLayout.newLine(16);
        }
        this.textLayout.endPage();
    }

    public void drawMutationInfo(IMutation combination, IAllele species, int x, IBreedingTracker breedingTracker) {
        Map<String, ItemStack> iconStacks = combination.getRoot().getAlyzerPlugin().getIconStacks();
        ItemStack partnerBee = iconStacks.get(combination.getPartner(species).getUID());
        this.widgetManager.add(new ItemStackWidget(this.widgetManager, x, this.textLayout.getLineY(), partnerBee));
        this.drawProbabilityArrow(combination, this.field_147003_i + x + 18, this.field_147009_r + this.textLayout.getLineY() + 4, breedingTracker);
        IAllele result = combination.getTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
        ItemStack resultBee = iconStacks.get(result.getUID());
        this.widgetManager.add(new ItemStackWidget(this.widgetManager, x + 33, this.textLayout.getLineY(), resultBee));
    }

    private void drawUnknownMutation(IMutation combination, int x, IBreedingTracker breedingTracker) {
        this.drawQuestionMark(this.field_147003_i + x, this.field_147009_r + this.textLayout.getLineY());
        this.drawProbabilityArrow(combination, this.field_147003_i + x + 18, this.field_147009_r + this.textLayout.getLineY() + 4, breedingTracker);
        this.drawQuestionMark(this.field_147003_i + x + 32, this.field_147009_r + this.textLayout.getLineY());
    }

    private void drawQuestionMark(int x, int y) {
        this.bindTexture(this.textureFile);
        this.func_73729_b(x, y, 78, 240, 16, 16);
    }

    private void drawProbabilityArrow(IMutation combination, int x, int y, IBreedingTracker breedingTracker) {
        float chance = combination.getBaseChance();
        int line = 247;
        int column = 100;
        switch (EnumMutateChance.rateChance(chance)) {
            case HIGHEST: {
                column = 100;
                break;
            }
            case HIGHER: {
                column = 115;
                break;
            }
            case HIGH: {
                column = 130;
                break;
            }
            case NORMAL: {
                column = 145;
                break;
            }
            case LOW: {
                column = 160;
                break;
            }
            case LOWEST: {
                column = 175;
            }
        }
        this.bindTexture(this.textureFile);
        this.func_73729_b(x, y, column, line, 15, 9);
        boolean researched = breedingTracker.isResearched(combination);
        if (researched) {
            this.field_146289_q.func_78276_b("+", x + 9, y + 1, 0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawToleranceInfo(IAlleleTolerance toleranceAllele, int x) {
        int textColor = this.getColorCoding(toleranceAllele.isDominant());
        EnumTolerance tolerance = toleranceAllele.getValue();
        String text = "(" + toleranceAllele.getAlleleName() + ")";
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                this.drawBothSymbol(x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(text, x + 14, textColor);
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                this.drawDownSymbol(x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(text, x + 14, textColor);
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                this.drawUpSymbol(x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine(text, x + 14, textColor);
                break;
            }
            default: {
                this.drawNoneSymbol(x - 2, this.textLayout.getLineY() - 1);
                this.textLayout.drawLine("(0)", x + 14, textColor);
            }
        }
    }

    private void drawDownSymbol(int x, int y) {
        this.bindTexture(this.textureFile);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 0, 247, 15, 9);
    }

    private void drawUpSymbol(int x, int y) {
        this.bindTexture(this.textureFile);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 15, 247, 15, 9);
    }

    private void drawBothSymbol(int x, int y) {
        this.bindTexture(this.textureFile);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 30, 247, 15, 9);
    }

    private void drawNoneSymbol(int x, int y) {
        this.bindTexture(this.textureFile);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, 45, 247, 15, 9);
    }

    public void drawFertilityInfo(int fertility, int x, int textColor, int texOffset) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String fertilityString = Integer.toString(fertility) + " x";
        int stringWidth = this.field_146289_q.func_78256_a(fertilityString);
        this.bindTexture(this.textureFile);
        this.func_73729_b(this.field_147003_i + x + stringWidth + 2, this.field_147009_r + this.textLayout.getLineY() - 1, 60, 240 + texOffset, 12, 8);
        this.textLayout.drawLine(fertilityString, x, textColor);
    }

    @Override
    public TextLayoutHelper getTextLayout() {
        return this.textLayout;
    }

    public WidgetManager getWidgetManager() {
        return this.widgetManager;
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.itemInventory);
        this.addHintLedger(this.getHints());
    }

    public List<String> getHints() {
        ISpeciesRoot speciesRoot;
        ItemStack specimen = this.itemInventory.getSpecimen();
        if (!specimen.func_190926_b() && (speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(specimen)) != null) {
            IAlyzerPlugin alyzerPlugin = speciesRoot.getAlyzerPlugin();
            return alyzerPlugin.getHints();
        }
        return Collections.emptyList();
    }
}

