/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketActiveUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final boolean active;

    public PacketActiveUpdate(IActivatable tile) {
        this.pos = tile.getCoordinates();
        this.active = tile.isActive();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.TILE_FORESTRY_ACTIVE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        data.writeBoolean(this.active);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) {
            IMultiblockComponent component;
            BlockPos pos = data.func_179259_c();
            boolean active = data.readBoolean();
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            TileEntity tile = TileUtil.getTile((IBlockAccess)world, pos);
            if (tile instanceof IActivatable) {
                ((IActivatable)tile).setActive(active);
            }
            if (tile instanceof IMultiblockComponent && (component = (IMultiblockComponent)tile).getMultiblockLogic().isConnected() && component.getMultiblockLogic().getController() instanceof IActivatable) {
                ((IActivatable)((Object)component.getMultiblockLogic().getController())).setActive(active);
            }
        }
    }
}

