/*
 * Decompiled with CFR 0.152.
 */
package tehnut.harvest;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;
import tehnut.harvest.BlockStack;
import tehnut.harvest.Crop;
import tehnut.harvest.Harvest;
import tehnut.harvest.HarvestConfig;

public class JsonConfigHandler {
    public static Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().registerTypeAdapter(Crop.class, (Object)new SerializerCrop()).registerTypeAdapter(BlockStack.class, (Object)new SerializerBlockStack()).create();
    public static List<Crop> tempList = Lists.newArrayList();

    public static void init(File configDir) {
        File jsonConfig = new File(configDir, "harvest_config.json");
        File oldConfig = new File(configDir, "harvest.json");
        File scannedOutput = new File(configDir, "harvest_scanned_output.json");
        try {
            FileReader reader;
            if (oldConfig.exists()) {
                reader = new FileReader(oldConfig);
                tempList = (List)gson.fromJson((Reader)reader, new TypeToken<List<Crop>>(){}.getType());
                reader.close();
                FileUtils.forceDelete((File)oldConfig);
            }
            if (!jsonConfig.exists() && jsonConfig.createNewFile()) {
                HarvestConfig config = new HarvestConfig();
                String json = gson.toJson((Object)config);
                FileWriter writer = new FileWriter(jsonConfig);
                writer.write(json);
                writer.close();
            }
            reader = new FileReader(jsonConfig);
            Harvest.config = (HarvestConfig)gson.fromJson((Reader)reader, HarvestConfig.class);
            reader.close();
            Harvest.config.initCropMap();
            if (Harvest.config.runFirstStartSearch()) {
                Stopwatch stopwatch = Stopwatch.createStarted();
                if (scannedOutput.exists()) {
                    scannedOutput.delete();
                }
                ArrayList detected = Lists.newArrayList();
                ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b instanceof BlockCrops).forEach(b -> detected.add(new Crop((Block)b, JsonConfigHandler.getMaxAge(b))));
                String json = gson.toJson((Object)detected);
                FileWriter writer = new FileWriter(scannedOutput);
                writer.write(json);
                writer.close();
                Harvest.LOGGER.info("Discovered {} potential crops in {}", (Object)detected.size(), (Object)stopwatch.stop());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<Crop> handleDefaults() {
        if (!tempList.isEmpty()) {
            return tempList;
        }
        ArrayList defaultList = Lists.newArrayList();
        defaultList.add(new Crop(Blocks.field_150464_aj, JsonConfigHandler.getMaxAge(Blocks.field_150464_aj)));
        defaultList.add(new Crop(Blocks.field_150459_bM, JsonConfigHandler.getMaxAge(Blocks.field_150459_bM)));
        defaultList.add(new Crop(Blocks.field_150469_bN, JsonConfigHandler.getMaxAge(Blocks.field_150469_bN)));
        defaultList.add(new Crop(Blocks.field_185773_cZ, JsonConfigHandler.getMaxAge(Blocks.field_185773_cZ)));
        defaultList.add(new Crop(Blocks.field_150388_bm, 3));
        return defaultList;
    }

    private static int getMaxAge(Block block) {
        if (block instanceof BlockCrops) {
            return ((BlockCrops)block).func_185526_g();
        }
        BlockStateContainer container = block.func_176194_O();
        if (container.func_185920_a("age") != null) {
            IProperty ageProp = container.func_185920_a("age");
            int max = 0;
            for (Integer integer : ageProp.func_177700_c()) {
                max = Math.max(max, integer);
            }
            return max;
        }
        return -1;
    }

    public static class SerializerBlockStack
    implements JsonDeserializer<BlockStack>,
    JsonSerializer<BlockStack> {
        public BlockStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsJsonObject().get("blockName").getAsString();
            int meta = 0;
            if (json.getAsJsonObject().get("meta") != null) {
                meta = json.getAsJsonObject().get("meta").getAsInt();
            }
            return new BlockStack((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name)), meta);
        }

        public JsonElement serialize(BlockStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("blockName", src.getBlock().getRegistryName().toString());
            jsonObject.addProperty("meta", (Number)src.getMeta());
            return jsonObject;
        }
    }

    public static class SerializerCrop
    implements JsonDeserializer<Crop>,
    JsonSerializer<Crop> {
        public Crop deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            BlockStack initialBlock = (BlockStack)context.deserialize(json.getAsJsonObject().get("initialBlock"), BlockStack.class);
            BlockStack finalBlock = new BlockStack(initialBlock.getBlock(), 0);
            if (json.getAsJsonObject().has("finalBlock")) {
                finalBlock = (BlockStack)context.deserialize(json.getAsJsonObject().get("finalBlock"), BlockStack.class);
            }
            return new Crop(initialBlock, finalBlock);
        }

        public JsonElement serialize(Crop src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("initialBlock", context.serialize((Object)src.getInitialBlock()));
            if (src.getFinalBlock().getBlock() != src.getInitialBlock().getBlock() || src.getFinalBlock().getMeta() > 0) {
                jsonObject.add("finalBlock", context.serialize((Object)src.getFinalBlock()));
            }
            return jsonObject;
        }
    }
}

