/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pluggable;

import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PipePluggable {
    public final PluggableDefinition definition;
    public final IPipeHolder holder;
    public final EnumFacing side;

    public PipePluggable(PluggableDefinition definition, IPipeHolder holder, EnumFacing side) {
        this.definition = definition;
        this.holder = holder;
        this.side = side;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        return nbt;
    }

    public void writeCreationPayload(PacketBuffer buffer) {
    }

    public void writePayload(PacketBuffer buffer, Side side) {
    }

    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
    }

    public final void scheduleNetworkUpdate() {
        this.holder.scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.PLUGGABLES[this.side.ordinal()]);
    }

    public void onTick() {
    }

    public abstract AxisAlignedBB getBoundingBox();

    public boolean isBlocking() {
        return false;
    }

    public <T> T getCapability(@Nonnull Capability<T> cap) {
        return null;
    }

    public <T> T getInternalCapability(@Nonnull Capability<T> cap) {
        return null;
    }

    public void onRemove() {
    }

    public void addDrops(NonNullList<ItemStack> toDrop, int fortune) {
        ItemStack stack = this.getPickStack();
        if (!stack.func_190926_b()) {
            toDrop.add((Object)stack);
        }
    }

    public ItemStack getPickStack() {
        return ItemStack.field_190927_a;
    }

    public boolean onPluggableActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Nullable
    public PluggableModelKey getModelRenderKey(BlockRenderLayer layer) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor(int tintIndex) {
        return -1;
    }

    public boolean canBeConnected() {
        return false;
    }

    public boolean isSideSolid() {
        return false;
    }

    public float getExplosionResistance(@Nullable Entity exploder, Explosion explosion) {
        return 0.0f;
    }

    public boolean canConnectToRedstone(@Nullable EnumFacing to) {
        return false;
    }

    public BlockFaceShape getBlockFaceShape() {
        return BlockFaceShape.UNDEFINED;
    }
}

