/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.enums.EnumPowerStage;
import buildcraft.core.BCCoreBlocks;
import buildcraft.core.client.render.RenderEngineCreative;
import buildcraft.core.client.render.RenderEngineWood;
import buildcraft.core.client.render.RenderMarkerVolume;
import buildcraft.core.tile.TileEngineCreative;
import buildcraft.core.tile.TileEngineRedstone_BC8;
import buildcraft.core.tile.TileMarkerVolume;
import buildcraft.lib.client.model.ModelHolderVariable;
import buildcraft.lib.client.model.ModelItemSimple;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.expression.node.value.NodeVariableObject;
import buildcraft.lib.misc.ExpressionCompat;
import buildcraft.lib.misc.data.ModelVariableData;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BCCoreModels {
    private static final NodeVariableDouble ENGINE_PROGRESS;
    private static final NodeVariableObject<EnumPowerStage> ENGINE_STAGE;
    private static final NodeVariableObject<EnumFacing> ENGINE_FACING;
    private static final ModelHolderVariable ENGINE_REDSTONE;
    private static final ModelHolderVariable ENGINE_CREATIVE;

    public static void fmlPreInit() {
        MinecraftForge.EVENT_BUS.register(BCCoreModels.class);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegistry(ModelRegistryEvent event) {
        if (BCCoreBlocks.engine != null) {
            ModelLoader.setCustomStateMapper((Block)BCCoreBlocks.engine, b -> Collections.emptyMap());
        }
    }

    public static void fmlInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileMarkerVolume.class, (TileEntitySpecialRenderer)RenderMarkerVolume.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineRedstone_BC8.class, (TileEntitySpecialRenderer)RenderEngineWood.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineCreative.class, (TileEntitySpecialRenderer)RenderEngineCreative.INSTANCE);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        BCCoreModels.ENGINE_PROGRESS.value = 0.2;
        BCCoreModels.ENGINE_STAGE.value = EnumPowerStage.BLUE;
        BCCoreModels.ENGINE_FACING.value = EnumFacing.UP;
        ModelVariableData varData = new ModelVariableData();
        varData.setNodes(ENGINE_REDSTONE.createTickableNodes());
        varData.tick();
        varData.refresh();
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(EnumEngineType.WOOD.getItemModelLocation(), "inventory"), (Object)new ModelItemSimple(Arrays.stream(ENGINE_REDSTONE.getCutoutQuads()).map(MutableQuad::toBakedItem).collect(Collectors.toList()), ModelItemSimple.TRANSFORM_BLOCK, true));
        BCCoreModels.ENGINE_STAGE.value = EnumPowerStage.BLACK;
        varData.setNodes(ENGINE_CREATIVE.createTickableNodes());
        varData.tick();
        varData.refresh();
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(EnumEngineType.CREATIVE.getItemModelLocation(), "inventory"), (Object)new ModelItemSimple(Arrays.stream(ENGINE_CREATIVE.getCutoutQuads()).map(MutableQuad::toBakedItem).collect(Collectors.toList()), ModelItemSimple.TRANSFORM_BLOCK, true));
    }

    private static MutableQuad[] getEngineQuads(ModelHolderVariable model, TileEngineBase_BC8 tile, float partialTicks) {
        BCCoreModels.ENGINE_PROGRESS.value = tile.getProgressClient(partialTicks);
        BCCoreModels.ENGINE_STAGE.value = tile.getPowerStage();
        BCCoreModels.ENGINE_FACING.value = tile.getCurrentFacing();
        if (tile.clientModelData.hasNoNodes()) {
            tile.clientModelData.setNodes(model.createTickableNodes());
        }
        tile.clientModelData.refresh();
        return model.getCutoutQuads();
    }

    public static MutableQuad[] getRedstoneEngineQuads(TileEngineRedstone_BC8 tile, float partialTicks) {
        return BCCoreModels.getEngineQuads(ENGINE_REDSTONE, tile, partialTicks);
    }

    public static MutableQuad[] getCreativeEngineQuads(TileEngineCreative tile, float partialTicks) {
        return BCCoreModels.getEngineQuads(ENGINE_CREATIVE, tile, partialTicks);
    }

    static {
        FunctionContext fnCtx = new FunctionContext(ExpressionCompat.ENUM_POWER_STAGE, DefaultContexts.createWithAll());
        ENGINE_PROGRESS = fnCtx.putVariableDouble("progress");
        ENGINE_STAGE = fnCtx.putVariableObject("stage", EnumPowerStage.class);
        ENGINE_FACING = fnCtx.putVariableObject("direction", EnumFacing.class);
        ENGINE_REDSTONE = new ModelHolderVariable("buildcraftcore:models/block/engine_redstone.json", fnCtx);
        ENGINE_CREATIVE = new ModelHolderVariable("buildcraftcore:models/block/engine_creative.json", fnCtx);
    }
}

