/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.BCCoreStatements;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.LocaleUtil;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TriggerFluidContainerLevel
extends BCStatement
implements ITriggerExternal {
    public final TriggerType type;

    public TriggerFluidContainerLevel(TriggerType type) {
        super("buildcraft:fluid." + type.name().toLowerCase(Locale.ROOT), "buildcraft.fluid." + type.name().toLowerCase(Locale.ROOT));
        this.type = type;
    }

    @Override
    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return BCCoreSprites.TRIGGER_FLUID_LEVEL.get((Object)this.type);
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public String getDescription() {
        return String.format(LocaleUtil.localize("gate.trigger.fluidlevel.below"), (int)(this.type.level * 100.0f));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer statementContainer, IStatementParameter[] parameters) {
        IFluidTankProperties[] tankPropertiesArray;
        IFluidHandler handler = (IFluidHandler)tile.getCapability(CapUtil.CAP_FLUIDS, side.func_176734_d());
        if (handler == null) {
            return false;
        }
        FluidStack searchedFluid = null;
        if (parameters != null && parameters.length >= 1 && parameters[0] != null && !parameters[0].getItemStack().func_190926_b() && (searchedFluid = FluidUtil.getFluidContained((ItemStack)parameters[0].getItemStack())) != null) {
            searchedFluid.amount = 1;
        }
        if ((tankPropertiesArray = handler.getTankProperties()) == null || tankPropertiesArray.length == 0) {
            return false;
        }
        for (IFluidTankProperties tankProperties : tankPropertiesArray) {
            if (tankProperties == null) continue;
            FluidStack fluid = tankProperties.getContents();
            if (fluid == null) {
                return searchedFluid == null || handler.fill(searchedFluid, false) > 0;
            }
            if (searchedFluid != null && !searchedFluid.isFluidEqual(fluid)) continue;
            float percentage = (float)fluid.amount / (float)tankProperties.getCapacity();
            return percentage < this.type.level;
        }
        return false;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    @Override
    public IStatement[] getPossible() {
        return BCCoreStatements.TRIGGER_FLUID_ALL;
    }

    public static enum TriggerType {
        BELOW25(0.25f),
        BELOW50(0.5f),
        BELOW75(0.75f);

        public static final TriggerType[] VALUES;
        public final float level;

        private TriggerType(float level) {
            this.level = level;
        }

        static {
            VALUES = TriggerType.values();
        }
    }
}

