/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.data;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.ETypeTag;
import buildcraft.lib.client.guide.TypeOrder;
import net.minecraft.util.StringUtils;

public class JsonTypeTags {
    public static final JsonTypeTags EMPTY = new JsonTypeTags("", "", "");
    public final String domain;
    public final String type;
    public final String subType;

    public JsonTypeTags(String domain, String type, String subType) {
        this.domain = domain;
        this.type = type;
        this.subType = subType;
    }

    public JsonTypeTags(String type) {
        this(null, type, null);
    }

    public String[] getOrdered(TypeOrder typeOrder) {
        if (this.domain == null && this.subType == null) {
            return new String[]{this.type};
        }
        String[] strings = new String[typeOrder.tags.size()];
        for (int i = 0; i < strings.length; ++i) {
            ETypeTag tag = (ETypeTag)((Object)typeOrder.tags.get(i));
            strings[i] = this.getTyped(tag);
        }
        return strings;
    }

    private String getTyped(ETypeTag tag) {
        String typed;
        if (tag == ETypeTag.MOD) {
            typed = JsonTypeTags.getMod(this.domain, 0);
        } else if (tag == ETypeTag.SUB_MOD) {
            typed = JsonTypeTags.getMod(this.domain, 1);
        } else if (tag == ETypeTag.TYPE) {
            typed = this.type;
        } else if (tag == ETypeTag.SUB_TYPE) {
            typed = this.subType;
        } else {
            throw new IllegalStateException("Don't know the type " + (Object)((Object)tag));
        }
        return tag.preText + typed;
    }

    private static String getMod(String domain, int index) {
        if (domain.startsWith("buildcraft")) {
            return index == 0 ? "buildcraft" : domain.substring("buildcraft".length());
        }
        return index == 0 ? domain : "";
    }

    public JsonTypeTags inheritMissingTags(JsonTypeTags parent) {
        String d = JsonTypeTags.firstNonEmpty(this.domain, parent.domain, "unknown");
        String t = JsonTypeTags.firstNonEmpty(this.type, parent.type, "unknown");
        String st = JsonTypeTags.firstNonEmpty(this.subType, parent.subType, "unknown");
        return new JsonTypeTags(d, t, st);
    }

    private static String firstNonEmpty(String ... strings) {
        String string;
        String current = null;
        String[] stringArray = strings;
        int n = stringArray.length;
        for (int i = 0; i < n && StringUtils.func_151246_b((String)(current = (string = stringArray[i]))); ++i) {
        }
        return current;
    }

    public void printContents(int indent) {
        StringBuilder f = new StringBuilder();
        while (indent > 0) {
            f.append("  ");
            --indent;
        }
        BCLog.logger.info(f + "domain = " + this.domain + ",");
        BCLog.logger.info(f + "type = " + this.type + ",");
        BCLog.logger.info(f + "sub_type = " + this.subType);
    }
}

